/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Specifices details of port exposed by service.
 */
public final class ContainerServicePort implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String PROTOCOL_TCP = "TCP";

    public static final java.lang.String PROTOCOL_UDP = "UDP";

    public static final java.lang.String PROTOCOL_SCTP = "SCTP";

    private java.lang.String name;

    private java.lang.Long nodePort;

    private java.lang.Long port;

    private java.lang.String protocol;

    private java.lang.String targetPort;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ContainerServicePort() {
    }

    protected ContainerServicePort(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Specifies name of port within the service.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Specifies name of port within the service.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * In case of Kubernetes container cluster, it is port on each node on which the
     * service is exposed, when type of service is NodePort or LoadBalancer. format:
     * int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNodePort() {
        return this.nodePort;
    }

    /**
     * In case of Kubernetes container cluster, it is port on each node on which the
     * service is exposed, when type of service is NodePort or LoadBalancer. format:
     * int64
     *
     * @param nodePort New value for the property.
     */
    public void setNodePort(java.lang.Long nodePort) {
        this.nodePort = nodePort;
    }

    /**
     * Specifies port exposed by the service format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPort() {
        return this.port;
    }

    /**
     * Specifies port exposed by the service format: int64
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.Long port) {
        this.port = port;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ContainerServicePort#PROTOCOL_TCP}</li> <li> {@link
     * com.vmware.nsx.model.ContainerServicePort#PROTOCOL_UDP}</li> <li> {@link
     * com.vmware.nsx.model.ContainerServicePort#PROTOCOL_SCTP}</li> </ul> Specifies IP
     * protocol of the port. e.g. TCP, UDP, SCTP.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtocol() {
        return this.protocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ContainerServicePort#PROTOCOL_TCP}</li> <li> {@link
     * com.vmware.nsx.model.ContainerServicePort#PROTOCOL_UDP}</li> <li> {@link
     * com.vmware.nsx.model.ContainerServicePort#PROTOCOL_SCTP}</li> </ul> Specifies IP
     * protocol of the port. e.g. TCP, UDP, SCTP.
     *
     * @param protocol New value for the property.
     */
    public void setProtocol(java.lang.String protocol) {
        this.protocol = protocol;
    }

    /**
     * Specifies the number or name of port to access on container application instance
     * by the container application. e.g. It is number or name of port to access of pod
     * by service.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTargetPort() {
        return this.targetPort;
    }

    /**
     * Specifies the number or name of port to access on container application instance
     * by the container application. e.g. It is number or name of port to access of pod
     * by service.
     *
     * @param targetPort New value for the property.
     */
    public void setTargetPort(java.lang.String targetPort) {
        this.targetPort = targetPort;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.containerServicePort;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("node_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodePort, this._getType().getField("node_port")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protocol, this._getType().getField("protocol")));
        structValue.setField("target_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.targetPort, this._getType().getField("target_port")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.containerServicePort;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.containerServicePort.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ContainerServicePort _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ContainerServicePort(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ContainerServicePort _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ContainerServicePort(structValue);
    }

    /**
     * Builder class for {@link ContainerServicePort}.
     */
    public static final class Builder {
        private java.lang.String name;
        private java.lang.Long nodePort;
        private java.lang.Long port;
        private java.lang.String protocol;
        private java.lang.String targetPort;

        /**
         * Constructor with parameters for the required properties of
         * {@link ContainerServicePort}.
         */
        public Builder() {
        }

        /**
         * Specifies name of port within the service.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * In case of Kubernetes container cluster, it is port on each node on which the
         * service is exposed, when type of service is NodePort or LoadBalancer. format:
         * int64
         *
         * @param nodePort New value for the property.
         */
        public Builder setNodePort(java.lang.Long nodePort) {
            this.nodePort = nodePort;
            return this;
        }

        /**
         * Specifies port exposed by the service format: int64
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.Long port) {
            this.port = port;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ContainerServicePort#PROTOCOL_TCP}</li> <li> {@link
         * com.vmware.nsx.model.ContainerServicePort#PROTOCOL_UDP}</li> <li> {@link
         * com.vmware.nsx.model.ContainerServicePort#PROTOCOL_SCTP}</li> </ul> Specifies IP
         * protocol of the port. e.g. TCP, UDP, SCTP.
         *
         * @param protocol New value for the property.
         */
        public Builder setProtocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Specifies the number or name of port to access on container application instance
         * by the container application. e.g. It is number or name of port to access of pod
         * by service.
         *
         * @param targetPort New value for the property.
         */
        public Builder setTargetPort(java.lang.String targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        public ContainerServicePort build() {
            ContainerServicePort result = new ContainerServicePort();
            result.setName(this.name);
            result.setNodePort(this.nodePort);
            result.setPort(this.port);
            result.setProtocol(this.protocol);
            result.setTargetPort(this.targetPort);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_port",
                                                                                "nodePort",
                                                                                "getNodePort",
                                                                                "setNodePort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("protocol",
                                                                                "protocol",
                                                                                "getProtocol",
                                                                                "setProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("target_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("target_port",
                                                                                "targetPort",
                                                                                "getTargetPort",
                                                                                "setTargetPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.container_service_port",
                                                            fields,
                                                            com.vmware.nsx.model.ContainerServicePort.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

