/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Details about the destination NSX manager for the migration
 */
public final class DestinationNsxApiEndpoint implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String destinationNsxIp;

    private java.lang.String destinationNsxPassword;

    private java.lang.Long destinationNsxPort;

    private java.lang.String destinationNsxUsername;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DestinationNsxApiEndpoint() {
    }

    protected DestinationNsxApiEndpoint(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * IP address or host name of the destination NSX manager to which the config will
     * be migrated. format: hostname-or-ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getDestinationNsxIp() {
        return this.destinationNsxIp;
    }

    /**
     * IP address or host name of the destination NSX manager to which the config will
     * be migrated. format: hostname-or-ip
     *
     * @param destinationNsxIp New value for the property.
     */
    public void setDestinationNsxIp(java.lang.String destinationNsxIp) {
        this.destinationNsxIp = destinationNsxIp;
    }

    /**
     * Valid password for connecting to the destination NSX manager.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDestinationNsxPassword() {
        return this.destinationNsxPassword;
    }

    /**
     * Valid password for connecting to the destination NSX manager.
     *
     * @param destinationNsxPassword New value for the property.
     */
    public void setDestinationNsxPassword(java.lang.String destinationNsxPassword) {
        this.destinationNsxPassword = destinationNsxPassword;
    }

    /**
     * Destination NSX manager port that will be used to apply details. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getDestinationNsxPort() {
        return this.destinationNsxPort;
    }

    /**
     * Destination NSX manager port that will be used to apply details. format: int32
     *
     * @param destinationNsxPort New value for the property.
     */
    public void setDestinationNsxPort(java.lang.Long destinationNsxPort) {
        this.destinationNsxPort = destinationNsxPort;
    }

    /**
     * Valid username for connecting to the destination NSX manager.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDestinationNsxUsername() {
        return this.destinationNsxUsername;
    }

    /**
     * Valid username for connecting to the destination NSX manager.
     *
     * @param destinationNsxUsername New value for the property.
     */
    public void setDestinationNsxUsername(java.lang.String destinationNsxUsername) {
        this.destinationNsxUsername = destinationNsxUsername;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.destinationNsxApiEndpoint;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("destination_nsx_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationNsxIp, this._getType().getField("destination_nsx_ip")));
        structValue.setField("destination_nsx_password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationNsxPassword, this._getType().getField("destination_nsx_password")));
        structValue.setField("destination_nsx_port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationNsxPort, this._getType().getField("destination_nsx_port")));
        structValue.setField("destination_nsx_username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.destinationNsxUsername, this._getType().getField("destination_nsx_username")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.destinationNsxApiEndpoint;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.destinationNsxApiEndpoint.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DestinationNsxApiEndpoint _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DestinationNsxApiEndpoint(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DestinationNsxApiEndpoint _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DestinationNsxApiEndpoint(structValue);
    }

    /**
     * Builder class for {@link DestinationNsxApiEndpoint}.
     */
    public static final class Builder {
        private java.lang.String destinationNsxIp;
        private java.lang.String destinationNsxPassword;
        private java.lang.Long destinationNsxPort;
        private java.lang.String destinationNsxUsername;

        /**
         * Constructor with parameters for the required properties of
         * {@link DestinationNsxApiEndpoint}.
         */
        public Builder() {
        }

        /**
         * IP address or host name of the destination NSX manager to which the config will
         * be migrated. format: hostname-or-ip
         *
         * @param destinationNsxIp New value for the property.
         */
        public Builder setDestinationNsxIp(java.lang.String destinationNsxIp) {
            this.destinationNsxIp = destinationNsxIp;
            return this;
        }

        /**
         * Valid password for connecting to the destination NSX manager.
         *
         * @param destinationNsxPassword New value for the property.
         */
        public Builder setDestinationNsxPassword(java.lang.String destinationNsxPassword) {
            this.destinationNsxPassword = destinationNsxPassword;
            return this;
        }

        /**
         * Destination NSX manager port that will be used to apply details. format: int32
         *
         * @param destinationNsxPort New value for the property.
         */
        public Builder setDestinationNsxPort(java.lang.Long destinationNsxPort) {
            this.destinationNsxPort = destinationNsxPort;
            return this;
        }

        /**
         * Valid username for connecting to the destination NSX manager.
         *
         * @param destinationNsxUsername New value for the property.
         */
        public Builder setDestinationNsxUsername(java.lang.String destinationNsxUsername) {
            this.destinationNsxUsername = destinationNsxUsername;
            return this;
        }

        public DestinationNsxApiEndpoint build() {
            DestinationNsxApiEndpoint result = new DestinationNsxApiEndpoint();
            result.setDestinationNsxIp(this.destinationNsxIp);
            result.setDestinationNsxPassword(this.destinationNsxPassword);
            result.setDestinationNsxPort(this.destinationNsxPort);
            result.setDestinationNsxUsername(this.destinationNsxUsername);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("destination_nsx_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_nsx_ip",
                                                                                "destinationNsxIp",
                                                                                "getDestinationNsxIp",
                                                                                "setDestinationNsxIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("destination_nsx_password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_nsx_password",
                                                                                "destinationNsxPassword",
                                                                                "getDestinationNsxPassword",
                                                                                "setDestinationNsxPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("destination_nsx_port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_nsx_port",
                                                                                "destinationNsxPort",
                                                                                "getDestinationNsxPort",
                                                                                "setDestinationNsxPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("destination_nsx_username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("destination_nsx_username",
                                                                                "destinationNsxUsername",
                                                                                "getDestinationNsxUsername",
                                                                                "setDestinationNsxUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.destination_nsx_api_endpoint",
                                                            fields,
                                                            com.vmware.nsx.model.DestinationNsxApiEndpoint.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

