/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The current statistics counters of the DNS forwarder including cache usages and
 * query numbers per forwarders.
 */
public final class DnsForwarderStatistics implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<com.vmware.nsx.model.PerForwarderStatistics> conditionalForwarderStatistics;

    private java.lang.Long configuredCacheSize;

    private com.vmware.nsx.model.PerForwarderStatistics defaultForwarderStatistics;

    private java.lang.String errorMessage;

    private java.lang.Long queriesAnsweredLocally;

    private java.lang.Long queriesForwarded;

    private java.lang.Long timestamp;

    private java.lang.Long totalQueries;

    private java.util.List<com.vmware.nsx.model.PerNodeUsedCacheStatistics> usedCacheStatistics;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DnsForwarderStatistics() {
    }

    protected DnsForwarderStatistics(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The statistics of conditional forwarders
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.PerForwarderStatistics> getConditionalForwarderStatistics() {
        return this.conditionalForwarderStatistics;
    }

    /**
     * The statistics of conditional forwarders
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param conditionalForwarderStatistics New value for the property.
     */
    public void setConditionalForwarderStatistics(java.util.List<com.vmware.nsx.model.PerForwarderStatistics> conditionalForwarderStatistics) {
        this.conditionalForwarderStatistics = conditionalForwarderStatistics;
    }

    /**
     * The configured cache size, in kb format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getConfiguredCacheSize() {
        return this.configuredCacheSize;
    }

    /**
     * The configured cache size, in kb format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param configuredCacheSize New value for the property.
     */
    public void setConfiguredCacheSize(java.lang.Long configuredCacheSize) {
        this.configuredCacheSize = configuredCacheSize;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.PerForwarderStatistics getDefaultForwarderStatistics() {
        return this.defaultForwarderStatistics;
    }

    /**
     *
     *
     * @param defaultForwarderStatistics New value for the property.
     */
    public void setDefaultForwarderStatistics(com.vmware.nsx.model.PerForwarderStatistics defaultForwarderStatistics) {
        this.defaultForwarderStatistics = defaultForwarderStatistics;
    }

    /**
     * Error message, if available
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * Error message, if available
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param errorMessage New value for the property.
     */
    public void setErrorMessage(java.lang.String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * The totocal number of queries answered from local cache format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getQueriesAnsweredLocally() {
        return this.queriesAnsweredLocally;
    }

    /**
     * The totocal number of queries answered from local cache format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param queriesAnsweredLocally New value for the property.
     */
    public void setQueriesAnsweredLocally(java.lang.Long queriesAnsweredLocally) {
        this.queriesAnsweredLocally = queriesAnsweredLocally;
    }

    /**
     * The total number of forwarded dns queries format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getQueriesForwarded() {
        return this.queriesForwarded;
    }

    /**
     * The total number of forwarded dns queries format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param queriesForwarded New value for the property.
     */
    public void setQueriesForwarded(java.lang.Long queriesForwarded) {
        this.queriesForwarded = queriesForwarded;
    }

    /**
     * Time stamp of the current statistics, in ms format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTimestamp() {
        return this.timestamp;
    }

    /**
     * Time stamp of the current statistics, in ms format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param timestamp New value for the property.
     */
    public void setTimestamp(java.lang.Long timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * The total number of received dns queries format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTotalQueries() {
        return this.totalQueries;
    }

    /**
     * The total number of received dns queries format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param totalQueries New value for the property.
     */
    public void setTotalQueries(java.lang.Long totalQueries) {
        this.totalQueries = totalQueries;
    }

    /**
     * The statistics of used cache
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.PerNodeUsedCacheStatistics> getUsedCacheStatistics() {
        return this.usedCacheStatistics;
    }

    /**
     * The statistics of used cache
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param usedCacheStatistics New value for the property.
     */
    public void setUsedCacheStatistics(java.util.List<com.vmware.nsx.model.PerNodeUsedCacheStatistics> usedCacheStatistics) {
        this.usedCacheStatistics = usedCacheStatistics;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.dnsForwarderStatistics;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("conditional_forwarder_statistics",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.conditionalForwarderStatistics, this._getType().getField("conditional_forwarder_statistics")));
        structValue.setField("configured_cache_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.configuredCacheSize, this._getType().getField("configured_cache_size")));
        structValue.setField("default_forwarder_statistics",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultForwarderStatistics, this._getType().getField("default_forwarder_statistics")));
        structValue.setField("error_message",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorMessage, this._getType().getField("error_message")));
        structValue.setField("queries_answered_locally",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.queriesAnsweredLocally, this._getType().getField("queries_answered_locally")));
        structValue.setField("queries_forwarded",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.queriesForwarded, this._getType().getField("queries_forwarded")));
        structValue.setField("timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timestamp, this._getType().getField("timestamp")));
        structValue.setField("total_queries",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.totalQueries, this._getType().getField("total_queries")));
        structValue.setField("used_cache_statistics",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.usedCacheStatistics, this._getType().getField("used_cache_statistics")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.dnsForwarderStatistics;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.dnsForwarderStatistics.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DnsForwarderStatistics _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DnsForwarderStatistics(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DnsForwarderStatistics _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DnsForwarderStatistics(structValue);
    }

    /**
     * Builder class for {@link DnsForwarderStatistics}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.PerForwarderStatistics> conditionalForwarderStatistics;
        private java.lang.Long configuredCacheSize;
        private com.vmware.nsx.model.PerForwarderStatistics defaultForwarderStatistics;
        private java.lang.String errorMessage;
        private java.lang.Long queriesAnsweredLocally;
        private java.lang.Long queriesForwarded;
        private java.lang.Long timestamp;
        private java.lang.Long totalQueries;
        private java.util.List<com.vmware.nsx.model.PerNodeUsedCacheStatistics> usedCacheStatistics;

        /**
         * Constructor with parameters for the required properties of
         * {@link DnsForwarderStatistics}.
         */
        public Builder() {
        }

        /**
         * The statistics of conditional forwarders
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param conditionalForwarderStatistics New value for the property.
         */
        public Builder setConditionalForwarderStatistics(java.util.List<com.vmware.nsx.model.PerForwarderStatistics> conditionalForwarderStatistics) {
            this.conditionalForwarderStatistics = conditionalForwarderStatistics;
            return this;
        }

        /**
         * The configured cache size, in kb format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param configuredCacheSize New value for the property.
         */
        public Builder setConfiguredCacheSize(java.lang.Long configuredCacheSize) {
            this.configuredCacheSize = configuredCacheSize;
            return this;
        }

        /**
         *
         *
         * @param defaultForwarderStatistics New value for the property.
         */
        public Builder setDefaultForwarderStatistics(com.vmware.nsx.model.PerForwarderStatistics defaultForwarderStatistics) {
            this.defaultForwarderStatistics = defaultForwarderStatistics;
            return this;
        }

        /**
         * Error message, if available
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param errorMessage New value for the property.
         */
        public Builder setErrorMessage(java.lang.String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        /**
         * The totocal number of queries answered from local cache format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param queriesAnsweredLocally New value for the property.
         */
        public Builder setQueriesAnsweredLocally(java.lang.Long queriesAnsweredLocally) {
            this.queriesAnsweredLocally = queriesAnsweredLocally;
            return this;
        }

        /**
         * The total number of forwarded dns queries format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param queriesForwarded New value for the property.
         */
        public Builder setQueriesForwarded(java.lang.Long queriesForwarded) {
            this.queriesForwarded = queriesForwarded;
            return this;
        }

        /**
         * Time stamp of the current statistics, in ms format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param timestamp New value for the property.
         */
        public Builder setTimestamp(java.lang.Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        /**
         * The total number of received dns queries format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param totalQueries New value for the property.
         */
        public Builder setTotalQueries(java.lang.Long totalQueries) {
            this.totalQueries = totalQueries;
            return this;
        }

        /**
         * The statistics of used cache
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param usedCacheStatistics New value for the property.
         */
        public Builder setUsedCacheStatistics(java.util.List<com.vmware.nsx.model.PerNodeUsedCacheStatistics> usedCacheStatistics) {
            this.usedCacheStatistics = usedCacheStatistics;
            return this;
        }

        public DnsForwarderStatistics build() {
            DnsForwarderStatistics result = new DnsForwarderStatistics();
            result.setConditionalForwarderStatistics(this.conditionalForwarderStatistics);
            result.setConfiguredCacheSize(this.configuredCacheSize);
            result.setDefaultForwarderStatistics(this.defaultForwarderStatistics);
            result.setErrorMessage(this.errorMessage);
            result.setQueriesAnsweredLocally(this.queriesAnsweredLocally);
            result.setQueriesForwarded(this.queriesForwarded);
            result.setTimestamp(this.timestamp);
            result.setTotalQueries(this.totalQueries);
            result.setUsedCacheStatistics(this.usedCacheStatistics);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("conditional_forwarder_statistics", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.perForwarderStatistics; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("conditional_forwarder_statistics",
                                                                                "conditionalForwarderStatistics",
                                                                                "getConditionalForwarderStatistics",
                                                                                "setConditionalForwarderStatistics");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("configured_cache_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("configured_cache_size",
                                                                                "configuredCacheSize",
                                                                                "getConfiguredCacheSize",
                                                                                "setConfiguredCacheSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_forwarder_statistics", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.perForwarderStatistics; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_forwarder_statistics",
                                                                                "defaultForwarderStatistics",
                                                                                "getDefaultForwarderStatistics",
                                                                                "setDefaultForwarderStatistics");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_message", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_message",
                                                                                "errorMessage",
                                                                                "getErrorMessage",
                                                                                "setErrorMessage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("queries_answered_locally", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("queries_answered_locally",
                                                                                "queriesAnsweredLocally",
                                                                                "getQueriesAnsweredLocally",
                                                                                "setQueriesAnsweredLocally");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("queries_forwarded", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("queries_forwarded",
                                                                                "queriesForwarded",
                                                                                "getQueriesForwarded",
                                                                                "setQueriesForwarded");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("timestamp",
                                                                                "timestamp",
                                                                                "getTimestamp",
                                                                                "setTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("total_queries", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("total_queries",
                                                                                "totalQueries",
                                                                                "getTotalQueries",
                                                                                "setTotalQueries");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("used_cache_statistics", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.perNodeUsedCacheStatistics; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("used_cache_statistics",
                                                                                "usedCacheStatistics",
                                                                                "getUsedCacheStatistics",
                                                                                "setUsedCacheStatistics");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.dns_forwarder_statistics",
                                                            fields,
                                                            com.vmware.nsx.model.DnsForwarderStatistics.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

