/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The current runtime status of the DNS forwarder including the hosting transport
 * nodes and forwarder service status.
 */
public final class DnsForwarderStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String STATUS_UP = "UP";

    public static final java.lang.String STATUS_DOWN = "DOWN";

    public static final java.lang.String STATUS_ERROR = "ERROR";

    public static final java.lang.String STATUS_NO_BACKUP = "NO_BACKUP";

    private java.lang.String activeNode;

    private java.lang.String extraMessage;

    private java.lang.String standbyNode;

    private java.lang.String status;

    private java.lang.Long timestamp;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DnsForwarderStatus() {
    }

    protected DnsForwarderStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Uuid of active transport node
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getActiveNode() {
        return this.activeNode;
    }

    /**
     * Uuid of active transport node
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param activeNode New value for the property.
     */
    public void setActiveNode(java.lang.String activeNode) {
        this.activeNode = activeNode;
    }

    /**
     * Extra message, if available
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getExtraMessage() {
        return this.extraMessage;
    }

    /**
     * Extra message, if available
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param extraMessage New value for the property.
     */
    public void setExtraMessage(java.lang.String extraMessage) {
        this.extraMessage = extraMessage;
    }

    /**
     * Uuid of stand_by transport node. null if non-HA mode
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStandbyNode() {
        return this.standbyNode;
    }

    /**
     * Uuid of stand_by transport node. null if non-HA mode
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param standbyNode New value for the property.
     */
    public void setStandbyNode(java.lang.String standbyNode) {
        this.standbyNode = standbyNode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.DnsForwarderStatus#STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.DnsForwarderStatus#STATUS_DOWN}</li> <li> {@link
     * com.vmware.nsx.model.DnsForwarderStatus#STATUS_ERROR}</li> <li> {@link
     * com.vmware.nsx.model.DnsForwarderStatus#STATUS_NO_BACKUP}</li> </ul> UP means
     * the DNS forwarder is working correctly on the active transport node and the
     * stand-by transport node (if present). Failover will occur if either node goes
     * down. DOWN means the DNS forwarder is down on both active transport node and
     * standby node (if present). The DNS forwarder does not function in this
     * situation. Error means there is some error on one or both transport node, or no
     * status was reported from one or both transport nodes. The dns forwarder may be
     * working (or not working). NO_BACKUP means dns forwarder is working in only one
     * transport node, either because it is down on the standby node, or no standby is
     * configured. An forwarder outage will occur if the active node goes down.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStatus() {
        return this.status;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.DnsForwarderStatus#STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.DnsForwarderStatus#STATUS_DOWN}</li> <li> {@link
     * com.vmware.nsx.model.DnsForwarderStatus#STATUS_ERROR}</li> <li> {@link
     * com.vmware.nsx.model.DnsForwarderStatus#STATUS_NO_BACKUP}</li> </ul> UP means
     * the DNS forwarder is working correctly on the active transport node and the
     * stand-by transport node (if present). Failover will occur if either node goes
     * down. DOWN means the DNS forwarder is down on both active transport node and
     * standby node (if present). The DNS forwarder does not function in this
     * situation. Error means there is some error on one or both transport node, or no
     * status was reported from one or both transport nodes. The dns forwarder may be
     * working (or not working). NO_BACKUP means dns forwarder is working in only one
     * transport node, either because it is down on the standby node, or no standby is
     * configured. An forwarder outage will occur if the active node goes down.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param status New value for the property.
     */
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

    /**
     * Time stamp of the current status, in ms format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTimestamp() {
        return this.timestamp;
    }

    /**
     * Time stamp of the current status, in ms format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param timestamp New value for the property.
     */
    public void setTimestamp(java.lang.Long timestamp) {
        this.timestamp = timestamp;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.dnsForwarderStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("active_node",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.activeNode, this._getType().getField("active_node")));
        structValue.setField("extra_message",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.extraMessage, this._getType().getField("extra_message")));
        structValue.setField("standby_node",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.standbyNode, this._getType().getField("standby_node")));
        structValue.setField("status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.status, this._getType().getField("status")));
        structValue.setField("timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.timestamp, this._getType().getField("timestamp")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.dnsForwarderStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.dnsForwarderStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DnsForwarderStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DnsForwarderStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DnsForwarderStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DnsForwarderStatus(structValue);
    }

    /**
     * Builder class for {@link DnsForwarderStatus}.
     */
    public static final class Builder {
        private java.lang.String activeNode;
        private java.lang.String extraMessage;
        private java.lang.String standbyNode;
        private java.lang.String status;
        private java.lang.Long timestamp;

        /**
         * Constructor with parameters for the required properties of
         * {@link DnsForwarderStatus}.
         */
        public Builder() {
        }

        /**
         * Uuid of active transport node
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param activeNode New value for the property.
         */
        public Builder setActiveNode(java.lang.String activeNode) {
            this.activeNode = activeNode;
            return this;
        }

        /**
         * Extra message, if available
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param extraMessage New value for the property.
         */
        public Builder setExtraMessage(java.lang.String extraMessage) {
            this.extraMessage = extraMessage;
            return this;
        }

        /**
         * Uuid of stand_by transport node. null if non-HA mode
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param standbyNode New value for the property.
         */
        public Builder setStandbyNode(java.lang.String standbyNode) {
            this.standbyNode = standbyNode;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.DnsForwarderStatus#STATUS_UP}</li> <li> {@link
         * com.vmware.nsx.model.DnsForwarderStatus#STATUS_DOWN}</li> <li> {@link
         * com.vmware.nsx.model.DnsForwarderStatus#STATUS_ERROR}</li> <li> {@link
         * com.vmware.nsx.model.DnsForwarderStatus#STATUS_NO_BACKUP}</li> </ul> UP means
         * the DNS forwarder is working correctly on the active transport node and the
         * stand-by transport node (if present). Failover will occur if either node goes
         * down. DOWN means the DNS forwarder is down on both active transport node and
         * standby node (if present). The DNS forwarder does not function in this
         * situation. Error means there is some error on one or both transport node, or no
         * status was reported from one or both transport nodes. The dns forwarder may be
         * working (or not working). NO_BACKUP means dns forwarder is working in only one
         * transport node, either because it is down on the standby node, or no standby is
         * configured. An forwarder outage will occur if the active node goes down.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param status New value for the property.
         */
        public Builder setStatus(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Time stamp of the current status, in ms format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param timestamp New value for the property.
         */
        public Builder setTimestamp(java.lang.Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DnsForwarderStatus build() {
            DnsForwarderStatus result = new DnsForwarderStatus();
            result.setActiveNode(this.activeNode);
            result.setExtraMessage(this.extraMessage);
            result.setStandbyNode(this.standbyNode);
            result.setStatus(this.status);
            result.setTimestamp(this.timestamp);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("active_node", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("active_node",
                                                                                "activeNode",
                                                                                "getActiveNode",
                                                                                "setActiveNode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("extra_message", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("extra_message",
                                                                                "extraMessage",
                                                                                "getExtraMessage",
                                                                                "setExtraMessage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("standby_node", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("standby_node",
                                                                                "standbyNode",
                                                                                "getStandbyNode",
                                                                                "setStandbyNode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status",
                                                                                "status",
                                                                                "getStatus",
                                                                                "setStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("timestamp",
                                                                                "timestamp",
                                                                                "getTimestamp",
                                                                                "setTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.dns_forwarder_status",
                                                            fields,
                                                            com.vmware.nsx.model.DnsForwarderStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

