/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Details of data processing unit (DPU) present on a ESXi Host.
 */
public final class DpuInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String STATE_UNAVAILABLE = "UNAVAILABLE";

    public static final java.lang.String STATE_UNMANAGED = "UNMANAGED";

    public static final java.lang.String STATE_UNUSED = "UNUSED";

    public static final java.lang.String STATE_MANAGED = "MANAGED";

    public static final java.lang.String STATE_INVALID = "INVALID";

    private java.lang.String dpuId;

    private java.lang.String firmwareVersion;

    private java.lang.Boolean isPrimary;

    private java.lang.String model;

    private java.lang.String osVersion;

    private java.lang.String state;

    private java.lang.String vendor;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public DpuInfo() {
    }

    protected DpuInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Specifies Id of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDpuId() {
        return this.dpuId;
    }

    /**
     * Specifies Id of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param dpuId New value for the property.
     */
    public void setDpuId(java.lang.String dpuId) {
        this.dpuId = dpuId;
    }

    /**
     * Specifies the firmware version of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    /**
     * Specifies the firmware version of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param firmwareVersion New value for the property.
     */
    public void setFirmwareVersion(java.lang.String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    /**
     * Specifies whether this is considered the primary DPU in the host.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsPrimary() {
        return this.isPrimary;
    }

    /**
     * Specifies whether this is considered the primary DPU in the host.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isPrimary New value for the property.
     */
    public void setIsPrimary(java.lang.Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    /**
     * Specifies the model of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getModel() {
        return this.model;
    }

    /**
     * Specifies the model of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param model New value for the property.
     */
    public void setModel(java.lang.String model) {
        this.model = model;
    }

    /**
     * Specifies the operating system version of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOsVersion() {
        return this.osVersion;
    }

    /**
     * Specifies the operating system version of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param osVersion New value for the property.
     */
    public void setOsVersion(java.lang.String osVersion) {
        this.osVersion = osVersion;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_UNAVAILABLE}</li> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_UNMANAGED}</li> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_UNUSED}</li> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_MANAGED}</li> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_INVALID}</li> </ul> Specifies state of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getState() {
        return this.state;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_UNAVAILABLE}</li> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_UNMANAGED}</li> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_UNUSED}</li> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_MANAGED}</li> <li> {@link
     * com.vmware.nsx.model.DpuInfo#STATE_INVALID}</li> </ul> Specifies state of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param state New value for the property.
     */
    public void setState(java.lang.String state) {
        this.state = state;
    }

    /**
     * Specifies the vendor of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVendor() {
        return this.vendor;
    }

    /**
     * Specifies the vendor of DPU.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param vendor New value for the property.
     */
    public void setVendor(java.lang.String vendor) {
        this.vendor = vendor;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.dpuInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dpu_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dpuId, this._getType().getField("dpu_id")));
        structValue.setField("firmware_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.firmwareVersion, this._getType().getField("firmware_version")));
        structValue.setField("is_primary",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isPrimary, this._getType().getField("is_primary")));
        structValue.setField("model",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.model, this._getType().getField("model")));
        structValue.setField("os_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.osVersion, this._getType().getField("os_version")));
        structValue.setField("state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.state, this._getType().getField("state")));
        structValue.setField("vendor",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vendor, this._getType().getField("vendor")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.dpuInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.dpuInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DpuInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DpuInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DpuInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DpuInfo(structValue);
    }

    /**
     * Builder class for {@link DpuInfo}.
     */
    public static final class Builder {
        private java.lang.String dpuId;
        private java.lang.String firmwareVersion;
        private java.lang.Boolean isPrimary;
        private java.lang.String model;
        private java.lang.String osVersion;
        private java.lang.String state;
        private java.lang.String vendor;

        /**
         * Constructor with parameters for the required properties of
         * {@link DpuInfo}.
         */
        public Builder() {
        }

        /**
         * Specifies Id of DPU.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param dpuId New value for the property.
         */
        public Builder setDpuId(java.lang.String dpuId) {
            this.dpuId = dpuId;
            return this;
        }

        /**
         * Specifies the firmware version of DPU.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param firmwareVersion New value for the property.
         */
        public Builder setFirmwareVersion(java.lang.String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        /**
         * Specifies whether this is considered the primary DPU in the host.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isPrimary New value for the property.
         */
        public Builder setIsPrimary(java.lang.Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        /**
         * Specifies the model of DPU.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param model New value for the property.
         */
        public Builder setModel(java.lang.String model) {
            this.model = model;
            return this;
        }

        /**
         * Specifies the operating system version of DPU.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param osVersion New value for the property.
         */
        public Builder setOsVersion(java.lang.String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.DpuInfo#STATE_UNAVAILABLE}</li> <li> {@link
         * com.vmware.nsx.model.DpuInfo#STATE_UNMANAGED}</li> <li> {@link
         * com.vmware.nsx.model.DpuInfo#STATE_UNUSED}</li> <li> {@link
         * com.vmware.nsx.model.DpuInfo#STATE_MANAGED}</li> <li> {@link
         * com.vmware.nsx.model.DpuInfo#STATE_INVALID}</li> </ul> Specifies state of DPU.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param state New value for the property.
         */
        public Builder setState(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Specifies the vendor of DPU.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param vendor New value for the property.
         */
        public Builder setVendor(java.lang.String vendor) {
            this.vendor = vendor;
            return this;
        }

        public DpuInfo build() {
            DpuInfo result = new DpuInfo();
            result.setDpuId(this.dpuId);
            result.setFirmwareVersion(this.firmwareVersion);
            result.setIsPrimary(this.isPrimary);
            result.setModel(this.model);
            result.setOsVersion(this.osVersion);
            result.setState(this.state);
            result.setVendor(this.vendor);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dpu_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dpu_id",
                                                                                "dpuId",
                                                                                "getDpuId",
                                                                                "setDpuId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("firmware_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("firmware_version",
                                                                                "firmwareVersion",
                                                                                "getFirmwareVersion",
                                                                                "setFirmwareVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_primary", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_primary",
                                                                                "isPrimary",
                                                                                "getIsPrimary",
                                                                                "setIsPrimary");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("model", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("model",
                                                                                "model",
                                                                                "getModel",
                                                                                "setModel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("os_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("os_version",
                                                                                "osVersion",
                                                                                "getOsVersion",
                                                                                "setOsVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("state",
                                                                                "state",
                                                                                "getState",
                                                                                "setState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vendor", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vendor",
                                                                                "vendor",
                                                                                "getVendor",
                                                                                "setVendor");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.dpu_info",
                                                            fields,
                                                            com.vmware.nsx.model.DpuInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

