/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The settings are used during deployment and consequent update of an edge, unless
 * indicated otherwise. These settings are editable for manually deployed edge
 * nodes as well. If using DHCP, you must leave the following fields unset:
 * search_domains, management_port_subnets, dns_servers and
 * default_gateway_addresses. EdgeNodeSettings reports current values configured on
 * the edge node. If the settings lag with actual state on the edge, these may be
 * refreshed at NSX Manager using API POST api/v1/transport-nodes
 * /&lt;transport-node-id&gt;?action=refresh_node_configuration&resource_type=
 * EdgeNode
 */
public final class EdgeNodeSettings implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<com.vmware.nsx.model.KeyValuePair> advancedConfiguration;

    private java.lang.Boolean allowSshRootLogin;

    private java.util.List<java.lang.String> dnsServers;

    private java.lang.Boolean enableSsh;

    private java.lang.Boolean enableUptMode;

    private java.lang.String hostname;

    private java.util.List<java.lang.String> ntpServers;

    private java.util.List<java.lang.String> searchDomains;

    private java.util.List<com.vmware.nsx.model.SyslogConfiguration> syslogServers;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public EdgeNodeSettings() {
    }

    protected EdgeNodeSettings(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Array of additional specific properties for advanced or cloud- specific
     * deployments in key-value format.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.KeyValuePair> getAdvancedConfiguration() {
        return this.advancedConfiguration;
    }

    /**
     * Array of additional specific properties for advanced or cloud- specific
     * deployments in key-value format.
     *
     * @param advancedConfiguration New value for the property.
     */
    public void setAdvancedConfiguration(java.util.List<com.vmware.nsx.model.KeyValuePair> advancedConfiguration) {
        this.advancedConfiguration = advancedConfiguration;
    }

    /**
     * Allowing root SSH logins is not recommended for security reasons. Edit of this
     * property is not supported when updating transport node. Use the CLI to change
     * this property.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAllowSshRootLogin() {
        return this.allowSshRootLogin;
    }

    /**
     * Allowing root SSH logins is not recommended for security reasons. Edit of this
     * property is not supported when updating transport node. Use the CLI to change
     * this property.
     *
     * @param allowSshRootLogin New value for the property.
     */
    public void setAllowSshRootLogin(java.lang.Boolean allowSshRootLogin) {
        this.allowSshRootLogin = allowSshRootLogin;
    }

    /**
     * List of DNS servers. format: ip
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDnsServers() {
        return this.dnsServers;
    }

    /**
     * List of DNS servers. format: ip
     *
     * @param dnsServers New value for the property.
     */
    public void setDnsServers(java.util.List<java.lang.String> dnsServers) {
        this.dnsServers = dnsServers;
    }

    /**
     * Enabling SSH service is not recommended for security reasons.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableSsh() {
        return this.enableSsh;
    }

    /**
     * Enabling SSH service is not recommended for security reasons.
     *
     * @param enableSsh New value for the property.
     */
    public void setEnableSsh(java.lang.Boolean enableSsh) {
        this.enableSsh = enableSsh;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnableUptMode() {
        return this.enableUptMode;
    }

    /**
     *
     *
     * @param enableUptMode New value for the property.
     */
    public void setEnableUptMode(java.lang.Boolean enableUptMode) {
        this.enableUptMode = enableUptMode;
    }

    /**
     * Host name or FQDN for edge node.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostname() {
        return this.hostname;
    }

    /**
     * Host name or FQDN for edge node.
     *
     * @param hostname New value for the property.
     */
    public void setHostname(java.lang.String hostname) {
        this.hostname = hostname;
    }

    /**
     * List of NTP servers. format: hostname-or-ip
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getNtpServers() {
        return this.ntpServers;
    }

    /**
     * List of NTP servers. format: hostname-or-ip
     *
     * @param ntpServers New value for the property.
     */
    public void setNtpServers(java.util.List<java.lang.String> ntpServers) {
        this.ntpServers = ntpServers;
    }

    /**
     * List of domain names that are used to complete unqualified host names.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getSearchDomains() {
        return this.searchDomains;
    }

    /**
     * List of domain names that are used to complete unqualified host names.
     *
     * @param searchDomains New value for the property.
     */
    public void setSearchDomains(java.util.List<java.lang.String> searchDomains) {
        this.searchDomains = searchDomains;
    }

    /**
     * List of Syslog server configuration.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.SyslogConfiguration> getSyslogServers() {
        return this.syslogServers;
    }

    /**
     * List of Syslog server configuration.
     *
     * @param syslogServers New value for the property.
     */
    public void setSyslogServers(java.util.List<com.vmware.nsx.model.SyslogConfiguration> syslogServers) {
        this.syslogServers = syslogServers;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.edgeNodeSettings;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("advanced_configuration",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.advancedConfiguration, this._getType().getField("advanced_configuration")));
        structValue.setField("allow_ssh_root_login",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allowSshRootLogin, this._getType().getField("allow_ssh_root_login")));
        structValue.setField("dns_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsServers, this._getType().getField("dns_servers")));
        structValue.setField("enable_ssh",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableSsh, this._getType().getField("enable_ssh")));
        structValue.setField("enable_upt_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enableUptMode, this._getType().getField("enable_upt_mode")));
        structValue.setField("hostname",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostname, this._getType().getField("hostname")));
        structValue.setField("ntp_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ntpServers, this._getType().getField("ntp_servers")));
        structValue.setField("search_domains",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.searchDomains, this._getType().getField("search_domains")));
        structValue.setField("syslog_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.syslogServers, this._getType().getField("syslog_servers")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.edgeNodeSettings;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.edgeNodeSettings.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static EdgeNodeSettings _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new EdgeNodeSettings(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static EdgeNodeSettings _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new EdgeNodeSettings(structValue);
    }

    /**
     * Builder class for {@link EdgeNodeSettings}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.KeyValuePair> advancedConfiguration;
        private java.lang.Boolean allowSshRootLogin;
        private java.util.List<java.lang.String> dnsServers;
        private java.lang.Boolean enableSsh;
        private java.lang.Boolean enableUptMode;
        private java.lang.String hostname;
        private java.util.List<java.lang.String> ntpServers;
        private java.util.List<java.lang.String> searchDomains;
        private java.util.List<com.vmware.nsx.model.SyslogConfiguration> syslogServers;

        /**
         * Constructor with parameters for the required properties of
         * {@link EdgeNodeSettings}.
         */
        public Builder() {
        }

        /**
         * Array of additional specific properties for advanced or cloud- specific
         * deployments in key-value format.
         *
         * @param advancedConfiguration New value for the property.
         */
        public Builder setAdvancedConfiguration(java.util.List<com.vmware.nsx.model.KeyValuePair> advancedConfiguration) {
            this.advancedConfiguration = advancedConfiguration;
            return this;
        }

        /**
         * Allowing root SSH logins is not recommended for security reasons. Edit of this
         * property is not supported when updating transport node. Use the CLI to change
         * this property.
         *
         * @param allowSshRootLogin New value for the property.
         */
        public Builder setAllowSshRootLogin(java.lang.Boolean allowSshRootLogin) {
            this.allowSshRootLogin = allowSshRootLogin;
            return this;
        }

        /**
         * List of DNS servers. format: ip
         *
         * @param dnsServers New value for the property.
         */
        public Builder setDnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * Enabling SSH service is not recommended for security reasons.
         *
         * @param enableSsh New value for the property.
         */
        public Builder setEnableSsh(java.lang.Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        /**
         *
         *
         * @param enableUptMode New value for the property.
         */
        public Builder setEnableUptMode(java.lang.Boolean enableUptMode) {
            this.enableUptMode = enableUptMode;
            return this;
        }

        /**
         * Host name or FQDN for edge node.
         *
         * @param hostname New value for the property.
         */
        public Builder setHostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * List of NTP servers. format: hostname-or-ip
         *
         * @param ntpServers New value for the property.
         */
        public Builder setNtpServers(java.util.List<java.lang.String> ntpServers) {
            this.ntpServers = ntpServers;
            return this;
        }

        /**
         * List of domain names that are used to complete unqualified host names.
         *
         * @param searchDomains New value for the property.
         */
        public Builder setSearchDomains(java.util.List<java.lang.String> searchDomains) {
            this.searchDomains = searchDomains;
            return this;
        }

        /**
         * List of Syslog server configuration.
         *
         * @param syslogServers New value for the property.
         */
        public Builder setSyslogServers(java.util.List<com.vmware.nsx.model.SyslogConfiguration> syslogServers) {
            this.syslogServers = syslogServers;
            return this;
        }

        public EdgeNodeSettings build() {
            EdgeNodeSettings result = new EdgeNodeSettings();
            result.setAdvancedConfiguration(this.advancedConfiguration);
            result.setAllowSshRootLogin(this.allowSshRootLogin);
            result.setDnsServers(this.dnsServers);
            result.setEnableSsh(this.enableSsh);
            result.setEnableUptMode(this.enableUptMode);
            result.setHostname(this.hostname);
            result.setNtpServers(this.ntpServers);
            result.setSearchDomains(this.searchDomains);
            result.setSyslogServers(this.syslogServers);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("advanced_configuration", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.keyValuePair; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("advanced_configuration",
                                                                                "advancedConfiguration",
                                                                                "getAdvancedConfiguration",
                                                                                "setAdvancedConfiguration");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("allow_ssh_root_login", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allow_ssh_root_login",
                                                                                "allowSshRootLogin",
                                                                                "getAllowSshRootLogin",
                                                                                "setAllowSshRootLogin");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_servers",
                                                                                "dnsServers",
                                                                                "getDnsServers",
                                                                                "setDnsServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_ssh", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_ssh",
                                                                                "enableSsh",
                                                                                "getEnableSsh",
                                                                                "setEnableSsh");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enable_upt_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enable_upt_mode",
                                                                                "enableUptMode",
                                                                                "getEnableUptMode",
                                                                                "setEnableUptMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("hostname", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hostname",
                                                                                "hostname",
                                                                                "getHostname",
                                                                                "setHostname");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ntp_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ntp_servers",
                                                                                "ntpServers",
                                                                                "getNtpServers",
                                                                                "setNtpServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("search_domains", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("search_domains",
                                                                                "searchDomains",
                                                                                "getSearchDomains",
                                                                                "setSearchDomains");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("syslog_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.syslogConfiguration; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("syslog_servers",
                                                                                "syslogServers",
                                                                                "getSyslogServers",
                                                                                "setSyslogServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.edge_node_settings",
                                                            fields,
                                                            com.vmware.nsx.model.EdgeNodeSettings.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

