/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * EntitlementSpec contains full set of subscription offers. EntitlementSpec can be
 * pushed from Entitlement Service to licensing service.
 */
public final class EntitlementSpec implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String instanceId;

    private java.util.List<com.vmware.nsx.model.LicenseOffer> offers;

    private java.lang.String orgId;

    private java.lang.String siteId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public EntitlementSpec() {
    }

    protected EntitlementSpec(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The identifier for an instance. An instance is a set of Sites(On-Prem LMs) or
     * SDDCs.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getInstanceId() {
        return this.instanceId;
    }

    /**
     * The identifier for an instance. An instance is a set of Sites(On-Prem LMs) or
     * SDDCs.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param instanceId New value for the property.
     */
    public void setInstanceId(java.lang.String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * Subscription offers which will be used for the licensing entitlement.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.LicenseOffer> getOffers() {
        return this.offers;
    }

    /**
     * Subscription offers which will be used for the licensing entitlement.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param offers New value for the property.
     */
    public void setOffers(java.util.List<com.vmware.nsx.model.LicenseOffer> offers) {
        this.offers = offers;
    }

    /**
     * The identifier for an org. An org is a CSP tenant. Every service runs in the
     * context of an org within CSP.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOrgId() {
        return this.orgId;
    }

    /**
     * The identifier for an org. An org is a CSP tenant. Every service runs in the
     * context of an org within CSP.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param orgId New value for the property.
     */
    public void setOrgId(java.lang.String orgId) {
        this.orgId = orgId;
    }

    /**
     * Policy Local Manager site id.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSiteId() {
        return this.siteId;
    }

    /**
     * Policy Local Manager site id.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param siteId New value for the property.
     */
    public void setSiteId(java.lang.String siteId) {
        this.siteId = siteId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.entitlementSpec;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("instance_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.instanceId, this._getType().getField("instance_id")));
        structValue.setField("offers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.offers, this._getType().getField("offers")));
        structValue.setField("org_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.orgId, this._getType().getField("org_id")));
        structValue.setField("site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.siteId, this._getType().getField("site_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.entitlementSpec;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.entitlementSpec.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static EntitlementSpec _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new EntitlementSpec(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static EntitlementSpec _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new EntitlementSpec(structValue);
    }

    /**
     * Builder class for {@link EntitlementSpec}.
     */
    public static final class Builder {
        private java.lang.String instanceId;
        private java.util.List<com.vmware.nsx.model.LicenseOffer> offers;
        private java.lang.String orgId;
        private java.lang.String siteId;

        /**
         * Constructor with parameters for the required properties of
         * {@link EntitlementSpec}.
         */
        public Builder() {
        }

        /**
         * The identifier for an instance. An instance is a set of Sites(On-Prem LMs) or
         * SDDCs.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param instanceId New value for the property.
         */
        public Builder setInstanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Subscription offers which will be used for the licensing entitlement.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param offers New value for the property.
         */
        public Builder setOffers(java.util.List<com.vmware.nsx.model.LicenseOffer> offers) {
            this.offers = offers;
            return this;
        }

        /**
         * The identifier for an org. An org is a CSP tenant. Every service runs in the
         * context of an org within CSP.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param orgId New value for the property.
         */
        public Builder setOrgId(java.lang.String orgId) {
            this.orgId = orgId;
            return this;
        }

        /**
         * Policy Local Manager site id.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param siteId New value for the property.
         */
        public Builder setSiteId(java.lang.String siteId) {
            this.siteId = siteId;
            return this;
        }

        public EntitlementSpec build() {
            EntitlementSpec result = new EntitlementSpec();
            result.setInstanceId(this.instanceId);
            result.setOffers(this.offers);
            result.setOrgId(this.orgId);
            result.setSiteId(this.siteId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("instance_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("instance_id",
                                                                                "instanceId",
                                                                                "getInstanceId",
                                                                                "setInstanceId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("offers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.licenseOffer; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("offers",
                                                                                "offers",
                                                                                "getOffers",
                                                                                "setOffers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("org_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("org_id",
                                                                                "orgId",
                                                                                "getOrgId",
                                                                                "setOrgId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("site_id",
                                                                                "siteId",
                                                                                "getSiteId",
                                                                                "setSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.entitlement_spec",
                                                            fields,
                                                            com.vmware.nsx.model.EntitlementSpec.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

