/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * A profile holding TCP, UDP and ICMP session timeout configuration.
 */
public final class FirewallSessionTimerProfile implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "FirewallSessionTimerProfile";

    private java.lang.Long icmpErrorReply;

    private java.lang.Long icmpFirstPacket;

    private java.lang.Long tcpClosed;

    private java.lang.Long tcpClosing;

    private java.lang.Long tcpEstablished;

    private java.lang.Long tcpFinwait;

    private java.lang.Long tcpFirstPacket;

    private java.lang.Long tcpOpening;

    private java.lang.Long udpFirstPacket;

    private java.lang.Long udpMultiple;

    private java.lang.Long udpSingle;

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private final java.lang.String resourceType = "FirewallSessionTimerProfile";

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public FirewallSessionTimerProfile() {
    }

    protected FirewallSessionTimerProfile(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The timeout value for the connection after an ICMP error came back in response
     * to an ICMP packet. The default value for Edges (i.e, Gateway, or Logical Router)
     * may be different than Distributed Firewall hosts. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIcmpErrorReply() {
        return this.icmpErrorReply;
    }

    /**
     * The timeout value for the connection after an ICMP error came back in response
     * to an ICMP packet. The default value for Edges (i.e, Gateway, or Logical Router)
     * may be different than Distributed Firewall hosts. format: int64
     *
     * @param icmpErrorReply New value for the property.
     */
    public void setIcmpErrorReply(java.lang.Long icmpErrorReply) {
        this.icmpErrorReply = icmpErrorReply;
    }

    /**
     * The timeout value of connection in seconds after the first packet. This will be
     * the initial timeout for the new ICMP flow. The default value for Edges (i.e,
     * Gateway, or Logical Router) may be different than Distributed Firewall hosts.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIcmpFirstPacket() {
        return this.icmpFirstPacket;
    }

    /**
     * The timeout value of connection in seconds after the first packet. This will be
     * the initial timeout for the new ICMP flow. The default value for Edges (i.e,
     * Gateway, or Logical Router) may be different than Distributed Firewall hosts.
     * format: int64
     *
     * @param icmpFirstPacket New value for the property.
     */
    public void setIcmpFirstPacket(java.lang.Long icmpFirstPacket) {
        this.icmpFirstPacket = icmpFirstPacket;
    }

    /**
     * The timeout value of connection in seconds after one endpoint sends an RST. The
     * default value for Edges (i.e, Gateway, or Logical Router) may be different than
     * Distributed Firewall hosts. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTcpClosed() {
        return this.tcpClosed;
    }

    /**
     * The timeout value of connection in seconds after one endpoint sends an RST. The
     * default value for Edges (i.e, Gateway, or Logical Router) may be different than
     * Distributed Firewall hosts. format: int64
     *
     * @param tcpClosed New value for the property.
     */
    public void setTcpClosed(java.lang.Long tcpClosed) {
        this.tcpClosed = tcpClosed;
    }

    /**
     * The timeout value of connection in seconds after the first FIN has been sent.
     * The default value for Edges (i.e, Gateway, or Logical Router) may be different
     * than Distributed Firewall hosts. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTcpClosing() {
        return this.tcpClosing;
    }

    /**
     * The timeout value of connection in seconds after the first FIN has been sent.
     * The default value for Edges (i.e, Gateway, or Logical Router) may be different
     * than Distributed Firewall hosts. format: int64
     *
     * @param tcpClosing New value for the property.
     */
    public void setTcpClosing(java.lang.Long tcpClosing) {
        this.tcpClosing = tcpClosing;
    }

    /**
     * The timeout value of connection in seconds once the connection has become fully
     * established. The default value for Edges (i.e, Gateway, or Logical Router) may
     * be different than Distributed Firewall hosts. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTcpEstablished() {
        return this.tcpEstablished;
    }

    /**
     * The timeout value of connection in seconds once the connection has become fully
     * established. The default value for Edges (i.e, Gateway, or Logical Router) may
     * be different than Distributed Firewall hosts. format: int64
     *
     * @param tcpEstablished New value for the property.
     */
    public void setTcpEstablished(java.lang.Long tcpEstablished) {
        this.tcpEstablished = tcpEstablished;
    }

    /**
     * The timeout value of connection in seconds after both FINs have been exchanged
     * and connection is closed. The default value for Edges (i.e, Gateway, or Logical
     * Router) may be different than Distributed Firewall hosts. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTcpFinwait() {
        return this.tcpFinwait;
    }

    /**
     * The timeout value of connection in seconds after both FINs have been exchanged
     * and connection is closed. The default value for Edges (i.e, Gateway, or Logical
     * Router) may be different than Distributed Firewall hosts. format: int64
     *
     * @param tcpFinwait New value for the property.
     */
    public void setTcpFinwait(java.lang.Long tcpFinwait) {
        this.tcpFinwait = tcpFinwait;
    }

    /**
     * The timeout value of connection in seconds after the first packet has been sent.
     * The default value for Edges (i.e, Gateway, or Logical Router) may be different
     * than Distributed Firewall hosts. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTcpFirstPacket() {
        return this.tcpFirstPacket;
    }

    /**
     * The timeout value of connection in seconds after the first packet has been sent.
     * The default value for Edges (i.e, Gateway, or Logical Router) may be different
     * than Distributed Firewall hosts. format: int64
     *
     * @param tcpFirstPacket New value for the property.
     */
    public void setTcpFirstPacket(java.lang.Long tcpFirstPacket) {
        this.tcpFirstPacket = tcpFirstPacket;
    }

    /**
     * The timeout value of connection in seconds after a second packet has been
     * transferred. The default value for Edges (i.e, Gateway, or Logical Router) may
     * be different than Distributed Firewall hosts. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTcpOpening() {
        return this.tcpOpening;
    }

    /**
     * The timeout value of connection in seconds after a second packet has been
     * transferred. The default value for Edges (i.e, Gateway, or Logical Router) may
     * be different than Distributed Firewall hosts. format: int64
     *
     * @param tcpOpening New value for the property.
     */
    public void setTcpOpening(java.lang.Long tcpOpening) {
        this.tcpOpening = tcpOpening;
    }

    /**
     * The timeout value of connection in seconds after the first packet. This will be
     * the initial timeout for the new UDP flow. The default value for Edges (i.e,
     * Gateway, or Logical Router) may be different than Distributed Firewall hosts.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUdpFirstPacket() {
        return this.udpFirstPacket;
    }

    /**
     * The timeout value of connection in seconds after the first packet. This will be
     * the initial timeout for the new UDP flow. The default value for Edges (i.e,
     * Gateway, or Logical Router) may be different than Distributed Firewall hosts.
     * format: int64
     *
     * @param udpFirstPacket New value for the property.
     */
    public void setUdpFirstPacket(java.lang.Long udpFirstPacket) {
        this.udpFirstPacket = udpFirstPacket;
    }

    /**
     * The timeout value of connection in seconds if both hosts have sent packets. The
     * default value for Edges (i.e, Gateway, or Logical Router) may be different than
     * Distributed Firewall hosts. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUdpMultiple() {
        return this.udpMultiple;
    }

    /**
     * The timeout value of connection in seconds if both hosts have sent packets. The
     * default value for Edges (i.e, Gateway, or Logical Router) may be different than
     * Distributed Firewall hosts. format: int64
     *
     * @param udpMultiple New value for the property.
     */
    public void setUdpMultiple(java.lang.Long udpMultiple) {
        this.udpMultiple = udpMultiple;
    }

    /**
     * The timeout value of connection in seconds if the source host sends more than
     * one packet but the destination host has never sent one back. The default value
     * for Edges (i.e, Gateway, or Logical Router) may be different than Distributed
     * Firewall hosts. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getUdpSingle() {
        return this.udpSingle;
    }

    /**
     * The timeout value of connection in seconds if the source host sends more than
     * one packet but the destination host has never sent one back. The default value
     * for Edges (i.e, Gateway, or Logical Router) may be different than Distributed
     * Firewall hosts. format: int64
     *
     * @param udpSingle New value for the property.
     */
    public void setUdpSingle(java.lang.Long udpSingle) {
        this.udpSingle = udpSingle;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.BaseFirewallProfile#RESOURCE_TYPE_FIREWALLSESSIONTIMERPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.BaseFirewallProfile#RESOURCE_TYPE_FIREWALLCPUMEMTHRESHOLDSPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.BaseFirewallProfile#RESOURCE_TYPE_FIREWALLFLOODPROTECTIONPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.BaseFirewallProfile#RESOURCE_TYPE_FIREWALLDNSPROFILE}</li>
     * <li> {@link
     * com.vmware.nsx.model.BaseFirewallProfile#RESOURCE_TYPE_GENERALSECURITYSETTINGSPROFILE}</li>
     * </ul> Resource type to use as profile type
     * The value of this property is automatically populated to {@code "FirewallSessionTimerProfile"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.firewallSessionTimerProfile;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("icmp_error_reply",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.icmpErrorReply, this._getType().getField("icmp_error_reply")));
        structValue.setField("icmp_first_packet",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.icmpFirstPacket, this._getType().getField("icmp_first_packet")));
        structValue.setField("tcp_closed",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tcpClosed, this._getType().getField("tcp_closed")));
        structValue.setField("tcp_closing",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tcpClosing, this._getType().getField("tcp_closing")));
        structValue.setField("tcp_established",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tcpEstablished, this._getType().getField("tcp_established")));
        structValue.setField("tcp_finwait",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tcpFinwait, this._getType().getField("tcp_finwait")));
        structValue.setField("tcp_first_packet",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tcpFirstPacket, this._getType().getField("tcp_first_packet")));
        structValue.setField("tcp_opening",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tcpOpening, this._getType().getField("tcp_opening")));
        structValue.setField("udp_first_packet",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.udpFirstPacket, this._getType().getField("udp_first_packet")));
        structValue.setField("udp_multiple",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.udpMultiple, this._getType().getField("udp_multiple")));
        structValue.setField("udp_single",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.udpSingle, this._getType().getField("udp_single")));
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.firewallSessionTimerProfile;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.firewallSessionTimerProfile.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static FirewallSessionTimerProfile _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new FirewallSessionTimerProfile(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static FirewallSessionTimerProfile _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new FirewallSessionTimerProfile(structValue);
    }

    /**
     * Builder class for {@link FirewallSessionTimerProfile}.
     */
    public static final class Builder {
        private java.lang.Long icmpErrorReply;
        private java.lang.Long icmpFirstPacket;
        private java.lang.Long tcpClosed;
        private java.lang.Long tcpClosing;
        private java.lang.Long tcpEstablished;
        private java.lang.Long tcpFinwait;
        private java.lang.Long tcpFirstPacket;
        private java.lang.Long tcpOpening;
        private java.lang.Long udpFirstPacket;
        private java.lang.Long udpMultiple;
        private java.lang.Long udpSingle;
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.util.List<com.vmware.nsx.model.Tag> tags;

        /**
         * Constructor with parameters for the required properties of
         * {@link FirewallSessionTimerProfile}.
         */
        public Builder() {
        }

        /**
         * The timeout value for the connection after an ICMP error came back in response
         * to an ICMP packet. The default value for Edges (i.e, Gateway, or Logical Router)
         * may be different than Distributed Firewall hosts. format: int64
         *
         * @param icmpErrorReply New value for the property.
         */
        public Builder setIcmpErrorReply(java.lang.Long icmpErrorReply) {
            this.icmpErrorReply = icmpErrorReply;
            return this;
        }

        /**
         * The timeout value of connection in seconds after the first packet. This will be
         * the initial timeout for the new ICMP flow. The default value for Edges (i.e,
         * Gateway, or Logical Router) may be different than Distributed Firewall hosts.
         * format: int64
         *
         * @param icmpFirstPacket New value for the property.
         */
        public Builder setIcmpFirstPacket(java.lang.Long icmpFirstPacket) {
            this.icmpFirstPacket = icmpFirstPacket;
            return this;
        }

        /**
         * The timeout value of connection in seconds after one endpoint sends an RST. The
         * default value for Edges (i.e, Gateway, or Logical Router) may be different than
         * Distributed Firewall hosts. format: int64
         *
         * @param tcpClosed New value for the property.
         */
        public Builder setTcpClosed(java.lang.Long tcpClosed) {
            this.tcpClosed = tcpClosed;
            return this;
        }

        /**
         * The timeout value of connection in seconds after the first FIN has been sent.
         * The default value for Edges (i.e, Gateway, or Logical Router) may be different
         * than Distributed Firewall hosts. format: int64
         *
         * @param tcpClosing New value for the property.
         */
        public Builder setTcpClosing(java.lang.Long tcpClosing) {
            this.tcpClosing = tcpClosing;
            return this;
        }

        /**
         * The timeout value of connection in seconds once the connection has become fully
         * established. The default value for Edges (i.e, Gateway, or Logical Router) may
         * be different than Distributed Firewall hosts. format: int64
         *
         * @param tcpEstablished New value for the property.
         */
        public Builder setTcpEstablished(java.lang.Long tcpEstablished) {
            this.tcpEstablished = tcpEstablished;
            return this;
        }

        /**
         * The timeout value of connection in seconds after both FINs have been exchanged
         * and connection is closed. The default value for Edges (i.e, Gateway, or Logical
         * Router) may be different than Distributed Firewall hosts. format: int64
         *
         * @param tcpFinwait New value for the property.
         */
        public Builder setTcpFinwait(java.lang.Long tcpFinwait) {
            this.tcpFinwait = tcpFinwait;
            return this;
        }

        /**
         * The timeout value of connection in seconds after the first packet has been sent.
         * The default value for Edges (i.e, Gateway, or Logical Router) may be different
         * than Distributed Firewall hosts. format: int64
         *
         * @param tcpFirstPacket New value for the property.
         */
        public Builder setTcpFirstPacket(java.lang.Long tcpFirstPacket) {
            this.tcpFirstPacket = tcpFirstPacket;
            return this;
        }

        /**
         * The timeout value of connection in seconds after a second packet has been
         * transferred. The default value for Edges (i.e, Gateway, or Logical Router) may
         * be different than Distributed Firewall hosts. format: int64
         *
         * @param tcpOpening New value for the property.
         */
        public Builder setTcpOpening(java.lang.Long tcpOpening) {
            this.tcpOpening = tcpOpening;
            return this;
        }

        /**
         * The timeout value of connection in seconds after the first packet. This will be
         * the initial timeout for the new UDP flow. The default value for Edges (i.e,
         * Gateway, or Logical Router) may be different than Distributed Firewall hosts.
         * format: int64
         *
         * @param udpFirstPacket New value for the property.
         */
        public Builder setUdpFirstPacket(java.lang.Long udpFirstPacket) {
            this.udpFirstPacket = udpFirstPacket;
            return this;
        }

        /**
         * The timeout value of connection in seconds if both hosts have sent packets. The
         * default value for Edges (i.e, Gateway, or Logical Router) may be different than
         * Distributed Firewall hosts. format: int64
         *
         * @param udpMultiple New value for the property.
         */
        public Builder setUdpMultiple(java.lang.Long udpMultiple) {
            this.udpMultiple = udpMultiple;
            return this;
        }

        /**
         * The timeout value of connection in seconds if the source host sends more than
         * one packet but the destination host has never sent one back. The default value
         * for Edges (i.e, Gateway, or Logical Router) may be different than Distributed
         * Firewall hosts. format: int64
         *
         * @param udpSingle New value for the property.
         */
        public Builder setUdpSingle(java.lang.Long udpSingle) {
            this.udpSingle = udpSingle;
            return this;
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        public FirewallSessionTimerProfile build() {
            FirewallSessionTimerProfile result = new FirewallSessionTimerProfile();
            result.setIcmpErrorReply(this.icmpErrorReply);
            result.setIcmpFirstPacket(this.icmpFirstPacket);
            result.setTcpClosed(this.tcpClosed);
            result.setTcpClosing(this.tcpClosing);
            result.setTcpEstablished(this.tcpEstablished);
            result.setTcpFinwait(this.tcpFinwait);
            result.setTcpFirstPacket(this.tcpFirstPacket);
            result.setTcpOpening(this.tcpOpening);
            result.setUdpFirstPacket(this.udpFirstPacket);
            result.setUdpMultiple(this.udpMultiple);
            result.setUdpSingle(this.udpSingle);
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setTags(this.tags);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("icmp_error_reply", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("icmp_error_reply",
                                                                                "icmpErrorReply",
                                                                                "getIcmpErrorReply",
                                                                                "setIcmpErrorReply");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("icmp_first_packet", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("icmp_first_packet",
                                                                                "icmpFirstPacket",
                                                                                "getIcmpFirstPacket",
                                                                                "setIcmpFirstPacket");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tcp_closed", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tcp_closed",
                                                                                "tcpClosed",
                                                                                "getTcpClosed",
                                                                                "setTcpClosed");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tcp_closing", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tcp_closing",
                                                                                "tcpClosing",
                                                                                "getTcpClosing",
                                                                                "setTcpClosing");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tcp_established", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tcp_established",
                                                                                "tcpEstablished",
                                                                                "getTcpEstablished",
                                                                                "setTcpEstablished");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tcp_finwait", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tcp_finwait",
                                                                                "tcpFinwait",
                                                                                "getTcpFinwait",
                                                                                "setTcpFinwait");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tcp_first_packet", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tcp_first_packet",
                                                                                "tcpFirstPacket",
                                                                                "getTcpFirstPacket",
                                                                                "setTcpFirstPacket");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tcp_opening", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tcp_opening",
                                                                                "tcpOpening",
                                                                                "getTcpOpening",
                                                                                "setTcpOpening");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("udp_first_packet", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("udp_first_packet",
                                                                                "udpFirstPacket",
                                                                                "getUdpFirstPacket",
                                                                                "setUdpFirstPacket");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("udp_multiple", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("udp_multiple",
                                                                                "udpMultiple",
                                                                                "getUdpMultiple",
                                                                                "setUdpMultiple");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("udp_single", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("udp_single",
                                                                                "udpSingle",
                                                                                "getUdpSingle",
                                                                                "setUdpSingle");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.firewall_session_timer_profile",
                                                            fields,
                                                            com.vmware.nsx.model.FirewallSessionTimerProfile.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "FirewallSessionTimerProfile");
    }
}

