/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * HTTP Service properties
 */
public final class HttpServiceProperties implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String LOGGING_LEVEL_OFF = "OFF";

    public static final java.lang.String LOGGING_LEVEL_FATAL = "FATAL";

    public static final java.lang.String LOGGING_LEVEL_ERROR = "ERROR";

    public static final java.lang.String LOGGING_LEVEL_WARN = "WARN";

    public static final java.lang.String LOGGING_LEVEL_INFO = "INFO";

    public static final java.lang.String LOGGING_LEVEL_DEBUG = "DEBUG";

    public static final java.lang.String LOGGING_LEVEL_TRACE = "TRACE";

    private java.lang.Boolean basicAuthenticationEnabled;

    private com.vmware.nsx.model.Certificate certificate;

    private java.util.List<com.vmware.nsx.model.CipherSuite> cipherSuites;

    private java.lang.Long clientApiConcurrencyLimit;

    private java.lang.Long clientApiRateLimit;

    private java.lang.Long connectionTimeout;

    private java.lang.Boolean cookieBasedAuthenticationEnabled;

    private java.lang.Long globalApiConcurrencyLimit;

    private java.lang.String loggingLevel;

    private java.util.List<com.vmware.nsx.model.ProtocolVersion> protocolVersions;

    private java.lang.String redirectHost;

    private java.lang.Long sessionTimeout;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public HttpServiceProperties() {
    }

    protected HttpServiceProperties(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Identifies whether basic authentication is enabled or disabled in API calls.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Boolean getBasicAuthenticationEnabled() {
        return this.basicAuthenticationEnabled;
    }

    /**
     * Identifies whether basic authentication is enabled or disabled in API calls.
     *
     * @param basicAuthenticationEnabled New value for the property.
     */
    @Deprecated
    public void setBasicAuthenticationEnabled(java.lang.Boolean basicAuthenticationEnabled) {
        this.basicAuthenticationEnabled = basicAuthenticationEnabled;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.Certificate getCertificate() {
        return this.certificate;
    }

    /**
     *
     *
     * @param certificate New value for the property.
     */
    public void setCertificate(com.vmware.nsx.model.Certificate certificate) {
        this.certificate = certificate;
    }

    /**
     * Cipher suites used to secure contents of connection
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.CipherSuite> getCipherSuites() {
        return this.cipherSuites;
    }

    /**
     * Cipher suites used to secure contents of connection
     *
     * @param cipherSuites New value for the property.
     */
    @Deprecated
    public void setCipherSuites(java.util.List<com.vmware.nsx.model.CipherSuite> cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    /**
     * The maximum number of concurrent API requests that will be serviced for a given
     * authenticated client. If the number of API requests being processed exceeds this
     * limit, new API requests will be refused and a 503 Service Unavailable response
     * will be returned to the client. To disable API concurrency limiting, set this
     * value to 0. format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getClientApiConcurrencyLimit() {
        return this.clientApiConcurrencyLimit;
    }

    /**
     * The maximum number of concurrent API requests that will be serviced for a given
     * authenticated client. If the number of API requests being processed exceeds this
     * limit, new API requests will be refused and a 503 Service Unavailable response
     * will be returned to the client. To disable API concurrency limiting, set this
     * value to 0. format: int64
     *
     * @param clientApiConcurrencyLimit New value for the property.
     */
    @Deprecated
    public void setClientApiConcurrencyLimit(java.lang.Long clientApiConcurrencyLimit) {
        this.clientApiConcurrencyLimit = clientApiConcurrencyLimit;
    }

    /**
     * The maximum number of API requests that will be serviced per second for a given
     * authenticated client. If more API requests are received than can be serviced, a
     * 429 Too Many Requests HTTP response will be returned. To disable API rate
     * limiting, set this value to 0. format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getClientApiRateLimit() {
        return this.clientApiRateLimit;
    }

    /**
     * The maximum number of API requests that will be serviced per second for a given
     * authenticated client. If more API requests are received than can be serviced, a
     * 429 Too Many Requests HTTP response will be returned. To disable API rate
     * limiting, set this value to 0. format: int64
     *
     * @param clientApiRateLimit New value for the property.
     */
    @Deprecated
    public void setClientApiRateLimit(java.lang.Long clientApiRateLimit) {
        this.clientApiRateLimit = clientApiRateLimit;
    }

    /**
     * NSX connection timeout, set to 0 to configure no timeout format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    /**
     * NSX connection timeout, set to 0 to configure no timeout format: int64
     *
     * @param connectionTimeout New value for the property.
     */
    @Deprecated
    public void setConnectionTimeout(java.lang.Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    /**
     * Identifies whether cookie-based authentication is enabled or disabled in API
     * calls. When cookie-based authentication is disabled, new sessions cannot be
     * created via /api/session/create.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Boolean getCookieBasedAuthenticationEnabled() {
        return this.cookieBasedAuthenticationEnabled;
    }

    /**
     * Identifies whether cookie-based authentication is enabled or disabled in API
     * calls. When cookie-based authentication is disabled, new sessions cannot be
     * created via /api/session/create.
     *
     * @param cookieBasedAuthenticationEnabled New value for the property.
     */
    @Deprecated
    public void setCookieBasedAuthenticationEnabled(java.lang.Boolean cookieBasedAuthenticationEnabled) {
        this.cookieBasedAuthenticationEnabled = cookieBasedAuthenticationEnabled;
    }

    /**
     * The maximum number of concurrent API requests that will be serviced. If the
     * number of API requests being processed exceeds this limit, new API requests will
     * be refused and a 503 Service Unavailable response will be returned to the
     * client. To disable API concurrency limiting, set this value to 0. format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getGlobalApiConcurrencyLimit() {
        return this.globalApiConcurrencyLimit;
    }

    /**
     * The maximum number of concurrent API requests that will be serviced. If the
     * number of API requests being processed exceeds this limit, new API requests will
     * be refused and a 503 Service Unavailable response will be returned to the
     * client. To disable API concurrency limiting, set this value to 0. format: int64
     *
     * @param globalApiConcurrencyLimit New value for the property.
     */
    @Deprecated
    public void setGlobalApiConcurrencyLimit(java.lang.Long globalApiConcurrencyLimit) {
        this.globalApiConcurrencyLimit = globalApiConcurrencyLimit;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_OFF}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_FATAL}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_ERROR}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_WARN}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_INFO}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_DEBUG}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_TRACE}</li> </ul>
     * Service logging level
     *
     * @return The current value of the property.
     */
    public java.lang.String getLoggingLevel() {
        return this.loggingLevel;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_OFF}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_FATAL}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_ERROR}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_WARN}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_INFO}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_DEBUG}</li> <li> {@link
     * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_TRACE}</li> </ul>
     * Service logging level
     *
     * @param loggingLevel New value for the property.
     */
    public void setLoggingLevel(java.lang.String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    /**
     * TLS protocol versions
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.util.List<com.vmware.nsx.model.ProtocolVersion> getProtocolVersions() {
        return this.protocolVersions;
    }

    /**
     * TLS protocol versions
     *
     * @param protocolVersions New value for the property.
     */
    @Deprecated
    public void setProtocolVersions(java.util.List<com.vmware.nsx.model.ProtocolVersion> protocolVersions) {
        this.protocolVersions = protocolVersions;
    }

    /**
     * Host name or IP address to use for redirect location headers, or empty string to
     * derive from current request
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getRedirectHost() {
        return this.redirectHost;
    }

    /**
     * Host name or IP address to use for redirect location headers, or empty string to
     * derive from current request
     *
     * @param redirectHost New value for the property.
     */
    @Deprecated
    public void setRedirectHost(java.lang.String redirectHost) {
        this.redirectHost = redirectHost;
    }

    /**
     * NSX session inactivity timeout, set to 0 to configure no timeout format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getSessionTimeout() {
        return this.sessionTimeout;
    }

    /**
     * NSX session inactivity timeout, set to 0 to configure no timeout format: int64
     *
     * @param sessionTimeout New value for the property.
     */
    @Deprecated
    public void setSessionTimeout(java.lang.Long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.httpServiceProperties;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("basic_authentication_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.basicAuthenticationEnabled, this._getType().getField("basic_authentication_enabled")));
        structValue.setField("certificate",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificate, this._getType().getField("certificate")));
        structValue.setField("cipher_suites",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cipherSuites, this._getType().getField("cipher_suites")));
        structValue.setField("client_api_concurrency_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientApiConcurrencyLimit, this._getType().getField("client_api_concurrency_limit")));
        structValue.setField("client_api_rate_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientApiRateLimit, this._getType().getField("client_api_rate_limit")));
        structValue.setField("connection_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectionTimeout, this._getType().getField("connection_timeout")));
        structValue.setField("cookie_based_authentication_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cookieBasedAuthenticationEnabled, this._getType().getField("cookie_based_authentication_enabled")));
        structValue.setField("global_api_concurrency_limit",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.globalApiConcurrencyLimit, this._getType().getField("global_api_concurrency_limit")));
        structValue.setField("logging_level",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.loggingLevel, this._getType().getField("logging_level")));
        structValue.setField("protocol_versions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protocolVersions, this._getType().getField("protocol_versions")));
        structValue.setField("redirect_host",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.redirectHost, this._getType().getField("redirect_host")));
        structValue.setField("session_timeout",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sessionTimeout, this._getType().getField("session_timeout")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.httpServiceProperties;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.httpServiceProperties.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static HttpServiceProperties _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new HttpServiceProperties(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static HttpServiceProperties _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new HttpServiceProperties(structValue);
    }

    /**
     * Builder class for {@link HttpServiceProperties}.
     */
    public static final class Builder {
        private java.lang.Boolean basicAuthenticationEnabled;
        private com.vmware.nsx.model.Certificate certificate;
        private java.util.List<com.vmware.nsx.model.CipherSuite> cipherSuites;
        private java.lang.Long clientApiConcurrencyLimit;
        private java.lang.Long clientApiRateLimit;
        private java.lang.Long connectionTimeout;
        private java.lang.Boolean cookieBasedAuthenticationEnabled;
        private java.lang.Long globalApiConcurrencyLimit;
        private java.lang.String loggingLevel;
        private java.util.List<com.vmware.nsx.model.ProtocolVersion> protocolVersions;
        private java.lang.String redirectHost;
        private java.lang.Long sessionTimeout;

        /**
         * Constructor with parameters for the required properties of
         * {@link HttpServiceProperties}.
         */
        public Builder() {
        }

        /**
         * Identifies whether basic authentication is enabled or disabled in API calls.
         *
         * @param basicAuthenticationEnabled New value for the property.
         */
        public Builder setBasicAuthenticationEnabled(java.lang.Boolean basicAuthenticationEnabled) {
            this.basicAuthenticationEnabled = basicAuthenticationEnabled;
            return this;
        }

        /**
         *
         *
         * @param certificate New value for the property.
         */
        public Builder setCertificate(com.vmware.nsx.model.Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Cipher suites used to secure contents of connection
         *
         * @param cipherSuites New value for the property.
         */
        public Builder setCipherSuites(java.util.List<com.vmware.nsx.model.CipherSuite> cipherSuites) {
            this.cipherSuites = cipherSuites;
            return this;
        }

        /**
         * The maximum number of concurrent API requests that will be serviced for a given
         * authenticated client. If the number of API requests being processed exceeds this
         * limit, new API requests will be refused and a 503 Service Unavailable response
         * will be returned to the client. To disable API concurrency limiting, set this
         * value to 0. format: int64
         *
         * @param clientApiConcurrencyLimit New value for the property.
         */
        public Builder setClientApiConcurrencyLimit(java.lang.Long clientApiConcurrencyLimit) {
            this.clientApiConcurrencyLimit = clientApiConcurrencyLimit;
            return this;
        }

        /**
         * The maximum number of API requests that will be serviced per second for a given
         * authenticated client. If more API requests are received than can be serviced, a
         * 429 Too Many Requests HTTP response will be returned. To disable API rate
         * limiting, set this value to 0. format: int64
         *
         * @param clientApiRateLimit New value for the property.
         */
        public Builder setClientApiRateLimit(java.lang.Long clientApiRateLimit) {
            this.clientApiRateLimit = clientApiRateLimit;
            return this;
        }

        /**
         * NSX connection timeout, set to 0 to configure no timeout format: int64
         *
         * @param connectionTimeout New value for the property.
         */
        public Builder setConnectionTimeout(java.lang.Long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        /**
         * Identifies whether cookie-based authentication is enabled or disabled in API
         * calls. When cookie-based authentication is disabled, new sessions cannot be
         * created via /api/session/create.
         *
         * @param cookieBasedAuthenticationEnabled New value for the property.
         */
        public Builder setCookieBasedAuthenticationEnabled(java.lang.Boolean cookieBasedAuthenticationEnabled) {
            this.cookieBasedAuthenticationEnabled = cookieBasedAuthenticationEnabled;
            return this;
        }

        /**
         * The maximum number of concurrent API requests that will be serviced. If the
         * number of API requests being processed exceeds this limit, new API requests will
         * be refused and a 503 Service Unavailable response will be returned to the
         * client. To disable API concurrency limiting, set this value to 0. format: int64
         *
         * @param globalApiConcurrencyLimit New value for the property.
         */
        public Builder setGlobalApiConcurrencyLimit(java.lang.Long globalApiConcurrencyLimit) {
            this.globalApiConcurrencyLimit = globalApiConcurrencyLimit;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_OFF}</li> <li> {@link
         * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_FATAL}</li> <li> {@link
         * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_ERROR}</li> <li> {@link
         * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_WARN}</li> <li> {@link
         * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_INFO}</li> <li> {@link
         * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_DEBUG}</li> <li> {@link
         * com.vmware.nsx.model.HttpServiceProperties#LOGGING_LEVEL_TRACE}</li> </ul>
         * Service logging level
         *
         * @param loggingLevel New value for the property.
         */
        public Builder setLoggingLevel(java.lang.String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        /**
         * TLS protocol versions
         *
         * @param protocolVersions New value for the property.
         */
        public Builder setProtocolVersions(java.util.List<com.vmware.nsx.model.ProtocolVersion> protocolVersions) {
            this.protocolVersions = protocolVersions;
            return this;
        }

        /**
         * Host name or IP address to use for redirect location headers, or empty string to
         * derive from current request
         *
         * @param redirectHost New value for the property.
         */
        public Builder setRedirectHost(java.lang.String redirectHost) {
            this.redirectHost = redirectHost;
            return this;
        }

        /**
         * NSX session inactivity timeout, set to 0 to configure no timeout format: int64
         *
         * @param sessionTimeout New value for the property.
         */
        public Builder setSessionTimeout(java.lang.Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public HttpServiceProperties build() {
            HttpServiceProperties result = new HttpServiceProperties();
            result.setBasicAuthenticationEnabled(this.basicAuthenticationEnabled);
            result.setCertificate(this.certificate);
            result.setCipherSuites(this.cipherSuites);
            result.setClientApiConcurrencyLimit(this.clientApiConcurrencyLimit);
            result.setClientApiRateLimit(this.clientApiRateLimit);
            result.setConnectionTimeout(this.connectionTimeout);
            result.setCookieBasedAuthenticationEnabled(this.cookieBasedAuthenticationEnabled);
            result.setGlobalApiConcurrencyLimit(this.globalApiConcurrencyLimit);
            result.setLoggingLevel(this.loggingLevel);
            result.setProtocolVersions(this.protocolVersions);
            result.setRedirectHost(this.redirectHost);
            result.setSessionTimeout(this.sessionTimeout);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("basic_authentication_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("basic_authentication_enabled",
                                                                                "basicAuthenticationEnabled",
                                                                                "getBasicAuthenticationEnabled",
                                                                                "setBasicAuthenticationEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("certificate", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.certificate; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate",
                                                                                "certificate",
                                                                                "getCertificate",
                                                                                "setCertificate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cipher_suites", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.cipherSuite; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cipher_suites",
                                                                                "cipherSuites",
                                                                                "getCipherSuites",
                                                                                "setCipherSuites");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_api_concurrency_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_api_concurrency_limit",
                                                                                "clientApiConcurrencyLimit",
                                                                                "getClientApiConcurrencyLimit",
                                                                                "setClientApiConcurrencyLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_api_rate_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_api_rate_limit",
                                                                                "clientApiRateLimit",
                                                                                "getClientApiRateLimit",
                                                                                "setClientApiRateLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("connection_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connection_timeout",
                                                                                "connectionTimeout",
                                                                                "getConnectionTimeout",
                                                                                "setConnectionTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cookie_based_authentication_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cookie_based_authentication_enabled",
                                                                                "cookieBasedAuthenticationEnabled",
                                                                                "getCookieBasedAuthenticationEnabled",
                                                                                "setCookieBasedAuthenticationEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("global_api_concurrency_limit", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("global_api_concurrency_limit",
                                                                                "globalApiConcurrencyLimit",
                                                                                "getGlobalApiConcurrencyLimit",
                                                                                "setGlobalApiConcurrencyLimit");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("logging_level", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("logging_level",
                                                                                "loggingLevel",
                                                                                "getLoggingLevel",
                                                                                "setLoggingLevel");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("protocol_versions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.protocolVersion; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("protocol_versions",
                                                                                "protocolVersions",
                                                                                "getProtocolVersions",
                                                                                "setProtocolVersions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("redirect_host", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("redirect_host",
                                                                                "redirectHost",
                                                                                "getRedirectHost",
                                                                                "setRedirectHost");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("session_timeout", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("session_timeout",
                                                                                "sessionTimeout",
                                                                                "getSessionTimeout",
                                                                                "setSessionTimeout");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.http_service_properties",
                                                            fields,
                                                            com.vmware.nsx.model.HttpServiceProperties.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

