/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * A NSService that represents IPv4 or IPv6 ICMP protocol
 */
public final class ICMPTypeNSService implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "ICMPTypeNSService";

    public static final java.lang.String PROTOCOL_ICMPV4 = "ICMPv4";

    public static final java.lang.String PROTOCOL_ICMPV6 = "ICMPv6";

    private java.lang.Long icmpCode;

    private java.lang.Long icmpType;

    private java.lang.String protocol;

    private final java.lang.String resourceType = "ICMPTypeNSService";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ICMPTypeNSService() {
    }

    protected ICMPTypeNSService(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * ICMP message code format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIcmpCode() {
        return this.icmpCode;
    }

    /**
     * ICMP message code format: int64
     *
     * @param icmpCode New value for the property.
     */
    public void setIcmpCode(java.lang.Long icmpCode) {
        this.icmpCode = icmpCode;
    }

    /**
     * ICMP message type format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getIcmpType() {
        return this.icmpType;
    }

    /**
     * ICMP message type format: int64
     *
     * @param icmpType New value for the property.
     */
    public void setIcmpType(java.lang.Long icmpType) {
        this.icmpType = icmpType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ICMPTypeNSService#PROTOCOL_ICMPV4}</li> <li> {@link
     * com.vmware.nsx.model.ICMPTypeNSService#PROTOCOL_ICMPV6}</li> </ul> ICMP protocol
     * type
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtocol() {
        return this.protocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ICMPTypeNSService#PROTOCOL_ICMPV4}</li> <li> {@link
     * com.vmware.nsx.model.ICMPTypeNSService#PROTOCOL_ICMPV6}</li> </ul> ICMP protocol
     * type
     *
     * @param protocol New value for the property.
     */
    public void setProtocol(java.lang.String protocol) {
        this.protocol = protocol;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_ETHERTYPENSSERVICE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_IPPROTOCOLNSSERVICE}</li>
     * <li> {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_IGMPTYPENSSERVICE}</li> <li>
     * {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_ICMPTYPENSSERVICE}</li> <li>
     * {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_ALGTYPENSSERVICE}</li> <li>
     * {@link
     * com.vmware.nsx.model.NSServiceElement#RESOURCE_TYPE_L4PORTSETNSSERVICE}</li>
     * </ul> The specific type of NSServiceElement
     * The value of this property is automatically populated to {@code "ICMPTypeNSService"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.ICMPTypeNSService;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("icmp_code",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.icmpCode, this._getType().getField("icmp_code")));
        structValue.setField("icmp_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.icmpType, this._getType().getField("icmp_type")));
        structValue.setField("protocol",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protocol, this._getType().getField("protocol")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.ICMPTypeNSService;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.ICMPTypeNSService.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ICMPTypeNSService _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ICMPTypeNSService(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ICMPTypeNSService _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ICMPTypeNSService(structValue);
    }

    /**
     * Builder class for {@link ICMPTypeNSService}.
     */
    public static final class Builder {
        private java.lang.Long icmpCode;
        private java.lang.Long icmpType;
        private java.lang.String protocol;

        /**
         * Constructor with parameters for the required properties of
         * {@link ICMPTypeNSService}.
         */
        public Builder() {
        }

        /**
         * ICMP message code format: int64
         *
         * @param icmpCode New value for the property.
         */
        public Builder setIcmpCode(java.lang.Long icmpCode) {
            this.icmpCode = icmpCode;
            return this;
        }

        /**
         * ICMP message type format: int64
         *
         * @param icmpType New value for the property.
         */
        public Builder setIcmpType(java.lang.Long icmpType) {
            this.icmpType = icmpType;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ICMPTypeNSService#PROTOCOL_ICMPV4}</li> <li> {@link
         * com.vmware.nsx.model.ICMPTypeNSService#PROTOCOL_ICMPV6}</li> </ul> ICMP protocol
         * type
         *
         * @param protocol New value for the property.
         */
        public Builder setProtocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        public ICMPTypeNSService build() {
            ICMPTypeNSService result = new ICMPTypeNSService();
            result.setIcmpCode(this.icmpCode);
            result.setIcmpType(this.icmpType);
            result.setProtocol(this.protocol);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("icmp_code", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("icmp_code",
                                                                                "icmpCode",
                                                                                "getIcmpCode",
                                                                                "setIcmpCode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("icmp_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("icmp_type",
                                                                                "icmpType",
                                                                                "getIcmpType",
                                                                                "setIcmpType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("protocol", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("protocol",
                                                                                "protocol",
                                                                                "getProtocol",
                                                                                "setProtocol");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.ICMP_type_NS_service",
                                                            fields,
                                                            com.vmware.nsx.model.ICMPTypeNSService.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "ICMPTypeNSService");
    }
}

