/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * DHCP server to support IPv4 DHCP service. Properties defined at DHCP server
 * level can be overridden by ip-pool or static-binding level properties.
 */
public final class IPv4DhcpServer implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String dhcpServerIp;

    private java.util.List<java.lang.String> dnsNameservers;

    private java.lang.String domainName;

    private java.lang.String gatewayIp;

    private java.lang.Boolean monitorIppoolUsage;

    private com.vmware.nsx.model.DhcpOptions options;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IPv4DhcpServer() {
    }

    protected IPv4DhcpServer(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * DHCP server ip in CIDR format. format: ipv4-cidr-block
     *
     * @return The current value of the property.
     */
    public java.lang.String getDhcpServerIp() {
        return this.dhcpServerIp;
    }

    /**
     * DHCP server ip in CIDR format. format: ipv4-cidr-block
     *
     * @param dhcpServerIp New value for the property.
     */
    public void setDhcpServerIp(java.lang.String dhcpServerIp) {
        this.dhcpServerIp = dhcpServerIp;
    }

    /**
     * Primary and secondary DNS server address to assign host. They can be overridden
     * by ip-pool or static-binding level property. format: ipv4
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getDnsNameservers() {
        return this.dnsNameservers;
    }

    /**
     * Primary and secondary DNS server address to assign host. They can be overridden
     * by ip-pool or static-binding level property. format: ipv4
     *
     * @param dnsNameservers New value for the property.
     */
    public void setDnsNameservers(java.util.List<java.lang.String> dnsNameservers) {
        this.dnsNameservers = dnsNameservers;
    }

    /**
     * Host name or prefix to be assigned to host. It can be overridden by ip-pool or
     * static-binding level property. format: hostname
     *
     * @return The current value of the property.
     */
    public java.lang.String getDomainName() {
        return this.domainName;
    }

    /**
     * Host name or prefix to be assigned to host. It can be overridden by ip-pool or
     * static-binding level property. format: hostname
     *
     * @param domainName New value for the property.
     */
    public void setDomainName(java.lang.String domainName) {
        this.domainName = domainName;
    }

    /**
     * Gateway ip to be assigned to host. It can be overridden by ip-pool or
     * static-binding level property. format: ipv4
     *
     * @return The current value of the property.
     */
    public java.lang.String getGatewayIp() {
        return this.gatewayIp;
    }

    /**
     * Gateway ip to be assigned to host. It can be overridden by ip-pool or
     * static-binding level property. format: ipv4
     *
     * @param gatewayIp New value for the property.
     */
    public void setGatewayIp(java.lang.String gatewayIp) {
        this.gatewayIp = gatewayIp;
    }

    /**
     * Enable or disable monitoring of DHCP ip-pools usage. When enabled, system events
     * are generated when pool usage exceeds the configured thresholds. System events
     * can be viewed in REST API /api/v2/hpm/alarms
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getMonitorIppoolUsage() {
        return this.monitorIppoolUsage;
    }

    /**
     * Enable or disable monitoring of DHCP ip-pools usage. When enabled, system events
     * are generated when pool usage exceeds the configured thresholds. System events
     * can be viewed in REST API /api/v2/hpm/alarms
     *
     * @param monitorIppoolUsage New value for the property.
     */
    public void setMonitorIppoolUsage(java.lang.Boolean monitorIppoolUsage) {
        this.monitorIppoolUsage = monitorIppoolUsage;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.DhcpOptions getOptions() {
        return this.options;
    }

    /**
     *
     *
     * @param options New value for the property.
     */
    public void setOptions(com.vmware.nsx.model.DhcpOptions options) {
        this.options = options;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.IPv4DhcpServer;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("dhcp_server_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dhcpServerIp, this._getType().getField("dhcp_server_ip")));
        structValue.setField("dns_nameservers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dnsNameservers, this._getType().getField("dns_nameservers")));
        structValue.setField("domain_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.domainName, this._getType().getField("domain_name")));
        structValue.setField("gateway_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.gatewayIp, this._getType().getField("gateway_ip")));
        structValue.setField("monitor_ippool_usage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.monitorIppoolUsage, this._getType().getField("monitor_ippool_usage")));
        structValue.setField("options",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.options, this._getType().getField("options")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.IPv4DhcpServer;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.IPv4DhcpServer.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IPv4DhcpServer _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IPv4DhcpServer(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IPv4DhcpServer _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IPv4DhcpServer(structValue);
    }

    /**
     * Builder class for {@link IPv4DhcpServer}.
     */
    public static final class Builder {
        private java.lang.String dhcpServerIp;
        private java.util.List<java.lang.String> dnsNameservers;
        private java.lang.String domainName;
        private java.lang.String gatewayIp;
        private java.lang.Boolean monitorIppoolUsage;
        private com.vmware.nsx.model.DhcpOptions options;

        /**
         * Constructor with parameters for the required properties of
         * {@link IPv4DhcpServer}.
         */
        public Builder() {
        }

        /**
         * DHCP server ip in CIDR format. format: ipv4-cidr-block
         *
         * @param dhcpServerIp New value for the property.
         */
        public Builder setDhcpServerIp(java.lang.String dhcpServerIp) {
            this.dhcpServerIp = dhcpServerIp;
            return this;
        }

        /**
         * Primary and secondary DNS server address to assign host. They can be overridden
         * by ip-pool or static-binding level property. format: ipv4
         *
         * @param dnsNameservers New value for the property.
         */
        public Builder setDnsNameservers(java.util.List<java.lang.String> dnsNameservers) {
            this.dnsNameservers = dnsNameservers;
            return this;
        }

        /**
         * Host name or prefix to be assigned to host. It can be overridden by ip-pool or
         * static-binding level property. format: hostname
         *
         * @param domainName New value for the property.
         */
        public Builder setDomainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Gateway ip to be assigned to host. It can be overridden by ip-pool or
         * static-binding level property. format: ipv4
         *
         * @param gatewayIp New value for the property.
         */
        public Builder setGatewayIp(java.lang.String gatewayIp) {
            this.gatewayIp = gatewayIp;
            return this;
        }

        /**
         * Enable or disable monitoring of DHCP ip-pools usage. When enabled, system events
         * are generated when pool usage exceeds the configured thresholds. System events
         * can be viewed in REST API /api/v2/hpm/alarms
         *
         * @param monitorIppoolUsage New value for the property.
         */
        public Builder setMonitorIppoolUsage(java.lang.Boolean monitorIppoolUsage) {
            this.monitorIppoolUsage = monitorIppoolUsage;
            return this;
        }

        /**
         *
         *
         * @param options New value for the property.
         */
        public Builder setOptions(com.vmware.nsx.model.DhcpOptions options) {
            this.options = options;
            return this;
        }

        public IPv4DhcpServer build() {
            IPv4DhcpServer result = new IPv4DhcpServer();
            result.setDhcpServerIp(this.dhcpServerIp);
            result.setDnsNameservers(this.dnsNameservers);
            result.setDomainName(this.domainName);
            result.setGatewayIp(this.gatewayIp);
            result.setMonitorIppoolUsage(this.monitorIppoolUsage);
            result.setOptions(this.options);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("dhcp_server_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dhcp_server_ip",
                                                                                "dhcpServerIp",
                                                                                "getDhcpServerIp",
                                                                                "setDhcpServerIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dns_nameservers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dns_nameservers",
                                                                                "dnsNameservers",
                                                                                "getDnsNameservers",
                                                                                "setDnsNameservers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("domain_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("domain_name",
                                                                                "domainName",
                                                                                "getDomainName",
                                                                                "setDomainName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("gateway_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("gateway_ip",
                                                                                "gatewayIp",
                                                                                "getGatewayIp",
                                                                                "setGatewayIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("monitor_ippool_usage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("monitor_ippool_usage",
                                                                                "monitorIppoolUsage",
                                                                                "getMonitorIppoolUsage",
                                                                                "setMonitorIppoolUsage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("options", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.dhcpOptions; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("options",
                                                                                "options",
                                                                                "getOptions",
                                                                                "setOptions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.I_pv4_dhcp_server",
                                                            fields,
                                                            com.vmware.nsx.model.IPv4DhcpServer.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

