/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Identity Firewall statistics data.
 */
public final class IdfwSystemStats implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long numConcurrentUsers;

    private java.lang.Long numUserSessions;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public IdfwSystemStats() {
    }

    protected IdfwSystemStats(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Number of concurrent logged on users (across VDI & RDSH). Multiple logins by the
     * same user is counted as 1. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumConcurrentUsers() {
        return this.numConcurrentUsers;
    }

    /**
     * Number of concurrent logged on users (across VDI & RDSH). Multiple logins by the
     * same user is counted as 1. format: int32
     *
     * @param numConcurrentUsers New value for the property.
     */
    public void setNumConcurrentUsers(java.lang.Long numConcurrentUsers) {
        this.numConcurrentUsers = numConcurrentUsers;
    }

    /**
     * Number of active user sessions/logins in IDFW enabled compute collections
     * (including both UP and DOWN hosts). N sessions/logins by the same user is
     * counted as n. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getNumUserSessions() {
        return this.numUserSessions;
    }

    /**
     * Number of active user sessions/logins in IDFW enabled compute collections
     * (including both UP and DOWN hosts). N sessions/logins by the same user is
     * counted as n. format: int32
     *
     * @param numUserSessions New value for the property.
     */
    public void setNumUserSessions(java.lang.Long numUserSessions) {
        this.numUserSessions = numUserSessions;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.idfwSystemStats;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("num_concurrent_users",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numConcurrentUsers, this._getType().getField("num_concurrent_users")));
        structValue.setField("num_user_sessions",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.numUserSessions, this._getType().getField("num_user_sessions")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.idfwSystemStats;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.idfwSystemStats.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static IdfwSystemStats _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new IdfwSystemStats(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static IdfwSystemStats _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new IdfwSystemStats(structValue);
    }

    /**
     * Builder class for {@link IdfwSystemStats}.
     */
    public static final class Builder {
        private java.lang.Long numConcurrentUsers;
        private java.lang.Long numUserSessions;

        /**
         * Constructor with parameters for the required properties of
         * {@link IdfwSystemStats}.
         */
        public Builder() {
        }

        /**
         * Number of concurrent logged on users (across VDI & RDSH). Multiple logins by the
         * same user is counted as 1. format: int32
         *
         * @param numConcurrentUsers New value for the property.
         */
        public Builder setNumConcurrentUsers(java.lang.Long numConcurrentUsers) {
            this.numConcurrentUsers = numConcurrentUsers;
            return this;
        }

        /**
         * Number of active user sessions/logins in IDFW enabled compute collections
         * (including both UP and DOWN hosts). N sessions/logins by the same user is
         * counted as n. format: int32
         *
         * @param numUserSessions New value for the property.
         */
        public Builder setNumUserSessions(java.lang.Long numUserSessions) {
            this.numUserSessions = numUserSessions;
            return this;
        }

        public IdfwSystemStats build() {
            IdfwSystemStats result = new IdfwSystemStats();
            result.setNumConcurrentUsers(this.numConcurrentUsers);
            result.setNumUserSessions(this.numUserSessions);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("num_concurrent_users", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_concurrent_users",
                                                                                "numConcurrentUsers",
                                                                                "getNumConcurrentUsers",
                                                                                "setNumConcurrentUsers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("num_user_sessions", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("num_user_sessions",
                                                                                "numUserSessions",
                                                                                "getNumUserSessions",
                                                                                "setNumUserSessions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.idfw_system_stats",
                                                            fields,
                                                            com.vmware.nsx.model.IdfwSystemStats.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

