/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * A Service Runtime is the runtime entity associated with ever Service-VM
 * deployed.
 */
public final class InstanceRuntime implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String DEPLOYMENT_STATUS_DEPLOYMENT_IN_PROGRESS = "DEPLOYMENT_IN_PROGRESS";

    public static final java.lang.String DEPLOYMENT_STATUS_DEPLOYMENT_FAILED = "DEPLOYMENT_FAILED";

    public static final java.lang.String DEPLOYMENT_STATUS_DEPLOYMENT_SUCCESSFUL = "DEPLOYMENT_SUCCESSFUL";

    public static final java.lang.String DEPLOYMENT_STATUS_UPGRADE_IN_PROGRESS = "UPGRADE_IN_PROGRESS";

    public static final java.lang.String DEPLOYMENT_STATUS_UPGRADE_FAILED = "UPGRADE_FAILED";

    public static final java.lang.String DEPLOYMENT_STATUS_UNDEPLOYMENT_IN_PROGRESS = "UNDEPLOYMENT_IN_PROGRESS";

    public static final java.lang.String DEPLOYMENT_STATUS_UNDEPLOYMENT_FAILED = "UNDEPLOYMENT_FAILED";

    public static final java.lang.String DEPLOYMENT_STATUS_UNDEPLOYMENT_SUCCESSFUL = "UNDEPLOYMENT_SUCCESSFUL";

    public static final java.lang.String DEPLOYMENT_STATUS_UNKNOWN = "UNKNOWN";

    public static final java.lang.String MAINTENANCE_MODE_OFF = "OFF";

    public static final java.lang.String MAINTENANCE_MODE_ENTERING = "ENTERING";

    public static final java.lang.String MAINTENANCE_MODE_ON = "ON";

    public static final java.lang.String MAINTENANCE_MODE_EXITING = "EXITING";

    public static final java.lang.String RUNTIME_HEALTH_STATUS_BY_PARTNER_HEALTHY = "HEALTHY";

    public static final java.lang.String RUNTIME_HEALTH_STATUS_BY_PARTNER_STOPPED = "STOPPED";

    public static final java.lang.String RUNTIME_HEALTH_STATUS_BY_PARTNER_NOT_RESPONDING = "NOT_RESPONDING";

    public static final java.lang.String RUNTIME_STATUS_IN_SERVICE = "IN_SERVICE";

    public static final java.lang.String RUNTIME_STATUS_OUT_OF_SERVICE = "OUT_OF_SERVICE";

    public static final java.lang.String RUNTIME_STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION";

    public static final java.lang.String RUNTIME_STATUS_NOT_AVAILABLE = "NOT_AVAILABLE";

    private java.util.List<com.vmware.nsx.model.ResourceLink> links;

    private java.lang.String schema;

    private com.vmware.nsx.model.SelfResourceLink self;

    private java.lang.Long revision;

    private java.lang.Long createTime;

    private java.lang.String createUser;

    private java.lang.Long lastModifiedTime;

    private java.lang.String lastModifiedUser;

    private java.lang.String protection;

    private java.lang.Boolean systemOwned;

    private java.lang.String description;

    private java.lang.String displayName;

    private java.lang.String id;

    private java.lang.String resourceType;

    private java.util.List<com.vmware.nsx.model.Tag> tags;

    private java.lang.String computeCollectionId;

    private java.lang.String deploymentStatus;

    private java.lang.String errorMessage;

    private java.lang.String maintenanceMode;

    private java.lang.String runtimeHealthStatusByPartner;

    private java.lang.String runtimeStatus;

    private java.lang.String serviceInstanceId;

    private java.lang.String serviceVmId;

    private java.lang.String storageId;

    private java.lang.String unhealthyReason;

    private com.vmware.nsx.model.VmNicInfo vmNicInfo;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public InstanceRuntime() {
    }

    protected InstanceRuntime(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.ResourceLink> getLinks() {
        return this.links;
    }

    /**
     * The server will populate this field when returing the resource. Ignored on PUT
     * and POST.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param links New value for the property.
     */
    public void setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
        this.links = links;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSchema() {
        return this.schema;
    }

    /**
     * Schema for this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param schema New value for the property.
     */
    public void setSchema(java.lang.String schema) {
        this.schema = schema;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.SelfResourceLink getSelf() {
        return this.self;
    }

    /**
     *
     *
     * @param self New value for the property.
     */
    public void setSelf(com.vmware.nsx.model.SelfResourceLink self) {
        this.self = self;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRevision() {
        return this.revision;
    }

    /**
     * The _revision property describes the current revision of the resource. To
     * prevent clients from overwriting each other's changes, PUT operations must
     * include the current _revision of the resource, which clients should obtain by
     * issuing a GET operation. If the _revision provided in a PUT request is missing
     * or stale, the operation will be rejected. format: int32
     *
     * @param revision New value for the property.
     */
    public void setRevision(java.lang.Long revision) {
        this.revision = revision;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Timestamp of resource creation format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createTime New value for the property.
     */
    public void setCreateTime(java.lang.Long createTime) {
        this.createTime = createTime;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCreateUser() {
        return this.createUser;
    }

    /**
     * ID of the user who created this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param createUser New value for the property.
     */
    public void setCreateUser(java.lang.String createUser) {
        this.createUser = createUser;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Timestamp of last modification format: int64
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedTime New value for the property.
     */
    public void setLastModifiedTime(java.lang.Long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    /**
     * ID of the user who last modified this resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param lastModifiedUser New value for the property.
     */
    public void setLastModifiedUser(java.lang.String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getProtection() {
        return this.protection;
    }

    /**
     * Protection status is one of the following: PROTECTED - the client who retrieved
     * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
     * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
     * the entity is a super user and can modify it, but only when providing the
     * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
     * be determined for this entity.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param protection New value for the property.
     */
    public void setProtection(java.lang.String protection) {
        this.protection = protection;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getSystemOwned() {
        return this.systemOwned;
    }

    /**
     * Indicates system owned resource
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param systemOwned New value for the property.
     */
    public void setSystemOwned(java.lang.Boolean systemOwned) {
        this.systemOwned = systemOwned;
    }

    /**
     * Description of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getDescription() {
        return this.description;
    }

    /**
     * Description of this resource
     *
     * @param description New value for the property.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    /**
     * Defaults to ID if not set
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Defaults to ID if not set
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Unique identifier of this resource
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Unique identifier of this resource
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * The type of this resource.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * The type of this resource.
     *
     * @param resourceType New value for the property.
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.Tag> getTags() {
        return this.tags;
    }

    /**
     * Opaque identifiers meaningful to the API user
     *
     * @param tags New value for the property.
     */
    public void setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
        this.tags = tags;
    }

    /**
     * Resource Pool or cluster Id.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getComputeCollectionId() {
        return this.computeCollectionId;
    }

    /**
     * Resource Pool or cluster Id.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param computeCollectionId New value for the property.
     */
    public void setComputeCollectionId(java.lang.String computeCollectionId) {
        this.computeCollectionId = computeCollectionId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_DEPLOYMENT_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_DEPLOYMENT_FAILED}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_DEPLOYMENT_SUCCESSFUL}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UPGRADE_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UPGRADE_FAILED}</li> <li>
     * {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNDEPLOYMENT_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNDEPLOYMENT_FAILED}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNDEPLOYMENT_SUCCESSFUL}</li>
     * <li> {@link com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNKNOWN}</li>
     * </ul> Service-Instance Runtime deployment status of the Service-VM. It shows the
     * latest status during the process of deployment, redeploy, upgrade, and
     * un-deployment of VM.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDeploymentStatus() {
        return this.deploymentStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_DEPLOYMENT_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_DEPLOYMENT_FAILED}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_DEPLOYMENT_SUCCESSFUL}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UPGRADE_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UPGRADE_FAILED}</li> <li>
     * {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNDEPLOYMENT_IN_PROGRESS}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNDEPLOYMENT_FAILED}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNDEPLOYMENT_SUCCESSFUL}</li>
     * <li> {@link com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNKNOWN}</li>
     * </ul> Service-Instance Runtime deployment status of the Service-VM. It shows the
     * latest status during the process of deployment, redeploy, upgrade, and
     * un-deployment of VM.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param deploymentStatus New value for the property.
     */
    public void setDeploymentStatus(java.lang.String deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
    }

    /**
     * Error message for the Service Instance Runtime if any.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * Error message for the Service Instance Runtime if any.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param errorMessage New value for the property.
     */
    public void setErrorMessage(java.lang.String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_OFF}</li> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_ENTERING}</li> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_ON}</li> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_EXITING}</li> </ul> The
     * maintenance mode indicates whether the corresponding service VM is in
     * maintenance mode. The service VM will not be used to service new requests if it
     * is in maintenance mode.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMaintenanceMode() {
        return this.maintenanceMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_OFF}</li> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_ENTERING}</li> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_ON}</li> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_EXITING}</li> </ul> The
     * maintenance mode indicates whether the corresponding service VM is in
     * maintenance mode. The service VM will not be used to service new requests if it
     * is in maintenance mode.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param maintenanceMode New value for the property.
     */
    public void setMaintenanceMode(java.lang.String maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_HEALTH_STATUS_BY_PARTNER_HEALTHY}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_HEALTH_STATUS_BY_PARTNER_STOPPED}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_HEALTH_STATUS_BY_PARTNER_NOT_RESPONDING}</li>
     * </ul> Service-Instance runtime health status set by partner to indicate whether
     * the service is running properly or not.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRuntimeHealthStatusByPartner() {
        return this.runtimeHealthStatusByPartner;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_HEALTH_STATUS_BY_PARTNER_HEALTHY}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_HEALTH_STATUS_BY_PARTNER_STOPPED}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_HEALTH_STATUS_BY_PARTNER_NOT_RESPONDING}</li>
     * </ul> Service-Instance runtime health status set by partner to indicate whether
     * the service is running properly or not.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param runtimeHealthStatusByPartner New value for the property.
     */
    public void setRuntimeHealthStatusByPartner(java.lang.String runtimeHealthStatusByPartner) {
        this.runtimeHealthStatusByPartner = runtimeHealthStatusByPartner;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_IN_SERVICE}</li> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_OUT_OF_SERVICE}</li> <li>
     * {@link com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_NEEDS_ATTENTION}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_NOT_AVAILABLE}</li> </ul>
     * Service-Instance Runtime status of the deployed Service-VM.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getRuntimeStatus() {
        return this.runtimeStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_IN_SERVICE}</li> <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_OUT_OF_SERVICE}</li> <li>
     * {@link com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_NEEDS_ATTENTION}</li>
     * <li> {@link
     * com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_NOT_AVAILABLE}</li> </ul>
     * Service-Instance Runtime status of the deployed Service-VM.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param runtimeStatus New value for the property.
     */
    public void setRuntimeStatus(java.lang.String runtimeStatus) {
        this.runtimeStatus = runtimeStatus;
    }

    /**
     * Id of an instantiation of a registered service.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    /**
     * Id of an instantiation of a registered service.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serviceInstanceId New value for the property.
     */
    public void setServiceInstanceId(java.lang.String serviceInstanceId) {
        this.serviceInstanceId = serviceInstanceId;
    }

    /**
     * Service-VM/SVM id of deployed virtual-machine.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceVmId() {
        return this.serviceVmId;
    }

    /**
     * Service-VM/SVM id of deployed virtual-machine.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param serviceVmId New value for the property.
     */
    public void setServiceVmId(java.lang.String serviceVmId) {
        this.serviceVmId = serviceVmId;
    }

    /**
     * Moref of the datastore in VC.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStorageId() {
        return this.storageId;
    }

    /**
     * Moref of the datastore in VC.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param storageId New value for the property.
     */
    public void setStorageId(java.lang.String storageId) {
        this.storageId = storageId;
    }

    /**
     * Reason provided by partner for the service being unhealthy. This could be due to
     * various reasons such as connectivity lost as an example.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUnhealthyReason() {
        return this.unhealthyReason;
    }

    /**
     * Reason provided by partner for the service being unhealthy. This could be due to
     * various reasons such as connectivity lost as an example.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param unhealthyReason New value for the property.
     */
    public void setUnhealthyReason(java.lang.String unhealthyReason) {
        this.unhealthyReason = unhealthyReason;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.VmNicInfo getVmNicInfo() {
        return this.vmNicInfo;
    }

    /**
     *
     *
     * @param vmNicInfo New value for the property.
     */
    public void setVmNicInfo(com.vmware.nsx.model.VmNicInfo vmNicInfo) {
        this.vmNicInfo = vmNicInfo;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.instanceRuntime;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("_links",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.links, this._getType().getField("_links")));
        structValue.setField("_schema",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.schema, this._getType().getField("_schema")));
        structValue.setField("_self",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.self, this._getType().getField("_self")));
        structValue.setField("_revision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.revision, this._getType().getField("_revision")));
        structValue.setField("_create_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createTime, this._getType().getField("_create_time")));
        structValue.setField("_create_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.createUser, this._getType().getField("_create_user")));
        structValue.setField("_last_modified_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedTime, this._getType().getField("_last_modified_time")));
        structValue.setField("_last_modified_user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastModifiedUser, this._getType().getField("_last_modified_user")));
        structValue.setField("_protection",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.protection, this._getType().getField("_protection")));
        structValue.setField("_system_owned",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.systemOwned, this._getType().getField("_system_owned")));
        structValue.setField("description",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.description, this._getType().getField("description")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
        structValue.setField("tags",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tags, this._getType().getField("tags")));
        structValue.setField("compute_collection_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.computeCollectionId, this._getType().getField("compute_collection_id")));
        structValue.setField("deployment_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.deploymentStatus, this._getType().getField("deployment_status")));
        structValue.setField("error_message",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorMessage, this._getType().getField("error_message")));
        structValue.setField("maintenance_mode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maintenanceMode, this._getType().getField("maintenance_mode")));
        structValue.setField("runtime_health_status_by_partner",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.runtimeHealthStatusByPartner, this._getType().getField("runtime_health_status_by_partner")));
        structValue.setField("runtime_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.runtimeStatus, this._getType().getField("runtime_status")));
        structValue.setField("service_instance_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceInstanceId, this._getType().getField("service_instance_id")));
        structValue.setField("service_vm_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceVmId, this._getType().getField("service_vm_id")));
        structValue.setField("storage_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.storageId, this._getType().getField("storage_id")));
        structValue.setField("unhealthy_reason",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.unhealthyReason, this._getType().getField("unhealthy_reason")));
        structValue.setField("vm_nic_info",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.vmNicInfo, this._getType().getField("vm_nic_info")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.instanceRuntime;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.instanceRuntime.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static InstanceRuntime _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new InstanceRuntime(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static InstanceRuntime _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new InstanceRuntime(structValue);
    }

    /**
     * Builder class for {@link InstanceRuntime}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.ResourceLink> links;
        private java.lang.String schema;
        private com.vmware.nsx.model.SelfResourceLink self;
        private java.lang.Long revision;
        private java.lang.Long createTime;
        private java.lang.String createUser;
        private java.lang.Long lastModifiedTime;
        private java.lang.String lastModifiedUser;
        private java.lang.String protection;
        private java.lang.Boolean systemOwned;
        private java.lang.String description;
        private java.lang.String displayName;
        private java.lang.String id;
        private java.lang.String resourceType;
        private java.util.List<com.vmware.nsx.model.Tag> tags;
        private java.lang.String computeCollectionId;
        private java.lang.String deploymentStatus;
        private java.lang.String errorMessage;
        private java.lang.String maintenanceMode;
        private java.lang.String runtimeHealthStatusByPartner;
        private java.lang.String runtimeStatus;
        private java.lang.String serviceInstanceId;
        private java.lang.String serviceVmId;
        private java.lang.String storageId;
        private java.lang.String unhealthyReason;
        private com.vmware.nsx.model.VmNicInfo vmNicInfo;

        /**
         * Constructor with parameters for the required properties of
         * {@link InstanceRuntime}.
         */
        public Builder() {
        }

        /**
         * The server will populate this field when returing the resource. Ignored on PUT
         * and POST.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param links New value for the property.
         */
        public Builder setLinks(java.util.List<com.vmware.nsx.model.ResourceLink> links) {
            this.links = links;
            return this;
        }

        /**
         * Schema for this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param schema New value for the property.
         */
        public Builder setSchema(java.lang.String schema) {
            this.schema = schema;
            return this;
        }

        /**
         *
         *
         * @param self New value for the property.
         */
        public Builder setSelf(com.vmware.nsx.model.SelfResourceLink self) {
            this.self = self;
            return this;
        }

        /**
         * The _revision property describes the current revision of the resource. To
         * prevent clients from overwriting each other's changes, PUT operations must
         * include the current _revision of the resource, which clients should obtain by
         * issuing a GET operation. If the _revision provided in a PUT request is missing
         * or stale, the operation will be rejected. format: int32
         *
         * @param revision New value for the property.
         */
        public Builder setRevision(java.lang.Long revision) {
            this.revision = revision;
            return this;
        }

        /**
         * Timestamp of resource creation format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createTime New value for the property.
         */
        public Builder setCreateTime(java.lang.Long createTime) {
            this.createTime = createTime;
            return this;
        }

        /**
         * ID of the user who created this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param createUser New value for the property.
         */
        public Builder setCreateUser(java.lang.String createUser) {
            this.createUser = createUser;
            return this;
        }

        /**
         * Timestamp of last modification format: int64
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedTime New value for the property.
         */
        public Builder setLastModifiedTime(java.lang.Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * ID of the user who last modified this resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param lastModifiedUser New value for the property.
         */
        public Builder setLastModifiedUser(java.lang.String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        /**
         * Protection status is one of the following: PROTECTED - the client who retrieved
         * the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved
         * the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved
         * the entity is a super user and can modify it, but only when providing the
         * request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
         * be determined for this entity.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param protection New value for the property.
         */
        public Builder setProtection(java.lang.String protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Indicates system owned resource
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param systemOwned New value for the property.
         */
        public Builder setSystemOwned(java.lang.Boolean systemOwned) {
            this.systemOwned = systemOwned;
            return this;
        }

        /**
         * Description of this resource
         *
         * @param description New value for the property.
         */
        public Builder setDescription(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Defaults to ID if not set
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Unique identifier of this resource
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * The type of this resource.
         *
         * @param resourceType New value for the property.
         */
        public Builder setResourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Opaque identifiers meaningful to the API user
         *
         * @param tags New value for the property.
         */
        public Builder setTags(java.util.List<com.vmware.nsx.model.Tag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Resource Pool or cluster Id.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param computeCollectionId New value for the property.
         */
        public Builder setComputeCollectionId(java.lang.String computeCollectionId) {
            this.computeCollectionId = computeCollectionId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_DEPLOYMENT_IN_PROGRESS}</li>
         * <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_DEPLOYMENT_FAILED}</li>
         * <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_DEPLOYMENT_SUCCESSFUL}</li>
         * <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UPGRADE_IN_PROGRESS}</li>
         * <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UPGRADE_FAILED}</li> <li>
         * {@link
         * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNDEPLOYMENT_IN_PROGRESS}</li>
         * <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNDEPLOYMENT_FAILED}</li>
         * <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNDEPLOYMENT_SUCCESSFUL}</li>
         * <li> {@link com.vmware.nsx.model.InstanceRuntime#DEPLOYMENT_STATUS_UNKNOWN}</li>
         * </ul> Service-Instance Runtime deployment status of the Service-VM. It shows the
         * latest status during the process of deployment, redeploy, upgrade, and
         * un-deployment of VM.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param deploymentStatus New value for the property.
         */
        public Builder setDeploymentStatus(java.lang.String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        /**
         * Error message for the Service Instance Runtime if any.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param errorMessage New value for the property.
         */
        public Builder setErrorMessage(java.lang.String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_OFF}</li> <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_ENTERING}</li> <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_ON}</li> <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#MAINTENANCE_MODE_EXITING}</li> </ul> The
         * maintenance mode indicates whether the corresponding service VM is in
         * maintenance mode. The service VM will not be used to service new requests if it
         * is in maintenance mode.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param maintenanceMode New value for the property.
         */
        public Builder setMaintenanceMode(java.lang.String maintenanceMode) {
            this.maintenanceMode = maintenanceMode;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#RUNTIME_HEALTH_STATUS_BY_PARTNER_HEALTHY}</li>
         * <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#RUNTIME_HEALTH_STATUS_BY_PARTNER_STOPPED}</li>
         * <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#RUNTIME_HEALTH_STATUS_BY_PARTNER_NOT_RESPONDING}</li>
         * </ul> Service-Instance runtime health status set by partner to indicate whether
         * the service is running properly or not.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param runtimeHealthStatusByPartner New value for the property.
         */
        public Builder setRuntimeHealthStatusByPartner(java.lang.String runtimeHealthStatusByPartner) {
            this.runtimeHealthStatusByPartner = runtimeHealthStatusByPartner;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_IN_SERVICE}</li> <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_OUT_OF_SERVICE}</li> <li>
         * {@link com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_NEEDS_ATTENTION}</li>
         * <li> {@link
         * com.vmware.nsx.model.InstanceRuntime#RUNTIME_STATUS_NOT_AVAILABLE}</li> </ul>
         * Service-Instance Runtime status of the deployed Service-VM.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param runtimeStatus New value for the property.
         */
        public Builder setRuntimeStatus(java.lang.String runtimeStatus) {
            this.runtimeStatus = runtimeStatus;
            return this;
        }

        /**
         * Id of an instantiation of a registered service.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serviceInstanceId New value for the property.
         */
        public Builder setServiceInstanceId(java.lang.String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        /**
         * Service-VM/SVM id of deployed virtual-machine.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param serviceVmId New value for the property.
         */
        public Builder setServiceVmId(java.lang.String serviceVmId) {
            this.serviceVmId = serviceVmId;
            return this;
        }

        /**
         * Moref of the datastore in VC.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param storageId New value for the property.
         */
        public Builder setStorageId(java.lang.String storageId) {
            this.storageId = storageId;
            return this;
        }

        /**
         * Reason provided by partner for the service being unhealthy. This could be due to
         * various reasons such as connectivity lost as an example.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param unhealthyReason New value for the property.
         */
        public Builder setUnhealthyReason(java.lang.String unhealthyReason) {
            this.unhealthyReason = unhealthyReason;
            return this;
        }

        /**
         *
         *
         * @param vmNicInfo New value for the property.
         */
        public Builder setVmNicInfo(com.vmware.nsx.model.VmNicInfo vmNicInfo) {
            this.vmNicInfo = vmNicInfo;
            return this;
        }

        public InstanceRuntime build() {
            InstanceRuntime result = new InstanceRuntime();
            result.setLinks(this.links);
            result.setSchema(this.schema);
            result.setSelf(this.self);
            result.setRevision(this.revision);
            result.setCreateTime(this.createTime);
            result.setCreateUser(this.createUser);
            result.setLastModifiedTime(this.lastModifiedTime);
            result.setLastModifiedUser(this.lastModifiedUser);
            result.setProtection(this.protection);
            result.setSystemOwned(this.systemOwned);
            result.setDescription(this.description);
            result.setDisplayName(this.displayName);
            result.setId(this.id);
            result.setResourceType(this.resourceType);
            result.setTags(this.tags);
            result.setComputeCollectionId(this.computeCollectionId);
            result.setDeploymentStatus(this.deploymentStatus);
            result.setErrorMessage(this.errorMessage);
            result.setMaintenanceMode(this.maintenanceMode);
            result.setRuntimeHealthStatusByPartner(this.runtimeHealthStatusByPartner);
            result.setRuntimeStatus(this.runtimeStatus);
            result.setServiceInstanceId(this.serviceInstanceId);
            result.setServiceVmId(this.serviceVmId);
            result.setStorageId(this.storageId);
            result.setUnhealthyReason(this.unhealthyReason);
            result.setVmNicInfo(this.vmNicInfo);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("_links", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceLink; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_links",
                                                                                "links",
                                                                                "getLinks",
                                                                                "setLinks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_schema", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_schema",
                                                                                "schema",
                                                                                "getSchema",
                                                                                "setSchema");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_self", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.selfResourceLink; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_self",
                                                                                "self",
                                                                                "getSelf",
                                                                                "setSelf");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_revision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_revision",
                                                                                "revision",
                                                                                "getRevision",
                                                                                "setRevision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_time",
                                                                                "createTime",
                                                                                "getCreateTime",
                                                                                "setCreateTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_create_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_create_user",
                                                                                "createUser",
                                                                                "getCreateUser",
                                                                                "setCreateUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_time",
                                                                                "lastModifiedTime",
                                                                                "getLastModifiedTime",
                                                                                "setLastModifiedTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_last_modified_user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_last_modified_user",
                                                                                "lastModifiedUser",
                                                                                "getLastModifiedUser",
                                                                                "setLastModifiedUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_protection", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_protection",
                                                                                "protection",
                                                                                "getProtection",
                                                                                "setProtection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("_system_owned", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("_system_owned",
                                                                                "systemOwned",
                                                                                "getSystemOwned",
                                                                                "setSystemOwned");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("description", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("description",
                                                                                "description",
                                                                                "getDescription",
                                                                                "setDescription");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                "setResourceType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tags", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.tag; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tags",
                                                                                "tags",
                                                                                "getTags",
                                                                                "setTags");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("compute_collection_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("compute_collection_id",
                                                                                "computeCollectionId",
                                                                                "getComputeCollectionId",
                                                                                "setComputeCollectionId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("deployment_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("deployment_status",
                                                                                "deploymentStatus",
                                                                                "getDeploymentStatus",
                                                                                "setDeploymentStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_message", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_message",
                                                                                "errorMessage",
                                                                                "getErrorMessage",
                                                                                "setErrorMessage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("maintenance_mode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("maintenance_mode",
                                                                                "maintenanceMode",
                                                                                "getMaintenanceMode",
                                                                                "setMaintenanceMode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("runtime_health_status_by_partner", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("runtime_health_status_by_partner",
                                                                                "runtimeHealthStatusByPartner",
                                                                                "getRuntimeHealthStatusByPartner",
                                                                                "setRuntimeHealthStatusByPartner");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("runtime_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("runtime_status",
                                                                                "runtimeStatus",
                                                                                "getRuntimeStatus",
                                                                                "setRuntimeStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_instance_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_instance_id",
                                                                                "serviceInstanceId",
                                                                                "getServiceInstanceId",
                                                                                "setServiceInstanceId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_vm_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_vm_id",
                                                                                "serviceVmId",
                                                                                "getServiceVmId",
                                                                                "setServiceVmId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("storage_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("storage_id",
                                                                                "storageId",
                                                                                "getStorageId",
                                                                                "setStorageId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("unhealthy_reason", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("unhealthy_reason",
                                                                                "unhealthyReason",
                                                                                "getUnhealthyReason",
                                                                                "setUnhealthyReason");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("vm_nic_info", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.vmNicInfo; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("vm_nic_info",
                                                                                "vmNicInfo",
                                                                                "getVmNicInfo",
                                                                                "setVmNicInfo");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.instance_runtime",
                                                            fields,
                                                            com.vmware.nsx.model.InstanceRuntime.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

