/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * LbAccessListControl is used to define how IP access list control can filter the
 * connections from clients.
 */
public final class LbAccessListControl implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ACTION_ALLOW = "ALLOW";

    public static final java.lang.String ACTION_DROP = "DROP";

    private java.lang.String action;

    private java.lang.Boolean enabled;

    private java.lang.String groupId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbAccessListControl() {
    }

    protected LbAccessListControl(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbAccessListControl#ACTION_ALLOW}</li> <li> {@link
     * com.vmware.nsx.model.LbAccessListControl#ACTION_DROP}</li> </ul> ALLOW means
     * connections matching grouping object IP list are allowed and requests not
     * matching grouping object IP list are dropped. DROP means connections matching
     * grouping object IP list are dropped and requests not matching grouping object IP
     * list are allowed.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAction() {
        return this.action;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbAccessListControl#ACTION_ALLOW}</li> <li> {@link
     * com.vmware.nsx.model.LbAccessListControl#ACTION_DROP}</li> </ul> ALLOW means
     * connections matching grouping object IP list are allowed and requests not
     * matching grouping object IP list are dropped. DROP means connections matching
     * grouping object IP list are dropped and requests not matching grouping object IP
     * list are allowed.
     *
     * @param action New value for the property.
     */
    public void setAction(java.lang.String action) {
        this.action = action;
    }

    /**
     * The enabled flag indicates whether to enable access list control option. It is
     * false by default.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * The enabled flag indicates whether to enable access list control option. It is
     * false by default.
     *
     * @param enabled New value for the property.
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * The identifier of grouping object which defines the IP addresses or ranges to
     * match the client IP.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGroupId() {
        return this.groupId;
    }

    /**
     * The identifier of grouping object which defines the IP addresses or ranges to
     * match the client IP.
     *
     * @param groupId New value for the property.
     */
    public void setGroupId(java.lang.String groupId) {
        this.groupId = groupId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbAccessListControl;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("action",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.action, this._getType().getField("action")));
        structValue.setField("enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enabled, this._getType().getField("enabled")));
        structValue.setField("group_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupId, this._getType().getField("group_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbAccessListControl;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbAccessListControl.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbAccessListControl _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbAccessListControl(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbAccessListControl _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbAccessListControl(structValue);
    }

    /**
     * Builder class for {@link LbAccessListControl}.
     */
    public static final class Builder {
        private java.lang.String action;
        private java.lang.Boolean enabled;
        private java.lang.String groupId;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbAccessListControl}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbAccessListControl#ACTION_ALLOW}</li> <li> {@link
         * com.vmware.nsx.model.LbAccessListControl#ACTION_DROP}</li> </ul> ALLOW means
         * connections matching grouping object IP list are allowed and requests not
         * matching grouping object IP list are dropped. DROP means connections matching
         * grouping object IP list are dropped and requests not matching grouping object IP
         * list are allowed.
         *
         * @param action New value for the property.
         */
        public Builder setAction(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * The enabled flag indicates whether to enable access list control option. It is
         * false by default.
         *
         * @param enabled New value for the property.
         */
        public Builder setEnabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * The identifier of grouping object which defines the IP addresses or ranges to
         * match the client IP.
         *
         * @param groupId New value for the property.
         */
        public Builder setGroupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        public LbAccessListControl build() {
            LbAccessListControl result = new LbAccessListControl();
            result.setAction(this.action);
            result.setEnabled(this.enabled);
            result.setGroupId(this.groupId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("action", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("action",
                                                                                "action",
                                                                                "getAction",
                                                                                "setAction");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enabled",
                                                                                "enabled",
                                                                                "getEnabled",
                                                                                "setEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("group_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_id",
                                                                                "groupId",
                                                                                "getGroupId",
                                                                                "setGroupId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_access_list_control",
                                                            fields,
                                                            com.vmware.nsx.model.LbAccessListControl.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

