/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class LbServiceStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String SERVICE_STATUS_UP = "UP";

    public static final java.lang.String SERVICE_STATUS_PARTIALLY_UP = "PARTIALLY_UP";

    public static final java.lang.String SERVICE_STATUS_DOWN = "DOWN";

    public static final java.lang.String SERVICE_STATUS_ERROR = "ERROR";

    public static final java.lang.String SERVICE_STATUS_NO_STANDBY = "NO_STANDBY";

    public static final java.lang.String SERVICE_STATUS_DETACHED = "DETACHED";

    public static final java.lang.String SERVICE_STATUS_DISABLED = "DISABLED";

    public static final java.lang.String SERVICE_STATUS_UNKNOWN = "UNKNOWN";

    private java.util.List<java.lang.String> activeTransportNodes;

    private java.lang.Long cpuUsage;

    private java.lang.String errorMessage;

    private java.util.List<com.vmware.nsx.model.LbServiceInstanceDetailPerTransportNode> instanceDetailPerTn;

    private java.lang.Long lastUpdateTimestamp;

    private java.lang.Long memoryUsage;

    private java.util.List<com.vmware.nsx.model.LbPoolStatus> pools;

    private java.lang.String serviceId;

    private java.lang.String serviceStatus;

    private java.util.List<java.lang.String> standbyTransportNodes;

    private java.util.List<com.vmware.nsx.model.LbVirtualServerStatus> virtualServers;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbServiceStatus() {
    }

    protected LbServiceStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Ids of load balancer service related active transport nodes
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getActiveTransportNodes() {
        return this.activeTransportNodes;
    }

    /**
     * Ids of load balancer service related active transport nodes
     *
     * @param activeTransportNodes New value for the property.
     */
    public void setActiveTransportNodes(java.util.List<java.lang.String> activeTransportNodes) {
        this.activeTransportNodes = activeTransportNodes;
    }

    /**
     * Cpu usage in percentage format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCpuUsage() {
        return this.cpuUsage;
    }

    /**
     * Cpu usage in percentage format: int64
     *
     * @param cpuUsage New value for the property.
     */
    public void setCpuUsage(java.lang.Long cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    /**
     * Error message, if available
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * Error message, if available
     *
     * @param errorMessage New value for the property.
     */
    public void setErrorMessage(java.lang.String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * Details of load balancer service instance per transport node.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.LbServiceInstanceDetailPerTransportNode> getInstanceDetailPerTn() {
        return this.instanceDetailPerTn;
    }

    /**
     * Details of load balancer service instance per transport node.
     *
     * @param instanceDetailPerTn New value for the property.
     */
    public void setInstanceDetailPerTn(java.util.List<com.vmware.nsx.model.LbServiceInstanceDetailPerTransportNode> instanceDetailPerTn) {
        this.instanceDetailPerTn = instanceDetailPerTn;
    }

    /**
     * Timestamp when the data was last updated format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    /**
     * Timestamp when the data was last updated format: int64
     *
     * @param lastUpdateTimestamp New value for the property.
     */
    public void setLastUpdateTimestamp(java.lang.Long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    /**
     * Memory usage in percentage format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMemoryUsage() {
        return this.memoryUsage;
    }

    /**
     * Memory usage in percentage format: int64
     *
     * @param memoryUsage New value for the property.
     */
    public void setMemoryUsage(java.lang.Long memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    /**
     * status of load balancer pools
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.LbPoolStatus> getPools() {
        return this.pools;
    }

    /**
     * status of load balancer pools
     *
     * @param pools New value for the property.
     */
    public void setPools(java.util.List<com.vmware.nsx.model.LbPoolStatus> pools) {
        this.pools = pools;
    }

    /**
     * Load balancer service identifier
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceId() {
        return this.serviceId;
    }

    /**
     * Load balancer service identifier
     *
     * @param serviceId New value for the property.
     */
    public void setServiceId(java.lang.String serviceId) {
        this.serviceId = serviceId;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_PARTIALLY_UP}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_DOWN}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_ERROR}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_NO_STANDBY}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_DETACHED}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_DISABLED}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_UNKNOWN}</li> </ul>
     * UP means the load balancer service is working fine on both transport-nodes(if
     * have); PARTIALLY_UP means that some DLB instances on transport node are working
     * successfully and some instances are not working successfully; DOWN means the
     * load balancer service is down on both transport-nodes (if have), hence the load
     * balancer will not respond to any requests; ERROR means error happens on
     * transport-node(s) or no status is reported from transport-node(s). The load
     * balancer service may be working (or not working); NO_STANDBY means load balancer
     * service is working in one of the transport node while not in the other
     * transport-node (if have). Hence if the load balancer service in the working
     * transport-node goes down, the load balancer service will go down; DETACHED means
     * that the load balancer service has no attachment setting and is not instantiated
     * in any transport nodes; DISABLED means that admin state of load balancer service
     * is DISABLED; UNKNOWN means that no status reported from transport-nodes.The load
     * balancer service may be working(or not working).
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceStatus() {
        return this.serviceStatus;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_UP}</li> <li> {@link
     * com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_PARTIALLY_UP}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_DOWN}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_ERROR}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_NO_STANDBY}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_DETACHED}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_DISABLED}</li> <li>
     * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_UNKNOWN}</li> </ul>
     * UP means the load balancer service is working fine on both transport-nodes(if
     * have); PARTIALLY_UP means that some DLB instances on transport node are working
     * successfully and some instances are not working successfully; DOWN means the
     * load balancer service is down on both transport-nodes (if have), hence the load
     * balancer will not respond to any requests; ERROR means error happens on
     * transport-node(s) or no status is reported from transport-node(s). The load
     * balancer service may be working (or not working); NO_STANDBY means load balancer
     * service is working in one of the transport node while not in the other
     * transport-node (if have). Hence if the load balancer service in the working
     * transport-node goes down, the load balancer service will go down; DETACHED means
     * that the load balancer service has no attachment setting and is not instantiated
     * in any transport nodes; DISABLED means that admin state of load balancer service
     * is DISABLED; UNKNOWN means that no status reported from transport-nodes.The load
     * balancer service may be working(or not working).
     *
     * @param serviceStatus New value for the property.
     */
    public void setServiceStatus(java.lang.String serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    /**
     * Ids of load balancer service related standby transport nodes
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getStandbyTransportNodes() {
        return this.standbyTransportNodes;
    }

    /**
     * Ids of load balancer service related standby transport nodes
     *
     * @param standbyTransportNodes New value for the property.
     */
    public void setStandbyTransportNodes(java.util.List<java.lang.String> standbyTransportNodes) {
        this.standbyTransportNodes = standbyTransportNodes;
    }

    /**
     * status of load balancer virtual servers
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.LbVirtualServerStatus> getVirtualServers() {
        return this.virtualServers;
    }

    /**
     * status of load balancer virtual servers
     *
     * @param virtualServers New value for the property.
     */
    public void setVirtualServers(java.util.List<com.vmware.nsx.model.LbVirtualServerStatus> virtualServers) {
        this.virtualServers = virtualServers;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbServiceStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("active_transport_nodes",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.activeTransportNodes, this._getType().getField("active_transport_nodes")));
        structValue.setField("cpu_usage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cpuUsage, this._getType().getField("cpu_usage")));
        structValue.setField("error_message",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorMessage, this._getType().getField("error_message")));
        structValue.setField("instance_detail_per_tn",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.instanceDetailPerTn, this._getType().getField("instance_detail_per_tn")));
        structValue.setField("last_update_timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.lastUpdateTimestamp, this._getType().getField("last_update_timestamp")));
        structValue.setField("memory_usage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.memoryUsage, this._getType().getField("memory_usage")));
        structValue.setField("pools",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pools, this._getType().getField("pools")));
        structValue.setField("service_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceId, this._getType().getField("service_id")));
        structValue.setField("service_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceStatus, this._getType().getField("service_status")));
        structValue.setField("standby_transport_nodes",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.standbyTransportNodes, this._getType().getField("standby_transport_nodes")));
        structValue.setField("virtual_servers",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.virtualServers, this._getType().getField("virtual_servers")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbServiceStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbServiceStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbServiceStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbServiceStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbServiceStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbServiceStatus(structValue);
    }

    /**
     * Builder class for {@link LbServiceStatus}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> activeTransportNodes;
        private java.lang.Long cpuUsage;
        private java.lang.String errorMessage;
        private java.util.List<com.vmware.nsx.model.LbServiceInstanceDetailPerTransportNode> instanceDetailPerTn;
        private java.lang.Long lastUpdateTimestamp;
        private java.lang.Long memoryUsage;
        private java.util.List<com.vmware.nsx.model.LbPoolStatus> pools;
        private java.lang.String serviceId;
        private java.lang.String serviceStatus;
        private java.util.List<java.lang.String> standbyTransportNodes;
        private java.util.List<com.vmware.nsx.model.LbVirtualServerStatus> virtualServers;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbServiceStatus}.
         */
        public Builder() {
        }

        /**
         * Ids of load balancer service related active transport nodes
         *
         * @param activeTransportNodes New value for the property.
         */
        public Builder setActiveTransportNodes(java.util.List<java.lang.String> activeTransportNodes) {
            this.activeTransportNodes = activeTransportNodes;
            return this;
        }

        /**
         * Cpu usage in percentage format: int64
         *
         * @param cpuUsage New value for the property.
         */
        public Builder setCpuUsage(java.lang.Long cpuUsage) {
            this.cpuUsage = cpuUsage;
            return this;
        }

        /**
         * Error message, if available
         *
         * @param errorMessage New value for the property.
         */
        public Builder setErrorMessage(java.lang.String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        /**
         * Details of load balancer service instance per transport node.
         *
         * @param instanceDetailPerTn New value for the property.
         */
        public Builder setInstanceDetailPerTn(java.util.List<com.vmware.nsx.model.LbServiceInstanceDetailPerTransportNode> instanceDetailPerTn) {
            this.instanceDetailPerTn = instanceDetailPerTn;
            return this;
        }

        /**
         * Timestamp when the data was last updated format: int64
         *
         * @param lastUpdateTimestamp New value for the property.
         */
        public Builder setLastUpdateTimestamp(java.lang.Long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        /**
         * Memory usage in percentage format: int64
         *
         * @param memoryUsage New value for the property.
         */
        public Builder setMemoryUsage(java.lang.Long memoryUsage) {
            this.memoryUsage = memoryUsage;
            return this;
        }

        /**
         * status of load balancer pools
         *
         * @param pools New value for the property.
         */
        public Builder setPools(java.util.List<com.vmware.nsx.model.LbPoolStatus> pools) {
            this.pools = pools;
            return this;
        }

        /**
         * Load balancer service identifier
         *
         * @param serviceId New value for the property.
         */
        public Builder setServiceId(java.lang.String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_UP}</li> <li> {@link
         * com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_PARTIALLY_UP}</li> <li>
         * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_DOWN}</li> <li>
         * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_ERROR}</li> <li>
         * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_NO_STANDBY}</li> <li>
         * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_DETACHED}</li> <li>
         * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_DISABLED}</li> <li>
         * {@link com.vmware.nsx.model.LbServiceStatus#SERVICE_STATUS_UNKNOWN}</li> </ul>
         * UP means the load balancer service is working fine on both transport-nodes(if
         * have); PARTIALLY_UP means that some DLB instances on transport node are working
         * successfully and some instances are not working successfully; DOWN means the
         * load balancer service is down on both transport-nodes (if have), hence the load
         * balancer will not respond to any requests; ERROR means error happens on
         * transport-node(s) or no status is reported from transport-node(s). The load
         * balancer service may be working (or not working); NO_STANDBY means load balancer
         * service is working in one of the transport node while not in the other
         * transport-node (if have). Hence if the load balancer service in the working
         * transport-node goes down, the load balancer service will go down; DETACHED means
         * that the load balancer service has no attachment setting and is not instantiated
         * in any transport nodes; DISABLED means that admin state of load balancer service
         * is DISABLED; UNKNOWN means that no status reported from transport-nodes.The load
         * balancer service may be working(or not working).
         *
         * @param serviceStatus New value for the property.
         */
        public Builder setServiceStatus(java.lang.String serviceStatus) {
            this.serviceStatus = serviceStatus;
            return this;
        }

        /**
         * Ids of load balancer service related standby transport nodes
         *
         * @param standbyTransportNodes New value for the property.
         */
        public Builder setStandbyTransportNodes(java.util.List<java.lang.String> standbyTransportNodes) {
            this.standbyTransportNodes = standbyTransportNodes;
            return this;
        }

        /**
         * status of load balancer virtual servers
         *
         * @param virtualServers New value for the property.
         */
        public Builder setVirtualServers(java.util.List<com.vmware.nsx.model.LbVirtualServerStatus> virtualServers) {
            this.virtualServers = virtualServers;
            return this;
        }

        public LbServiceStatus build() {
            LbServiceStatus result = new LbServiceStatus();
            result.setActiveTransportNodes(this.activeTransportNodes);
            result.setCpuUsage(this.cpuUsage);
            result.setErrorMessage(this.errorMessage);
            result.setInstanceDetailPerTn(this.instanceDetailPerTn);
            result.setLastUpdateTimestamp(this.lastUpdateTimestamp);
            result.setMemoryUsage(this.memoryUsage);
            result.setPools(this.pools);
            result.setServiceId(this.serviceId);
            result.setServiceStatus(this.serviceStatus);
            result.setStandbyTransportNodes(this.standbyTransportNodes);
            result.setVirtualServers(this.virtualServers);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("active_transport_nodes", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("active_transport_nodes",
                                                                                "activeTransportNodes",
                                                                                "getActiveTransportNodes",
                                                                                "setActiveTransportNodes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cpu_usage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cpu_usage",
                                                                                "cpuUsage",
                                                                                "getCpuUsage",
                                                                                "setCpuUsage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_message", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_message",
                                                                                "errorMessage",
                                                                                "getErrorMessage",
                                                                                "setErrorMessage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("instance_detail_per_tn", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbServiceInstanceDetailPerTransportNode; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("instance_detail_per_tn",
                                                                                "instanceDetailPerTn",
                                                                                "getInstanceDetailPerTn",
                                                                                "setInstanceDetailPerTn");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("last_update_timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("last_update_timestamp",
                                                                                "lastUpdateTimestamp",
                                                                                "getLastUpdateTimestamp",
                                                                                "setLastUpdateTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("memory_usage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("memory_usage",
                                                                                "memoryUsage",
                                                                                "getMemoryUsage",
                                                                                "setMemoryUsage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pools", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbPoolStatus; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pools",
                                                                                "pools",
                                                                                "getPools",
                                                                                "setPools");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_id",
                                                                                "serviceId",
                                                                                "getServiceId",
                                                                                "setServiceId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("service_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_status",
                                                                                "serviceStatus",
                                                                                "getServiceStatus",
                                                                                "setServiceStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("standby_transport_nodes", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("standby_transport_nodes",
                                                                                "standbyTransportNodes",
                                                                                "getStandbyTransportNodes",
                                                                                "setStandbyTransportNodes");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("virtual_servers", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbVirtualServerStatus; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("virtual_servers",
                                                                                "virtualServers",
                                                                                "getVirtualServers",
                                                                                "setVirtualServers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_service_status",
                                                            fields,
                                                            com.vmware.nsx.model.LbServiceStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

