/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class LbSnatIpPool implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "LbSnatIpPool";

    private java.util.List<com.vmware.nsx.model.LbSnatIpElement> ipAddresses;

    private java.lang.Long portOverload;

    private final java.lang.String type = "LbSnatIpPool";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LbSnatIpPool() {
    }

    protected LbSnatIpPool(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * If an IP range is specified, the range may contain no more than 64 IP addresses.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.LbSnatIpElement> getIpAddresses() {
        return this.ipAddresses;
    }

    /**
     * If an IP range is specified, the range may contain no more than 64 IP addresses.
     *
     * @param ipAddresses New value for the property.
     */
    public void setIpAddresses(java.util.List<com.vmware.nsx.model.LbSnatIpElement> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    /**
     * Both SNAT automap and SNAT IP list modes support port overloading which allows
     * the same SNAT IP and port to be used for multiple backend connections as long as
     * the tuple (source IP, source port, destination IP, destination port, IP
     * protocol) after SNAT is performed is unique. The valid number is 1, 2, 4, 8, 16,
     * 32. This is a deprecated property. The port overload factor is fixed to 32 in
     * load balancer engine. If it is upgraded from an old version, the value would be
     * changed to 32 automatically. format: int64
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.Long getPortOverload() {
        return this.portOverload;
    }

    /**
     * Both SNAT automap and SNAT IP list modes support port overloading which allows
     * the same SNAT IP and port to be used for multiple backend connections as long as
     * the tuple (source IP, source port, destination IP, destination port, IP
     * protocol) after SNAT is performed is unique. The valid number is 1, 2, 4, 8, 16,
     * 32. This is a deprecated property. The port overload factor is fixed to 32 in
     * load balancer engine. If it is upgraded from an old version, the value would be
     * changed to 32 automatically. format: int64
     *
     * @param portOverload New value for the property.
     */
    @Deprecated
    public void setPortOverload(java.lang.Long portOverload) {
        this.portOverload = portOverload;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.LbSnatTranslation#TYPE_LBSNATAUTOMAP}</li> <li> {@link
     * com.vmware.nsx.model.LbSnatTranslation#TYPE_LBSNATIPPOOL}</li> </ul> Load
     * balancers may need to perform SNAT to ensure reverse traffic from the server can
     * be received and processed by them. There are two modes: LbSnatAutoMap uses the
     * load balancer interface IP and an ephemeral port as the source IP and port of
     * the server side connection. LbSnatIpPool allows user to specify one or more IP
     * addresses along with their subnet masks that should be used for SNAT while
     * connecting to any of the servers in the pool.
     * The value of this property is automatically populated to {@code "LbSnatIpPool"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.lbSnatIpPool;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("ip_addresses",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddresses, this._getType().getField("ip_addresses")));
        structValue.setField("port_overload",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.portOverload, this._getType().getField("port_overload")));
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.lbSnatIpPool;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.lbSnatIpPool.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LbSnatIpPool _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LbSnatIpPool(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LbSnatIpPool _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LbSnatIpPool(structValue);
    }

    /**
     * Builder class for {@link LbSnatIpPool}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx.model.LbSnatIpElement> ipAddresses;
        private java.lang.Long portOverload;

        /**
         * Constructor with parameters for the required properties of
         * {@link LbSnatIpPool}.
         */
        public Builder() {
        }

        /**
         * If an IP range is specified, the range may contain no more than 64 IP addresses.
         *
         * @param ipAddresses New value for the property.
         */
        public Builder setIpAddresses(java.util.List<com.vmware.nsx.model.LbSnatIpElement> ipAddresses) {
            this.ipAddresses = ipAddresses;
            return this;
        }

        /**
         * Both SNAT automap and SNAT IP list modes support port overloading which allows
         * the same SNAT IP and port to be used for multiple backend connections as long as
         * the tuple (source IP, source port, destination IP, destination port, IP
         * protocol) after SNAT is performed is unique. The valid number is 1, 2, 4, 8, 16,
         * 32. This is a deprecated property. The port overload factor is fixed to 32 in
         * load balancer engine. If it is upgraded from an old version, the value would be
         * changed to 32 automatically. format: int64
         *
         * @param portOverload New value for the property.
         */
        public Builder setPortOverload(java.lang.Long portOverload) {
            this.portOverload = portOverload;
            return this;
        }

        public LbSnatIpPool build() {
            LbSnatIpPool result = new LbSnatIpPool();
            result.setIpAddresses(this.ipAddresses);
            result.setPortOverload(this.portOverload);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("ip_addresses", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.lbSnatIpElement; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_addresses",
                                                                                "ipAddresses",
                                                                                "getIpAddresses",
                                                                                "setIpAddresses");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port_overload", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port_overload",
                                                                                "portOverload",
                                                                                "getPortOverload",
                                                                                "setPortOverload");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.lb_snat_ip_pool",
                                                            fields,
                                                            com.vmware.nsx.model.LbSnatIpPool.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "type",
                                                            "LbSnatIpPool");
    }
}

