/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Logical router configuration parameters.
 */
public final class LogicalRouterConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.util.List<java.lang.String> externalTransitNetworks;

    private java.util.List<com.vmware.nsx.model.HaVipConfig> haVipConfigs;

    private java.lang.String internalTransitNetwork;

    private java.lang.String transportZoneId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LogicalRouterConfig() {
    }

    protected LogicalRouterConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * CIDR block defining addresses for Tier0 to Tier1 links. If the value for this
     * field is not provided, then it will be considered as default IPv4 CIDR
     * \"100.64.0.0/16\" format: ip-cidr-block
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getExternalTransitNetworks() {
        return this.externalTransitNetworks;
    }

    /**
     * CIDR block defining addresses for Tier0 to Tier1 links. If the value for this
     * field is not provided, then it will be considered as default IPv4 CIDR
     * \"100.64.0.0/16\" format: ip-cidr-block
     *
     * @param externalTransitNetworks New value for the property.
     */
    public void setExternalTransitNetworks(java.util.List<java.lang.String> externalTransitNetworks) {
        this.externalTransitNetworks = externalTransitNetworks;
    }

    /**
     * This configuration can be defined only for Active-Standby LogicalRouter to
     * provide | redundancy. For mulitple uplink ports, multiple HaVipConfigs must be
     * defined | and each config will pair exactly two uplink ports. The VIP will move
     * and will | always be owned by the Active node. Note - when HaVipConfig[s] are
     * defined, | configuring dynamic-routing is disallowed.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx.model.HaVipConfig> getHaVipConfigs() {
        return this.haVipConfigs;
    }

    /**
     * This configuration can be defined only for Active-Standby LogicalRouter to
     * provide | redundancy. For mulitple uplink ports, multiple HaVipConfigs must be
     * defined | and each config will pair exactly two uplink ports. The VIP will move
     * and will | always be owned by the Active node. Note - when HaVipConfig[s] are
     * defined, | configuring dynamic-routing is disallowed.
     *
     * @param haVipConfigs New value for the property.
     */
    public void setHaVipConfigs(java.util.List<com.vmware.nsx.model.HaVipConfig> haVipConfigs) {
        this.haVipConfigs = haVipConfigs;
    }

    /**
     * CIDR block defining service router to distributed router links. If the value for
     * this field is not provided, then it will be considered as default IPv4 CIDR-
     * \"169.254.0.0/28\" for logical router with ACTIVE_STANDBY HA mode
     * \"169.254.0.0/24\" for logical router with ACTIVE_ACTIVE HA mode format:
     * ipv4-cidr-block
     *
     * @return The current value of the property.
     */
    public java.lang.String getInternalTransitNetwork() {
        return this.internalTransitNetwork;
    }

    /**
     * CIDR block defining service router to distributed router links. If the value for
     * this field is not provided, then it will be considered as default IPv4 CIDR-
     * \"169.254.0.0/28\" for logical router with ACTIVE_STANDBY HA mode
     * \"169.254.0.0/24\" for logical router with ACTIVE_ACTIVE HA mode format:
     * ipv4-cidr-block
     *
     * @param internalTransitNetwork New value for the property.
     */
    public void setInternalTransitNetwork(java.lang.String internalTransitNetwork) {
        this.internalTransitNetwork = internalTransitNetwork;
    }

    /**
     * Transport zone of the logical router. If specified then all downlink switches
     * should belong to this transport zone and an error will be thrown if transport
     * zone of the downlink switch doesn't match with this transport zone. All internal
     * and external transit switches will be created in this transport zone.
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransportZoneId() {
        return this.transportZoneId;
    }

    /**
     * Transport zone of the logical router. If specified then all downlink switches
     * should belong to this transport zone and an error will be thrown if transport
     * zone of the downlink switch doesn't match with this transport zone. All internal
     * and external transit switches will be created in this transport zone.
     *
     * @param transportZoneId New value for the property.
     */
    public void setTransportZoneId(java.lang.String transportZoneId) {
        this.transportZoneId = transportZoneId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.logicalRouterConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("external_transit_networks",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.externalTransitNetworks, this._getType().getField("external_transit_networks")));
        structValue.setField("ha_vip_configs",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.haVipConfigs, this._getType().getField("ha_vip_configs")));
        structValue.setField("internal_transit_network",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.internalTransitNetwork, this._getType().getField("internal_transit_network")));
        structValue.setField("transport_zone_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transportZoneId, this._getType().getField("transport_zone_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.logicalRouterConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.logicalRouterConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LogicalRouterConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LogicalRouterConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LogicalRouterConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LogicalRouterConfig(structValue);
    }

    /**
     * Builder class for {@link LogicalRouterConfig}.
     */
    public static final class Builder {
        private java.util.List<java.lang.String> externalTransitNetworks;
        private java.util.List<com.vmware.nsx.model.HaVipConfig> haVipConfigs;
        private java.lang.String internalTransitNetwork;
        private java.lang.String transportZoneId;

        /**
         * Constructor with parameters for the required properties of
         * {@link LogicalRouterConfig}.
         */
        public Builder() {
        }

        /**
         * CIDR block defining addresses for Tier0 to Tier1 links. If the value for this
         * field is not provided, then it will be considered as default IPv4 CIDR
         * \"100.64.0.0/16\" format: ip-cidr-block
         *
         * @param externalTransitNetworks New value for the property.
         */
        public Builder setExternalTransitNetworks(java.util.List<java.lang.String> externalTransitNetworks) {
            this.externalTransitNetworks = externalTransitNetworks;
            return this;
        }

        /**
         * This configuration can be defined only for Active-Standby LogicalRouter to
         * provide | redundancy. For mulitple uplink ports, multiple HaVipConfigs must be
         * defined | and each config will pair exactly two uplink ports. The VIP will move
         * and will | always be owned by the Active node. Note - when HaVipConfig[s] are
         * defined, | configuring dynamic-routing is disallowed.
         *
         * @param haVipConfigs New value for the property.
         */
        public Builder setHaVipConfigs(java.util.List<com.vmware.nsx.model.HaVipConfig> haVipConfigs) {
            this.haVipConfigs = haVipConfigs;
            return this;
        }

        /**
         * CIDR block defining service router to distributed router links. If the value for
         * this field is not provided, then it will be considered as default IPv4 CIDR-
         * \"169.254.0.0/28\" for logical router with ACTIVE_STANDBY HA mode
         * \"169.254.0.0/24\" for logical router with ACTIVE_ACTIVE HA mode format:
         * ipv4-cidr-block
         *
         * @param internalTransitNetwork New value for the property.
         */
        public Builder setInternalTransitNetwork(java.lang.String internalTransitNetwork) {
            this.internalTransitNetwork = internalTransitNetwork;
            return this;
        }

        /**
         * Transport zone of the logical router. If specified then all downlink switches
         * should belong to this transport zone and an error will be thrown if transport
         * zone of the downlink switch doesn't match with this transport zone. All internal
         * and external transit switches will be created in this transport zone.
         *
         * @param transportZoneId New value for the property.
         */
        public Builder setTransportZoneId(java.lang.String transportZoneId) {
            this.transportZoneId = transportZoneId;
            return this;
        }

        public LogicalRouterConfig build() {
            LogicalRouterConfig result = new LogicalRouterConfig();
            result.setExternalTransitNetworks(this.externalTransitNetworks);
            result.setHaVipConfigs(this.haVipConfigs);
            result.setInternalTransitNetwork(this.internalTransitNetwork);
            result.setTransportZoneId(this.transportZoneId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("external_transit_networks", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("external_transit_networks",
                                                                                "externalTransitNetworks",
                                                                                "getExternalTransitNetworks",
                                                                                "setExternalTransitNetworks");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ha_vip_configs", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.haVipConfig; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ha_vip_configs",
                                                                                "haVipConfigs",
                                                                                "getHaVipConfigs",
                                                                                "setHaVipConfigs");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("internal_transit_network", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("internal_transit_network",
                                                                                "internalTransitNetwork",
                                                                                "getInternalTransitNetwork",
                                                                                "setInternalTransitNetwork");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("transport_zone_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transport_zone_id",
                                                                                "transportZoneId",
                                                                                "getTransportZoneId",
                                                                                "setTransportZoneId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.logical_router_config",
                                                            fields,
                                                            com.vmware.nsx.model.LogicalRouterConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

