/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Relative to the form factor pre-defined reservation value. To reduce reservation
 * of a VM to 50 percent, a user may specify 50 instead of the absolute number
 * relevant for the edge form factor.
 */
public final class MemoryReservation implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long reservationPercentage;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public MemoryReservation() {
    }

    protected MemoryReservation(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Memory reserved relative to the default reservation of 100 percent. For example,
     * take an edge virtual machine of medium form factor. By default, an edge of
     * medium form factor is configured with 8 GB of memory and with reservation of 100
     * percent. So, 8 GB of memory is reserved. If you specify reservation_percentage
     * value as 50 percent, then 4 GB of memory will be reserved. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReservationPercentage() {
        return this.reservationPercentage;
    }

    /**
     * Memory reserved relative to the default reservation of 100 percent. For example,
     * take an edge virtual machine of medium form factor. By default, an edge of
     * medium form factor is configured with 8 GB of memory and with reservation of 100
     * percent. So, 8 GB of memory is reserved. If you specify reservation_percentage
     * value as 50 percent, then 4 GB of memory will be reserved. format: int32
     *
     * @param reservationPercentage New value for the property.
     */
    public void setReservationPercentage(java.lang.Long reservationPercentage) {
        this.reservationPercentage = reservationPercentage;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.memoryReservation;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("reservation_percentage",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.reservationPercentage, this._getType().getField("reservation_percentage")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.memoryReservation;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.memoryReservation.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static MemoryReservation _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new MemoryReservation(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static MemoryReservation _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new MemoryReservation(structValue);
    }

    /**
     * Builder class for {@link MemoryReservation}.
     */
    public static final class Builder {
        private java.lang.Long reservationPercentage;

        /**
         * Constructor with parameters for the required properties of
         * {@link MemoryReservation}.
         */
        public Builder() {
        }

        /**
         * Memory reserved relative to the default reservation of 100 percent. For example,
         * take an edge virtual machine of medium form factor. By default, an edge of
         * medium form factor is configured with 8 GB of memory and with reservation of 100
         * percent. So, 8 GB of memory is reserved. If you specify reservation_percentage
         * value as 50 percent, then 4 GB of memory will be reserved. format: int32
         *
         * @param reservationPercentage New value for the property.
         */
        public Builder setReservationPercentage(java.lang.Long reservationPercentage) {
            this.reservationPercentage = reservationPercentage;
            return this;
        }

        public MemoryReservation build() {
            MemoryReservation result = new MemoryReservation();
            result.setReservationPercentage(this.reservationPercentage);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("reservation_percentage", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reservation_percentage",
                                                                                "reservationPercentage",
                                                                                "getReservationPercentage",
                                                                                "setReservationPercentage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.memory_reservation",
                                                            fields,
                                                            com.vmware.nsx.model.MemoryReservation.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

