/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Details about switch to be migrated
 */
public final class MigrationSwitchInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String KIND_DVS = "DVS";

    public static final java.lang.String KIND_VSS = "VSS";

    private java.lang.String id;

    private java.lang.String kind;

    private java.lang.String name;

    private java.lang.Long pnicCount;

    private java.lang.String version;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public MigrationSwitchInfo() {
    }

    protected MigrationSwitchInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Switch Identifier.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * Switch Identifier.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param id New value for the property.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.MigrationSwitchInfo#KIND_DVS}</li> <li> {@link
     * com.vmware.nsx.model.MigrationSwitchInfo#KIND_VSS}</li> </ul> Kind of switch,
     * can be DVS, VSS.
     *
     * @return The current value of the property.
     */
    public java.lang.String getKind() {
        return this.kind;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.MigrationSwitchInfo#KIND_DVS}</li> <li> {@link
     * com.vmware.nsx.model.MigrationSwitchInfo#KIND_VSS}</li> </ul> Kind of switch,
     * can be DVS, VSS.
     *
     * @param kind New value for the property.
     */
    public void setKind(java.lang.String kind) {
        this.kind = kind;
    }

    /**
     * Name of the switch.
     *
     * @return The current value of the property.
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * Name of the switch.
     *
     * @param name New value for the property.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * Number of PNICs associated with this switch. format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPnicCount() {
        return this.pnicCount;
    }

    /**
     * Number of PNICs associated with this switch. format: int32
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param pnicCount New value for the property.
     */
    public void setPnicCount(java.lang.Long pnicCount) {
        this.pnicCount = pnicCount;
    }

    /**
     * Version of the switch to be migrated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getVersion() {
        return this.version;
    }

    /**
     * Version of the switch to be migrated.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param version New value for the property.
     */
    public void setVersion(java.lang.String version) {
        this.version = version;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.migrationSwitchInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
        structValue.setField("kind",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.kind, this._getType().getField("kind")));
        structValue.setField("name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.name, this._getType().getField("name")));
        structValue.setField("pnic_count",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.pnicCount, this._getType().getField("pnic_count")));
        structValue.setField("version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.version, this._getType().getField("version")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.migrationSwitchInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.migrationSwitchInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static MigrationSwitchInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new MigrationSwitchInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static MigrationSwitchInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new MigrationSwitchInfo(structValue);
    }

    /**
     * Builder class for {@link MigrationSwitchInfo}.
     */
    public static final class Builder {
        private java.lang.String id;
        private java.lang.String kind;
        private java.lang.String name;
        private java.lang.Long pnicCount;
        private java.lang.String version;

        /**
         * Constructor with parameters for the required properties of
         * {@link MigrationSwitchInfo}.
         */
        public Builder() {
        }

        /**
         * Switch Identifier.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param id New value for the property.
         */
        public Builder setId(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.MigrationSwitchInfo#KIND_DVS}</li> <li> {@link
         * com.vmware.nsx.model.MigrationSwitchInfo#KIND_VSS}</li> </ul> Kind of switch,
         * can be DVS, VSS.
         *
         * @param kind New value for the property.
         */
        public Builder setKind(java.lang.String kind) {
            this.kind = kind;
            return this;
        }

        /**
         * Name of the switch.
         *
         * @param name New value for the property.
         */
        public Builder setName(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Number of PNICs associated with this switch. format: int32
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param pnicCount New value for the property.
         */
        public Builder setPnicCount(java.lang.Long pnicCount) {
            this.pnicCount = pnicCount;
            return this;
        }

        /**
         * Version of the switch to be migrated.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param version New value for the property.
         */
        public Builder setVersion(java.lang.String version) {
            this.version = version;
            return this;
        }

        public MigrationSwitchInfo build() {
            MigrationSwitchInfo result = new MigrationSwitchInfo();
            result.setId(this.id);
            result.setKind(this.kind);
            result.setName(this.name);
            result.setPnicCount(this.pnicCount);
            result.setVersion(this.version);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("kind", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("kind",
                                                                                "kind",
                                                                                "getKind",
                                                                                "setKind");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                "name",
                                                                                "getName",
                                                                                "setName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("pnic_count", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("pnic_count",
                                                                                "pnicCount",
                                                                                "getPnicCount",
                                                                                "setPnicCount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("version",
                                                                                "version",
                                                                                "getVersion",
                                                                                "setVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.migration_switch_info",
                                                            fields,
                                                            com.vmware.nsx.model.MigrationSwitchInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

