/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Overrides the router advertisement attributes for the IPv6 prefixes.
 */
public final class NDRAPrefixConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String networkPrefix;

    private java.lang.Long prefixPreferredTime;

    private java.lang.Long prefixValidTime;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NDRAPrefixConfig() {
    }

    protected NDRAPrefixConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Override the neighbor discovery prefix preferred time and prefix valid time for
     * the subnet on uplink port whose network matches with the network address of CIDR
     * specified in network_prefix. format: ipv6-cidr-block
     *
     * @return The current value of the property.
     */
    public java.lang.String getNetworkPrefix() {
        return this.networkPrefix;
    }

    /**
     * Override the neighbor discovery prefix preferred time and prefix valid time for
     * the subnet on uplink port whose network matches with the network address of CIDR
     * specified in network_prefix. format: ipv6-cidr-block
     *
     * @param networkPrefix New value for the property.
     */
    public void setNetworkPrefix(java.lang.String networkPrefix) {
        this.networkPrefix = networkPrefix;
    }

    /**
     * The time interval in seconds, in which the prefix is advertised as preferred.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPrefixPreferredTime() {
        return this.prefixPreferredTime;
    }

    /**
     * The time interval in seconds, in which the prefix is advertised as preferred.
     * format: int64
     *
     * @param prefixPreferredTime New value for the property.
     */
    public void setPrefixPreferredTime(java.lang.Long prefixPreferredTime) {
        this.prefixPreferredTime = prefixPreferredTime;
    }

    /**
     * The time interval in seconds, in which the prefix is advertised as valid.
     * format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPrefixValidTime() {
        return this.prefixValidTime;
    }

    /**
     * The time interval in seconds, in which the prefix is advertised as valid.
     * format: int64
     *
     * @param prefixValidTime New value for the property.
     */
    public void setPrefixValidTime(java.lang.Long prefixValidTime) {
        this.prefixValidTime = prefixValidTime;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.NDRAPrefixConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("network_prefix",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.networkPrefix, this._getType().getField("network_prefix")));
        structValue.setField("prefix_preferred_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prefixPreferredTime, this._getType().getField("prefix_preferred_time")));
        structValue.setField("prefix_valid_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.prefixValidTime, this._getType().getField("prefix_valid_time")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.NDRAPrefixConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.NDRAPrefixConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NDRAPrefixConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NDRAPrefixConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NDRAPrefixConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NDRAPrefixConfig(structValue);
    }

    /**
     * Builder class for {@link NDRAPrefixConfig}.
     */
    public static final class Builder {
        private java.lang.String networkPrefix;
        private java.lang.Long prefixPreferredTime;
        private java.lang.Long prefixValidTime;

        /**
         * Constructor with parameters for the required properties of
         * {@link NDRAPrefixConfig}.
         */
        public Builder() {
        }

        /**
         * Override the neighbor discovery prefix preferred time and prefix valid time for
         * the subnet on uplink port whose network matches with the network address of CIDR
         * specified in network_prefix. format: ipv6-cidr-block
         *
         * @param networkPrefix New value for the property.
         */
        public Builder setNetworkPrefix(java.lang.String networkPrefix) {
            this.networkPrefix = networkPrefix;
            return this;
        }

        /**
         * The time interval in seconds, in which the prefix is advertised as preferred.
         * format: int64
         *
         * @param prefixPreferredTime New value for the property.
         */
        public Builder setPrefixPreferredTime(java.lang.Long prefixPreferredTime) {
            this.prefixPreferredTime = prefixPreferredTime;
            return this;
        }

        /**
         * The time interval in seconds, in which the prefix is advertised as valid.
         * format: int64
         *
         * @param prefixValidTime New value for the property.
         */
        public Builder setPrefixValidTime(java.lang.Long prefixValidTime) {
            this.prefixValidTime = prefixValidTime;
            return this;
        }

        public NDRAPrefixConfig build() {
            NDRAPrefixConfig result = new NDRAPrefixConfig();
            result.setNetworkPrefix(this.networkPrefix);
            result.setPrefixPreferredTime(this.prefixPreferredTime);
            result.setPrefixValidTime(this.prefixValidTime);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("network_prefix", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("network_prefix",
                                                                                "networkPrefix",
                                                                                "getNetworkPrefix",
                                                                                "setNetworkPrefix");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prefix_preferred_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prefix_preferred_time",
                                                                                "prefixPreferredTime",
                                                                                "getPrefixPreferredTime",
                                                                                "setPrefixPreferredTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("prefix_valid_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("prefix_valid_time",
                                                                                "prefixValidTime",
                                                                                "getPrefixValidTime",
                                                                                "setPrefixValidTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.NDRA_prefix_config",
                                                            fields,
                                                            com.vmware.nsx.model.NDRAPrefixConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

