/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * NSGroupInfo contains information about a particular NSGroup used in a SI Rule.
 * It also contains information about policy path used to create this NSGroup.
 */
public final class NSGroupInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private com.vmware.nsx.model.ResourceReference nsgroup;

    private java.lang.String nsgroupPolicyPath;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NSGroupInfo() {
    }

    protected NSGroupInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.ResourceReference getNsgroup() {
        return this.nsgroup;
    }

    /**
     *
     *
     * @param nsgroup New value for the property.
     */
    public void setNsgroup(com.vmware.nsx.model.ResourceReference nsgroup) {
        this.nsgroup = nsgroup;
    }

    /**
     * Relative Policy path of a particular NSGroup.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNsgroupPolicyPath() {
        return this.nsgroupPolicyPath;
    }

    /**
     * Relative Policy path of a particular NSGroup.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param nsgroupPolicyPath New value for the property.
     */
    public void setNsgroupPolicyPath(java.lang.String nsgroupPolicyPath) {
        this.nsgroupPolicyPath = nsgroupPolicyPath;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.NSGroupInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("nsgroup",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsgroup, this._getType().getField("nsgroup")));
        structValue.setField("nsgroup_policy_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nsgroupPolicyPath, this._getType().getField("nsgroup_policy_path")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.NSGroupInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.NSGroupInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NSGroupInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NSGroupInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NSGroupInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NSGroupInfo(structValue);
    }

    /**
     * Builder class for {@link NSGroupInfo}.
     */
    public static final class Builder {
        private com.vmware.nsx.model.ResourceReference nsgroup;
        private java.lang.String nsgroupPolicyPath;

        /**
         * Constructor with parameters for the required properties of
         * {@link NSGroupInfo}.
         */
        public Builder() {
        }

        /**
         *
         *
         * @param nsgroup New value for the property.
         */
        public Builder setNsgroup(com.vmware.nsx.model.ResourceReference nsgroup) {
            this.nsgroup = nsgroup;
            return this;
        }

        /**
         * Relative Policy path of a particular NSGroup.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param nsgroupPolicyPath New value for the property.
         */
        public Builder setNsgroupPolicyPath(java.lang.String nsgroupPolicyPath) {
            this.nsgroupPolicyPath = nsgroupPolicyPath;
            return this;
        }

        public NSGroupInfo build() {
            NSGroupInfo result = new NSGroupInfo();
            result.setNsgroup(this.nsgroup);
            result.setNsgroupPolicyPath(this.nsgroupPolicyPath);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("nsgroup", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.resourceReference; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsgroup",
                                                                                "nsgroup",
                                                                                "getNsgroup",
                                                                                "setNsgroup");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("nsgroup_policy_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("nsgroup_policy_path",
                                                                                "nsgroupPolicyPath",
                                                                                "getNsgroupPolicyPath",
                                                                                "setNsgroupPolicyPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.NS_group_info",
                                                            fields,
                                                            com.vmware.nsx.model.NSGroupInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

