/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Network error related to container objects.
 */
public final class NetworkError implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String errorCode;

    private java.lang.String errorMessage;

    private java.lang.String spec;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NetworkError() {
    }

    protected NetworkError(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Error code of network related error.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorCode() {
        return this.errorCode;
    }

    /**
     * Error code of network related error.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param errorCode New value for the property.
     */
    public void setErrorCode(java.lang.String errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * Detailed message of network related error.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * Detailed message of network related error.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param errorMessage New value for the property.
     */
    public void setErrorMessage(java.lang.String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * Additional error information in json format.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSpec() {
        return this.spec;
    }

    /**
     * Additional error information in json format.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param spec New value for the property.
     */
    public void setSpec(java.lang.String spec) {
        this.spec = spec;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.networkError;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("error_code",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorCode, this._getType().getField("error_code")));
        structValue.setField("error_message",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorMessage, this._getType().getField("error_message")));
        structValue.setField("spec",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.spec, this._getType().getField("spec")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.networkError;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.networkError.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NetworkError _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NetworkError(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NetworkError _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NetworkError(structValue);
    }

    /**
     * Builder class for {@link NetworkError}.
     */
    public static final class Builder {
        private java.lang.String errorCode;
        private java.lang.String errorMessage;
        private java.lang.String spec;

        /**
         * Constructor with parameters for the required properties of
         * {@link NetworkError}.
         */
        public Builder() {
        }

        /**
         * Error code of network related error.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param errorCode New value for the property.
         */
        public Builder setErrorCode(java.lang.String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        /**
         * Detailed message of network related error.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param errorMessage New value for the property.
         */
        public Builder setErrorMessage(java.lang.String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        /**
         * Additional error information in json format.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param spec New value for the property.
         */
        public Builder setSpec(java.lang.String spec) {
            this.spec = spec;
            return this;
        }

        public NetworkError build() {
            NetworkError result = new NetworkError();
            result.setErrorCode(this.errorCode);
            result.setErrorMessage(this.errorMessage);
            result.setSpec(this.spec);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("error_code", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_code",
                                                                                "errorCode",
                                                                                "getErrorCode",
                                                                                "setErrorCode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_message", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_message",
                                                                                "errorMessage",
                                                                                "getErrorMessage",
                                                                                "setErrorMessage");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("spec", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("spec",
                                                                                "spec",
                                                                                "getSpec",
                                                                                "setSpec");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.network_error",
                                                            fields,
                                                            com.vmware.nsx.model.NetworkError.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

