/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Spec for new Host Transport Node which is added after V2T Host migration has
 * started.
 */
public final class NewHostTransportNodeSpec implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String federationSiteId;

    private java.lang.String hostMigrationUnitId;

    private java.lang.String hostTransportNodeId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public NewHostTransportNodeSpec() {
    }

    protected NewHostTransportNodeSpec(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Id of the site in NSX-T Federation
     *
     * @return The current value of the property.
     */
    public java.lang.String getFederationSiteId() {
        return this.federationSiteId;
    }

    /**
     * Id of the site in NSX-T Federation
     *
     * @param federationSiteId New value for the property.
     */
    public void setFederationSiteId(java.lang.String federationSiteId) {
        this.federationSiteId = federationSiteId;
    }

    /**
     * Migration unit id of the newly added Host Transport Node. This can be specified
     * when the migration mode chosen also does HOST migration. For migration modes
     * that do not perform HOST migration, this value should not be specified. Instead
     * host_transport_node_id value should be specified.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostMigrationUnitId() {
        return this.hostMigrationUnitId;
    }

    /**
     * Migration unit id of the newly added Host Transport Node. This can be specified
     * when the migration mode chosen also does HOST migration. For migration modes
     * that do not perform HOST migration, this value should not be specified. Instead
     * host_transport_node_id value should be specified.
     *
     * @param hostMigrationUnitId New value for the property.
     */
    public void setHostMigrationUnitId(java.lang.String hostMigrationUnitId) {
        this.hostMigrationUnitId = hostMigrationUnitId;
    }

    /**
     * Id of the newly added Host Transport Node.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHostTransportNodeId() {
        return this.hostTransportNodeId;
    }

    /**
     * Id of the newly added Host Transport Node.
     *
     * @param hostTransportNodeId New value for the property.
     */
    public void setHostTransportNodeId(java.lang.String hostTransportNodeId) {
        this.hostTransportNodeId = hostTransportNodeId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.newHostTransportNodeSpec;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("federation_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.federationSiteId, this._getType().getField("federation_site_id")));
        structValue.setField("host_migration_unit_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostMigrationUnitId, this._getType().getField("host_migration_unit_id")));
        structValue.setField("host_transport_node_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hostTransportNodeId, this._getType().getField("host_transport_node_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.newHostTransportNodeSpec;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.newHostTransportNodeSpec.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static NewHostTransportNodeSpec _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new NewHostTransportNodeSpec(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static NewHostTransportNodeSpec _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new NewHostTransportNodeSpec(structValue);
    }

    /**
     * Builder class for {@link NewHostTransportNodeSpec}.
     */
    public static final class Builder {
        private java.lang.String federationSiteId;
        private java.lang.String hostMigrationUnitId;
        private java.lang.String hostTransportNodeId;

        /**
         * Constructor with parameters for the required properties of
         * {@link NewHostTransportNodeSpec}.
         */
        public Builder() {
        }

        /**
         * Id of the site in NSX-T Federation
         *
         * @param federationSiteId New value for the property.
         */
        public Builder setFederationSiteId(java.lang.String federationSiteId) {
            this.federationSiteId = federationSiteId;
            return this;
        }

        /**
         * Migration unit id of the newly added Host Transport Node. This can be specified
         * when the migration mode chosen also does HOST migration. For migration modes
         * that do not perform HOST migration, this value should not be specified. Instead
         * host_transport_node_id value should be specified.
         *
         * @param hostMigrationUnitId New value for the property.
         */
        public Builder setHostMigrationUnitId(java.lang.String hostMigrationUnitId) {
            this.hostMigrationUnitId = hostMigrationUnitId;
            return this;
        }

        /**
         * Id of the newly added Host Transport Node.
         *
         * @param hostTransportNodeId New value for the property.
         */
        public Builder setHostTransportNodeId(java.lang.String hostTransportNodeId) {
            this.hostTransportNodeId = hostTransportNodeId;
            return this;
        }

        public NewHostTransportNodeSpec build() {
            NewHostTransportNodeSpec result = new NewHostTransportNodeSpec();
            result.setFederationSiteId(this.federationSiteId);
            result.setHostMigrationUnitId(this.hostMigrationUnitId);
            result.setHostTransportNodeId(this.hostTransportNodeId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("federation_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("federation_site_id",
                                                                                "federationSiteId",
                                                                                "getFederationSiteId",
                                                                                "setFederationSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_migration_unit_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_migration_unit_id",
                                                                                "hostMigrationUnitId",
                                                                                "getHostMigrationUnitId",
                                                                                "setHostMigrationUnitId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("host_transport_node_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("host_transport_node_id",
                                                                                "hostTransportNodeId",
                                                                                "getHostTransportNodeId",
                                                                                "setHostTransportNodeId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.new_host_transport_node_spec",
                                                            fields,
                                                            com.vmware.nsx.model.NewHostTransportNodeSpec.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

