/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Details about an error encountered while checking OIDC End Point health status.
 */
public final class OidcHealthCheckError implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ERROR_TYPE_JWKS_URI_FETCH_FAIL = "JWKS_URI_FETCH_FAIL";

    public static final java.lang.String ERROR_TYPE_TOKEN_RETRIEVE_FAIL = "TOKEN_RETRIEVE_FAIL";

    public static final java.lang.String ERROR_TYPE_SCIM_SEARCH_FAIL = "SCIM_SEARCH_FAIL";

    private java.lang.String errorDetail;

    private java.lang.String errorType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public OidcHealthCheckError() {
    }

    protected OidcHealthCheckError(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Additional details about the cause of the error, if any could be determined.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorDetail() {
        return this.errorDetail;
    }

    /**
     * Additional details about the cause of the error, if any could be determined.
     *
     * @param errorDetail New value for the property.
     */
    public void setErrorDetail(java.lang.String errorDetail) {
        this.errorDetail = errorDetail;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.OidcHealthCheckError#ERROR_TYPE_JWKS_URI_FETCH_FAIL}</li>
     * <li> {@link
     * com.vmware.nsx.model.OidcHealthCheckError#ERROR_TYPE_TOKEN_RETRIEVE_FAIL}</li>
     * <li> {@link
     * com.vmware.nsx.model.OidcHealthCheckError#ERROR_TYPE_SCIM_SEARCH_FAIL}</li>
     * </ul> A problem discovered when checking the health of the OIDC End Point.
     * DISCOVERY_URI_FETCH_FAIL: The OIDC discovery endpoint could not be retrieved.
     * TOKEN_RETRIEVE_FAIL: NSX was unable to retrieve a token from the OIDC End Point.
     * Authentication to NSX using OIDC will not be possible. SCIM_SEARCH_FAIL: NSX was
     * unable to perform a user/group search of the SCIM (System for Cross-domain
     * Identity Management) endpoint. User and group searches will not function
     * correctly. GENERAL_ERROR: Some general error occurred while verifying the OIDC
     * endpoint.
     *
     * @return The current value of the property.
     */
    public java.lang.String getErrorType() {
        return this.errorType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.OidcHealthCheckError#ERROR_TYPE_JWKS_URI_FETCH_FAIL}</li>
     * <li> {@link
     * com.vmware.nsx.model.OidcHealthCheckError#ERROR_TYPE_TOKEN_RETRIEVE_FAIL}</li>
     * <li> {@link
     * com.vmware.nsx.model.OidcHealthCheckError#ERROR_TYPE_SCIM_SEARCH_FAIL}</li>
     * </ul> A problem discovered when checking the health of the OIDC End Point.
     * DISCOVERY_URI_FETCH_FAIL: The OIDC discovery endpoint could not be retrieved.
     * TOKEN_RETRIEVE_FAIL: NSX was unable to retrieve a token from the OIDC End Point.
     * Authentication to NSX using OIDC will not be possible. SCIM_SEARCH_FAIL: NSX was
     * unable to perform a user/group search of the SCIM (System for Cross-domain
     * Identity Management) endpoint. User and group searches will not function
     * correctly. GENERAL_ERROR: Some general error occurred while verifying the OIDC
     * endpoint.
     *
     * @param errorType New value for the property.
     */
    public void setErrorType(java.lang.String errorType) {
        this.errorType = errorType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.oidcHealthCheckError;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("error_detail",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorDetail, this._getType().getField("error_detail")));
        structValue.setField("error_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorType, this._getType().getField("error_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.oidcHealthCheckError;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.oidcHealthCheckError.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static OidcHealthCheckError _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new OidcHealthCheckError(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static OidcHealthCheckError _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new OidcHealthCheckError(structValue);
    }

    /**
     * Builder class for {@link OidcHealthCheckError}.
     */
    public static final class Builder {
        private java.lang.String errorDetail;
        private java.lang.String errorType;

        /**
         * Constructor with parameters for the required properties of
         * {@link OidcHealthCheckError}.
         */
        public Builder() {
        }

        /**
         * Additional details about the cause of the error, if any could be determined.
         *
         * @param errorDetail New value for the property.
         */
        public Builder setErrorDetail(java.lang.String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.OidcHealthCheckError#ERROR_TYPE_JWKS_URI_FETCH_FAIL}</li>
         * <li> {@link
         * com.vmware.nsx.model.OidcHealthCheckError#ERROR_TYPE_TOKEN_RETRIEVE_FAIL}</li>
         * <li> {@link
         * com.vmware.nsx.model.OidcHealthCheckError#ERROR_TYPE_SCIM_SEARCH_FAIL}</li>
         * </ul> A problem discovered when checking the health of the OIDC End Point.
         * DISCOVERY_URI_FETCH_FAIL: The OIDC discovery endpoint could not be retrieved.
         * TOKEN_RETRIEVE_FAIL: NSX was unable to retrieve a token from the OIDC End Point.
         * Authentication to NSX using OIDC will not be possible. SCIM_SEARCH_FAIL: NSX was
         * unable to perform a user/group search of the SCIM (System for Cross-domain
         * Identity Management) endpoint. User and group searches will not function
         * correctly. GENERAL_ERROR: Some general error occurred while verifying the OIDC
         * endpoint.
         *
         * @param errorType New value for the property.
         */
        public Builder setErrorType(java.lang.String errorType) {
            this.errorType = errorType;
            return this;
        }

        public OidcHealthCheckError build() {
            OidcHealthCheckError result = new OidcHealthCheckError();
            result.setErrorDetail(this.errorDetail);
            result.setErrorType(this.errorType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("error_detail", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_detail",
                                                                                "errorDetail",
                                                                                "getErrorDetail",
                                                                                "setErrorDetail");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_type",
                                                                                "errorType",
                                                                                "getErrorType",
                                                                                "setErrorType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.oidc_health_check_error",
                                                            fields,
                                                            com.vmware.nsx.model.OidcHealthCheckError.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

