/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This type is used to create packet request on give node. Need to specify related
 * parameters according to the capture point.
 */
public final class PacketCaptureRequest implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CAPMODE_STANDALONE = "STANDALONE";

    public static final java.lang.String CAPMODE_STREAM = "STREAM";

    public static final java.lang.String CAPPOINT_VNIC = "VNIC";

    public static final java.lang.String CAPPOINT_VMKNIC = "VMKNIC";

    public static final java.lang.String CAPPOINT_VMNIC = "VMNIC";

    public static final java.lang.String CAPPOINT_VDRPORT = "VDRPORT";

    public static final java.lang.String CAPPOINT_DVFILTER = "DVFILTER";

    public static final java.lang.String CAPPOINT_LOGICALPORT = "LOGICALPORT";

    public static final java.lang.String CAPPOINT_FCPORT = "FCPORT";

    public static final java.lang.String CAPPOINT_VIF = "VIF";

    public static final java.lang.String CAPPOINT_PNIC = "PNIC";

    public static final java.lang.String CAPSOURCE_CLI = "CLI";

    public static final java.lang.String CAPSOURCE_UI = "UI";

    public static final java.lang.String DIRECTION_INPUT = "INPUT";

    public static final java.lang.String DIRECTION_OUTPUT = "OUTPUT";

    public static final java.lang.String DIRECTION_DUAL = "DUAL";

    public static final java.lang.String FILTERTYPE_PRE = "PRE";

    public static final java.lang.String FILTERTYPE_POST = "POST";

    private java.lang.Long capamount;

    private java.lang.Long capcore;

    private java.lang.Long capduration;

    private java.lang.Long capfilesize;

    private java.lang.String capmode;

    private java.lang.String cappoint;

    private java.lang.Long caprate;

    private java.lang.Long capsnaplen;

    private java.lang.String capsource;

    private java.lang.String capvalue;

    private java.lang.String direction;

    private java.lang.String filtertype;

    private java.lang.String node;

    private java.lang.String nodeIp;

    private com.vmware.nsx.model.PacketCaptureOptionList options;

    private java.lang.String streamaddress;

    private java.lang.Long streamport;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PacketCaptureRequest() {
    }

    protected PacketCaptureRequest(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Define the packet capture amount size. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCapamount() {
        return this.capamount;
    }

    /**
     * Define the packet capture amount size. format: int32
     *
     * @param capamount New value for the property.
     */
    public void setCapamount(java.lang.Long capamount) {
        this.capamount = capamount;
    }

    /**
     * The CPU core id on Edge node. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCapcore() {
        return this.capcore;
    }

    /**
     * The CPU core id on Edge node. format: int32
     *
     * @param capcore New value for the property.
     */
    public void setCapcore(java.lang.Long capcore) {
        this.capcore = capcore;
    }

    /**
     * Define the packet capture duration time. After the capture duration time, the
     * capture process will stop working. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCapduration() {
        return this.capduration;
    }

    /**
     * Define the packet capture duration time. After the capture duration time, the
     * capture process will stop working. format: int32
     *
     * @param capduration New value for the property.
     */
    public void setCapduration(java.lang.Long capduration) {
        this.capduration = capduration;
    }

    /**
     * Define the packet capture file size limit. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCapfilesize() {
        return this.capfilesize;
    }

    /**
     * Define the packet capture file size limit. format: int32
     *
     * @param capfilesize New value for the property.
     */
    public void setCapfilesize(java.lang.Long capfilesize) {
        this.capfilesize = capfilesize;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPMODE_STANDALONE}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPMODE_STREAM}</li> </ul> Define the
     * capture streaming mode. The STREAM mode will send the data to given stream
     * address and port. And the STANDALONE mode will save the capture file in local
     * folder.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCapmode() {
        return this.capmode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPMODE_STANDALONE}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPMODE_STREAM}</li> </ul> Define the
     * capture streaming mode. The STREAM mode will send the data to given stream
     * address and port. And the STANDALONE mode will save the capture file in local
     * folder.
     *
     * @param capmode New value for the property.
     */
    public void setCapmode(java.lang.String capmode) {
        this.capmode = capmode;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VNIC}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VMKNIC}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VMNIC}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VDRPORT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_DVFILTER}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_LOGICALPORT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_FCPORT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VIF}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_PNIC}</li> </ul> Define the
     * point to capture data.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCappoint() {
        return this.cappoint;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VNIC}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VMKNIC}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VMNIC}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VDRPORT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_DVFILTER}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_LOGICALPORT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_FCPORT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VIF}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_PNIC}</li> </ul> Define the
     * point to capture data.
     *
     * @param cappoint New value for the property.
     */
    public void setCappoint(java.lang.String cappoint) {
        this.cappoint = cappoint;
    }

    /**
     * Define the rate of packet capture process. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCaprate() {
        return this.caprate;
    }

    /**
     * Define the rate of packet capture process. format: int32
     *
     * @param caprate New value for the property.
     */
    public void setCaprate(java.lang.Long caprate) {
        this.caprate = caprate;
    }

    /**
     * Limit the number of bytes captured from each packet. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCapsnaplen() {
        return this.capsnaplen;
    }

    /**
     * Limit the number of bytes captured from each packet. format: int32
     *
     * @param capsnaplen New value for the property.
     */
    public void setCapsnaplen(java.lang.Long capsnaplen) {
        this.capsnaplen = capsnaplen;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPSOURCE_CLI}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPSOURCE_UI}</li> </ul> This type is
     * used to differenite the incoming request from CLI/UI.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCapsource() {
        return this.capsource;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPSOURCE_CLI}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#CAPSOURCE_UI}</li> </ul> This type is
     * used to differenite the incoming request from CLI/UI.
     *
     * @param capsource New value for the property.
     */
    public void setCapsource(java.lang.String capsource) {
        this.capsource = capsource;
    }

    /**
     * Define the capture value of given capture point.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCapvalue() {
        return this.capvalue;
    }

    /**
     * Define the capture value of given capture point.
     *
     * @param capvalue New value for the property.
     */
    public void setCapvalue(java.lang.String capvalue) {
        this.capvalue = capvalue;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#DIRECTION_INPUT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#DIRECTION_OUTPUT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#DIRECTION_DUAL}</li> </ul> Define the
     * capture direction. Support three types INPUT/OUTPUT/DUAL.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDirection() {
        return this.direction;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#DIRECTION_INPUT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#DIRECTION_OUTPUT}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#DIRECTION_DUAL}</li> </ul> Define the
     * capture direction. Support three types INPUT/OUTPUT/DUAL.
     *
     * @param direction New value for the property.
     */
    public void setDirection(java.lang.String direction) {
        this.direction = direction;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#FILTERTYPE_PRE}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#FILTERTYPE_POST}</li> </ul> Define the
     * capture filter type. Support PRE/POST mode.
     *
     * @return The current value of the property.
     */
    public java.lang.String getFiltertype() {
        return this.filtertype;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#FILTERTYPE_PRE}</li> <li> {@link
     * com.vmware.nsx.model.PacketCaptureRequest#FILTERTYPE_POST}</li> </ul> Define the
     * capture filter type. Support PRE/POST mode.
     *
     * @param filtertype New value for the property.
     */
    public void setFiltertype(java.lang.String filtertype) {
        this.filtertype = filtertype;
    }

    /**
     * Define the transport node to capture data.
     *
     * @return The current value of the property.
     */
    public java.lang.String getNode() {
        return this.node;
    }

    /**
     * Define the transport node to capture data.
     *
     * @param node New value for the property.
     */
    public void setNode(java.lang.String node) {
        this.node = node;
    }

    /**
     * Define the transport node to capture data. format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getNodeIp() {
        return this.nodeIp;
    }

    /**
     * Define the transport node to capture data. format: ip
     *
     * @param nodeIp New value for the property.
     */
    public void setNodeIp(java.lang.String nodeIp) {
        this.nodeIp = nodeIp;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.PacketCaptureOptionList getOptions() {
        return this.options;
    }

    /**
     *
     *
     * @param options New value for the property.
     */
    public void setOptions(com.vmware.nsx.model.PacketCaptureOptionList options) {
        this.options = options;
    }

    /**
     * Set the stream address to receive the capture packet.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStreamaddress() {
        return this.streamaddress;
    }

    /**
     * Set the stream address to receive the capture packet.
     *
     * @param streamaddress New value for the property.
     */
    public void setStreamaddress(java.lang.String streamaddress) {
        this.streamaddress = streamaddress;
    }

    /**
     * Set the stream port to receive the capture packet. The STREAM mode is based on
     * GRE-in-UDP Encapsulation(RFC8086). Packets are sent to UDP port 4754. format:
     * int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getStreamport() {
        return this.streamport;
    }

    /**
     * Set the stream port to receive the capture packet. The STREAM mode is based on
     * GRE-in-UDP Encapsulation(RFC8086). Packets are sent to UDP port 4754. format:
     * int32
     *
     * @param streamport New value for the property.
     */
    public void setStreamport(java.lang.Long streamport) {
        this.streamport = streamport;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.packetCaptureRequest;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("capamount",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capamount, this._getType().getField("capamount")));
        structValue.setField("capcore",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capcore, this._getType().getField("capcore")));
        structValue.setField("capduration",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capduration, this._getType().getField("capduration")));
        structValue.setField("capfilesize",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capfilesize, this._getType().getField("capfilesize")));
        structValue.setField("capmode",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capmode, this._getType().getField("capmode")));
        structValue.setField("cappoint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cappoint, this._getType().getField("cappoint")));
        structValue.setField("caprate",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.caprate, this._getType().getField("caprate")));
        structValue.setField("capsnaplen",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capsnaplen, this._getType().getField("capsnaplen")));
        structValue.setField("capsource",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capsource, this._getType().getField("capsource")));
        structValue.setField("capvalue",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.capvalue, this._getType().getField("capvalue")));
        structValue.setField("direction",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.direction, this._getType().getField("direction")));
        structValue.setField("filtertype",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.filtertype, this._getType().getField("filtertype")));
        structValue.setField("node",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.node, this._getType().getField("node")));
        structValue.setField("node_ip",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.nodeIp, this._getType().getField("node_ip")));
        structValue.setField("options",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.options, this._getType().getField("options")));
        structValue.setField("streamaddress",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.streamaddress, this._getType().getField("streamaddress")));
        structValue.setField("streamport",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.streamport, this._getType().getField("streamport")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.packetCaptureRequest;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.packetCaptureRequest.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PacketCaptureRequest _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PacketCaptureRequest(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PacketCaptureRequest _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PacketCaptureRequest(structValue);
    }

    /**
     * Builder class for {@link PacketCaptureRequest}.
     */
    public static final class Builder {
        private java.lang.Long capamount;
        private java.lang.Long capcore;
        private java.lang.Long capduration;
        private java.lang.Long capfilesize;
        private java.lang.String capmode;
        private java.lang.String cappoint;
        private java.lang.Long caprate;
        private java.lang.Long capsnaplen;
        private java.lang.String capsource;
        private java.lang.String capvalue;
        private java.lang.String direction;
        private java.lang.String filtertype;
        private java.lang.String node;
        private java.lang.String nodeIp;
        private com.vmware.nsx.model.PacketCaptureOptionList options;
        private java.lang.String streamaddress;
        private java.lang.Long streamport;

        /**
         * Constructor with parameters for the required properties of
         * {@link PacketCaptureRequest}.
         */
        public Builder() {
        }

        /**
         * Define the packet capture amount size. format: int32
         *
         * @param capamount New value for the property.
         */
        public Builder setCapamount(java.lang.Long capamount) {
            this.capamount = capamount;
            return this;
        }

        /**
         * The CPU core id on Edge node. format: int32
         *
         * @param capcore New value for the property.
         */
        public Builder setCapcore(java.lang.Long capcore) {
            this.capcore = capcore;
            return this;
        }

        /**
         * Define the packet capture duration time. After the capture duration time, the
         * capture process will stop working. format: int32
         *
         * @param capduration New value for the property.
         */
        public Builder setCapduration(java.lang.Long capduration) {
            this.capduration = capduration;
            return this;
        }

        /**
         * Define the packet capture file size limit. format: int32
         *
         * @param capfilesize New value for the property.
         */
        public Builder setCapfilesize(java.lang.Long capfilesize) {
            this.capfilesize = capfilesize;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPMODE_STANDALONE}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPMODE_STREAM}</li> </ul> Define the
         * capture streaming mode. The STREAM mode will send the data to given stream
         * address and port. And the STANDALONE mode will save the capture file in local
         * folder.
         *
         * @param capmode New value for the property.
         */
        public Builder setCapmode(java.lang.String capmode) {
            this.capmode = capmode;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VNIC}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VMKNIC}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VMNIC}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VDRPORT}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_DVFILTER}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_LOGICALPORT}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_FCPORT}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_VIF}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPPOINT_PNIC}</li> </ul> Define the
         * point to capture data.
         *
         * @param cappoint New value for the property.
         */
        public Builder setCappoint(java.lang.String cappoint) {
            this.cappoint = cappoint;
            return this;
        }

        /**
         * Define the rate of packet capture process. format: int32
         *
         * @param caprate New value for the property.
         */
        public Builder setCaprate(java.lang.Long caprate) {
            this.caprate = caprate;
            return this;
        }

        /**
         * Limit the number of bytes captured from each packet. format: int32
         *
         * @param capsnaplen New value for the property.
         */
        public Builder setCapsnaplen(java.lang.Long capsnaplen) {
            this.capsnaplen = capsnaplen;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPSOURCE_CLI}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#CAPSOURCE_UI}</li> </ul> This type is
         * used to differenite the incoming request from CLI/UI.
         *
         * @param capsource New value for the property.
         */
        public Builder setCapsource(java.lang.String capsource) {
            this.capsource = capsource;
            return this;
        }

        /**
         * Define the capture value of given capture point.
         *
         * @param capvalue New value for the property.
         */
        public Builder setCapvalue(java.lang.String capvalue) {
            this.capvalue = capvalue;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#DIRECTION_INPUT}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#DIRECTION_OUTPUT}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#DIRECTION_DUAL}</li> </ul> Define the
         * capture direction. Support three types INPUT/OUTPUT/DUAL.
         *
         * @param direction New value for the property.
         */
        public Builder setDirection(java.lang.String direction) {
            this.direction = direction;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#FILTERTYPE_PRE}</li> <li> {@link
         * com.vmware.nsx.model.PacketCaptureRequest#FILTERTYPE_POST}</li> </ul> Define the
         * capture filter type. Support PRE/POST mode.
         *
         * @param filtertype New value for the property.
         */
        public Builder setFiltertype(java.lang.String filtertype) {
            this.filtertype = filtertype;
            return this;
        }

        /**
         * Define the transport node to capture data.
         *
         * @param node New value for the property.
         */
        public Builder setNode(java.lang.String node) {
            this.node = node;
            return this;
        }

        /**
         * Define the transport node to capture data. format: ip
         *
         * @param nodeIp New value for the property.
         */
        public Builder setNodeIp(java.lang.String nodeIp) {
            this.nodeIp = nodeIp;
            return this;
        }

        /**
         *
         *
         * @param options New value for the property.
         */
        public Builder setOptions(com.vmware.nsx.model.PacketCaptureOptionList options) {
            this.options = options;
            return this;
        }

        /**
         * Set the stream address to receive the capture packet.
         *
         * @param streamaddress New value for the property.
         */
        public Builder setStreamaddress(java.lang.String streamaddress) {
            this.streamaddress = streamaddress;
            return this;
        }

        /**
         * Set the stream port to receive the capture packet. The STREAM mode is based on
         * GRE-in-UDP Encapsulation(RFC8086). Packets are sent to UDP port 4754. format:
         * int32
         *
         * @param streamport New value for the property.
         */
        public Builder setStreamport(java.lang.Long streamport) {
            this.streamport = streamport;
            return this;
        }

        public PacketCaptureRequest build() {
            PacketCaptureRequest result = new PacketCaptureRequest();
            result.setCapamount(this.capamount);
            result.setCapcore(this.capcore);
            result.setCapduration(this.capduration);
            result.setCapfilesize(this.capfilesize);
            result.setCapmode(this.capmode);
            result.setCappoint(this.cappoint);
            result.setCaprate(this.caprate);
            result.setCapsnaplen(this.capsnaplen);
            result.setCapsource(this.capsource);
            result.setCapvalue(this.capvalue);
            result.setDirection(this.direction);
            result.setFiltertype(this.filtertype);
            result.setNode(this.node);
            result.setNodeIp(this.nodeIp);
            result.setOptions(this.options);
            result.setStreamaddress(this.streamaddress);
            result.setStreamport(this.streamport);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("capamount", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capamount",
                                                                                "capamount",
                                                                                "getCapamount",
                                                                                "setCapamount");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("capcore", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capcore",
                                                                                "capcore",
                                                                                "getCapcore",
                                                                                "setCapcore");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("capduration", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capduration",
                                                                                "capduration",
                                                                                "getCapduration",
                                                                                "setCapduration");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("capfilesize", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capfilesize",
                                                                                "capfilesize",
                                                                                "getCapfilesize",
                                                                                "setCapfilesize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("capmode", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capmode",
                                                                                "capmode",
                                                                                "getCapmode",
                                                                                "setCapmode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cappoint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cappoint",
                                                                                "cappoint",
                                                                                "getCappoint",
                                                                                "setCappoint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("caprate", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("caprate",
                                                                                "caprate",
                                                                                "getCaprate",
                                                                                "setCaprate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("capsnaplen", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capsnaplen",
                                                                                "capsnaplen",
                                                                                "getCapsnaplen",
                                                                                "setCapsnaplen");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("capsource", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capsource",
                                                                                "capsource",
                                                                                "getCapsource",
                                                                                "setCapsource");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("capvalue", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("capvalue",
                                                                                "capvalue",
                                                                                "getCapvalue",
                                                                                "setCapvalue");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("direction", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("direction",
                                                                                "direction",
                                                                                "getDirection",
                                                                                "setDirection");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("filtertype", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("filtertype",
                                                                                "filtertype",
                                                                                "getFiltertype",
                                                                                "setFiltertype");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node",
                                                                                "node",
                                                                                "getNode",
                                                                                "setNode");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("node_ip", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("node_ip",
                                                                                "nodeIp",
                                                                                "getNodeIp",
                                                                                "setNodeIp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("options", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.packetCaptureOptionList; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("options",
                                                                                "options",
                                                                                "getOptions",
                                                                                "setOptions");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("streamaddress", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("streamaddress",
                                                                                "streamaddress",
                                                                                "getStreamaddress",
                                                                                "setStreamaddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("streamport", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("streamport",
                                                                                "streamport",
                                                                                "getStreamport",
                                                                                "setStreamport");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.packet_capture_request",
                                                            fields,
                                                            com.vmware.nsx.model.PacketCaptureRequest.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

