/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * The setting is used to add, update or remove pool members from pool. For static
 * pool members, admin_state, display_name and weight can be updated. For dynamic
 * pool members, only admin_state can be updated.
 */
public final class PoolMemberSetting implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ADMIN_STATE_ENABLED = "ENABLED";

    public static final java.lang.String ADMIN_STATE_DISABLED = "DISABLED";

    public static final java.lang.String ADMIN_STATE_GRACEFUL_DISABLED = "GRACEFUL_DISABLED";

    private java.lang.String adminState;

    private java.lang.String displayName;

    private java.lang.String ipAddress;

    private java.lang.String port;

    private java.lang.Long weight;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PoolMemberSetting() {
    }

    protected PoolMemberSetting(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PoolMemberSetting#ADMIN_STATE_ENABLED}</li> <li> {@link
     * com.vmware.nsx.model.PoolMemberSetting#ADMIN_STATE_DISABLED}</li> <li> {@link
     * com.vmware.nsx.model.PoolMemberSetting#ADMIN_STATE_GRACEFUL_DISABLED}</li> </ul>
     * Member admin state
     *
     * @return The current value of the property.
     */
    public java.lang.String getAdminState() {
        return this.adminState;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.PoolMemberSetting#ADMIN_STATE_ENABLED}</li> <li> {@link
     * com.vmware.nsx.model.PoolMemberSetting#ADMIN_STATE_DISABLED}</li> <li> {@link
     * com.vmware.nsx.model.PoolMemberSetting#ADMIN_STATE_GRACEFUL_DISABLED}</li> </ul>
     * Member admin state
     *
     * @param adminState New value for the property.
     */
    public void setAdminState(java.lang.String adminState) {
        this.adminState = adminState;
    }

    /**
     * Only applicable to static pool members. If supplied for a pool defined by a
     * grouping object, update API would fail.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDisplayName() {
        return this.displayName;
    }

    /**
     * Only applicable to static pool members. If supplied for a pool defined by a
     * grouping object, update API would fail.
     *
     * @param displayName New value for the property.
     */
    public void setDisplayName(java.lang.String displayName) {
        this.displayName = displayName;
    }

    /**
     * Pool member IP address format: ip
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * Pool member IP address format: ip
     *
     * @param ipAddress New value for the property.
     */
    public void setIpAddress(java.lang.String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * Pool member port number format: port-or-range
     *
     * @return The current value of the property.
     */
    public java.lang.String getPort() {
        return this.port;
    }

    /**
     * Pool member port number format: port-or-range
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.String port) {
        this.port = port;
    }

    /**
     * Only applicable to static pool members. If supplied for a pool defined by a
     * grouping object, update API would fail. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getWeight() {
        return this.weight;
    }

    /**
     * Only applicable to static pool members. If supplied for a pool defined by a
     * grouping object, update API would fail. format: int64
     *
     * @param weight New value for the property.
     */
    public void setWeight(java.lang.Long weight) {
        this.weight = weight;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.poolMemberSetting;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("admin_state",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.adminState, this._getType().getField("admin_state")));
        structValue.setField("display_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.displayName, this._getType().getField("display_name")));
        structValue.setField("ip_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipAddress, this._getType().getField("ip_address")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
        structValue.setField("weight",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.weight, this._getType().getField("weight")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.poolMemberSetting;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.poolMemberSetting.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PoolMemberSetting _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PoolMemberSetting(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PoolMemberSetting _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PoolMemberSetting(structValue);
    }

    /**
     * Builder class for {@link PoolMemberSetting}.
     */
    public static final class Builder {
        private java.lang.String adminState;
        private java.lang.String displayName;
        private java.lang.String ipAddress;
        private java.lang.String port;
        private java.lang.Long weight;

        /**
         * Constructor with parameters for the required properties of
         * {@link PoolMemberSetting}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.PoolMemberSetting#ADMIN_STATE_ENABLED}</li> <li> {@link
         * com.vmware.nsx.model.PoolMemberSetting#ADMIN_STATE_DISABLED}</li> <li> {@link
         * com.vmware.nsx.model.PoolMemberSetting#ADMIN_STATE_GRACEFUL_DISABLED}</li> </ul>
         * Member admin state
         *
         * @param adminState New value for the property.
         */
        public Builder setAdminState(java.lang.String adminState) {
            this.adminState = adminState;
            return this;
        }

        /**
         * Only applicable to static pool members. If supplied for a pool defined by a
         * grouping object, update API would fail.
         *
         * @param displayName New value for the property.
         */
        public Builder setDisplayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Pool member IP address format: ip
         *
         * @param ipAddress New value for the property.
         */
        public Builder setIpAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Pool member port number format: port-or-range
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.String port) {
            this.port = port;
            return this;
        }

        /**
         * Only applicable to static pool members. If supplied for a pool defined by a
         * grouping object, update API would fail. format: int64
         *
         * @param weight New value for the property.
         */
        public Builder setWeight(java.lang.Long weight) {
            this.weight = weight;
            return this;
        }

        public PoolMemberSetting build() {
            PoolMemberSetting result = new PoolMemberSetting();
            result.setAdminState(this.adminState);
            result.setDisplayName(this.displayName);
            result.setIpAddress(this.ipAddress);
            result.setPort(this.port);
            result.setWeight(this.weight);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("admin_state", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("admin_state",
                                                                                "adminState",
                                                                                "getAdminState",
                                                                                "setAdminState");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("display_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("display_name",
                                                                                "displayName",
                                                                                "getDisplayName",
                                                                                "setDisplayName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_address",
                                                                                "ipAddress",
                                                                                "getIpAddress",
                                                                                "setIpAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("weight", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("weight",
                                                                                "weight",
                                                                                "getWeight",
                                                                                "setWeight");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.pool_member_setting",
                                                            fields,
                                                            com.vmware.nsx.model.PoolMemberSetting.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

