/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Migration spec for a VM group that will be used in post VM group migration step.
 */
public final class PostVmGroupMigrationSpec implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Boolean allowOverride;

    private java.util.List<java.lang.String> failedVmInstanceIds;

    private java.lang.String federationSiteId;

    private java.lang.String groupId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public PostVmGroupMigrationSpec() {
    }

    protected PostVmGroupMigrationSpec(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Flag to indicate whether to re-run the post migrate steps for the VM group if
     * they are already run before.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getAllowOverride() {
        return this.allowOverride;
    }

    /**
     * Flag to indicate whether to re-run the post migrate steps for the VM group if
     * they are already run before.
     *
     * @param allowOverride New value for the property.
     */
    public void setAllowOverride(java.lang.Boolean allowOverride) {
        this.allowOverride = allowOverride;
    }

    /**
     * List of instance uuids of VMs that failed to migrate.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getFailedVmInstanceIds() {
        return this.failedVmInstanceIds;
    }

    /**
     * List of instance uuids of VMs that failed to migrate.
     *
     * @param failedVmInstanceIds New value for the property.
     */
    public void setFailedVmInstanceIds(java.util.List<java.lang.String> failedVmInstanceIds) {
        this.failedVmInstanceIds = failedVmInstanceIds;
    }

    /**
     * Id of the site in NSX-T Federation
     *
     * @return The current value of the property.
     */
    public java.lang.String getFederationSiteId() {
        return this.federationSiteId;
    }

    /**
     * Id of the site in NSX-T Federation
     *
     * @param federationSiteId New value for the property.
     */
    public void setFederationSiteId(java.lang.String federationSiteId) {
        this.federationSiteId = federationSiteId;
    }

    /**
     * User defined VM group id that must be unique among all VM groups ids and also
     * should match the group id used in the pre VM group migrate API.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGroupId() {
        return this.groupId;
    }

    /**
     * User defined VM group id that must be unique among all VM groups ids and also
     * should match the group id used in the pre VM group migrate API.
     *
     * @param groupId New value for the property.
     */
    public void setGroupId(java.lang.String groupId) {
        this.groupId = groupId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.postVmGroupMigrationSpec;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("allow_override",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.allowOverride, this._getType().getField("allow_override")));
        structValue.setField("failed_vm_instance_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.failedVmInstanceIds, this._getType().getField("failed_vm_instance_ids")));
        structValue.setField("federation_site_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.federationSiteId, this._getType().getField("federation_site_id")));
        structValue.setField("group_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupId, this._getType().getField("group_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.postVmGroupMigrationSpec;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.postVmGroupMigrationSpec.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static PostVmGroupMigrationSpec _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new PostVmGroupMigrationSpec(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static PostVmGroupMigrationSpec _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new PostVmGroupMigrationSpec(structValue);
    }

    /**
     * Builder class for {@link PostVmGroupMigrationSpec}.
     */
    public static final class Builder {
        private java.lang.Boolean allowOverride;
        private java.util.List<java.lang.String> failedVmInstanceIds;
        private java.lang.String federationSiteId;
        private java.lang.String groupId;

        /**
         * Constructor with parameters for the required properties of
         * {@link PostVmGroupMigrationSpec}.
         */
        public Builder() {
        }

        /**
         * Flag to indicate whether to re-run the post migrate steps for the VM group if
         * they are already run before.
         *
         * @param allowOverride New value for the property.
         */
        public Builder setAllowOverride(java.lang.Boolean allowOverride) {
            this.allowOverride = allowOverride;
            return this;
        }

        /**
         * List of instance uuids of VMs that failed to migrate.
         *
         * @param failedVmInstanceIds New value for the property.
         */
        public Builder setFailedVmInstanceIds(java.util.List<java.lang.String> failedVmInstanceIds) {
            this.failedVmInstanceIds = failedVmInstanceIds;
            return this;
        }

        /**
         * Id of the site in NSX-T Federation
         *
         * @param federationSiteId New value for the property.
         */
        public Builder setFederationSiteId(java.lang.String federationSiteId) {
            this.federationSiteId = federationSiteId;
            return this;
        }

        /**
         * User defined VM group id that must be unique among all VM groups ids and also
         * should match the group id used in the pre VM group migrate API.
         *
         * @param groupId New value for the property.
         */
        public Builder setGroupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        public PostVmGroupMigrationSpec build() {
            PostVmGroupMigrationSpec result = new PostVmGroupMigrationSpec();
            result.setAllowOverride(this.allowOverride);
            result.setFailedVmInstanceIds(this.failedVmInstanceIds);
            result.setFederationSiteId(this.federationSiteId);
            result.setGroupId(this.groupId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("allow_override", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("allow_override",
                                                                                "allowOverride",
                                                                                "getAllowOverride",
                                                                                "setAllowOverride");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("failed_vm_instance_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("failed_vm_instance_ids",
                                                                                "failedVmInstanceIds",
                                                                                "getFailedVmInstanceIds",
                                                                                "setFailedVmInstanceIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("federation_site_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("federation_site_id",
                                                                                "federationSiteId",
                                                                                "getFederationSiteId",
                                                                                "setFederationSiteId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("group_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_id",
                                                                                "groupId",
                                                                                "getGroupId",
                                                                                "setGroupId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.post_vm_group_migration_spec",
                                                            fields,
                                                            com.vmware.nsx.model.PostVmGroupMigrationSpec.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

