/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Health Status of a third party partner VM.
 */
public final class ServiceInstanceHealthStatus implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String connectTimestamp;

    private java.lang.Boolean isStale;

    private java.lang.Boolean isSvaMuxIncompatible;

    private java.lang.String muxConnectedStatus;

    private java.lang.String muxIncompatibleVersion;

    private java.lang.String solutionStatus;

    private java.lang.String solutionVersion;

    private java.lang.String syncTime;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ServiceInstanceHealthStatus() {
    }

    protected ServiceInstanceHealthStatus(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Latest timestamp when mux was connected to SVA.
     *
     * @return The current value of the property.
     */
    public java.lang.String getConnectTimestamp() {
        return this.connectTimestamp;
    }

    /**
     * Latest timestamp when mux was connected to SVA.
     *
     * @param connectTimestamp New value for the property.
     */
    public void setConnectTimestamp(java.lang.String connectTimestamp) {
        this.connectTimestamp = connectTimestamp;
    }

    /**
     * The parameter is set if the last received health status is older than the
     * predefined interval.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsStale() {
        return this.isStale;
    }

    /**
     * The parameter is set if the last received health status is older than the
     * predefined interval.
     *
     * This property may be present in responses from the server, but if it is present
     * in a request to server it will be ignored.
     *
     * @param isStale New value for the property.
     */
    public void setIsStale(java.lang.Boolean isStale) {
        this.isStale = isStale;
    }

    /**
     * Protocol version might be different in both Mux and SVA.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsSvaMuxIncompatible() {
        return this.isSvaMuxIncompatible;
    }

    /**
     * Protocol version might be different in both Mux and SVA.
     *
     * @param isSvaMuxIncompatible New value for the property.
     */
    public void setIsSvaMuxIncompatible(java.lang.Boolean isSvaMuxIncompatible) {
        this.isSvaMuxIncompatible = isSvaMuxIncompatible;
    }

    /**
     * Status of multiplexer which forwards the events from guest virtual machines to
     * the partner appliance.
     *
     * @return The current value of the property.
     */
    public java.lang.String getMuxConnectedStatus() {
        return this.muxConnectedStatus;
    }

    /**
     * Status of multiplexer which forwards the events from guest virtual machines to
     * the partner appliance.
     *
     * @param muxConnectedStatus New value for the property.
     */
    public void setMuxConnectedStatus(java.lang.String muxConnectedStatus) {
        this.muxConnectedStatus = muxConnectedStatus;
    }

    /**
     * Mux version when Mux and SVA are incompatible
     *
     * @return The current value of the property.
     */
    public java.lang.String getMuxIncompatibleVersion() {
        return this.muxIncompatibleVersion;
    }

    /**
     * Mux version when Mux and SVA are incompatible
     *
     * @param muxIncompatibleVersion New value for the property.
     */
    public void setMuxIncompatibleVersion(java.lang.String muxIncompatibleVersion) {
        this.muxIncompatibleVersion = muxIncompatibleVersion;
    }

    /**
     * Status of third party partner solution application.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSolutionStatus() {
        return this.solutionStatus;
    }

    /**
     * Status of third party partner solution application.
     *
     * @param solutionStatus New value for the property.
     */
    public void setSolutionStatus(java.lang.String solutionStatus) {
        this.solutionStatus = solutionStatus;
    }

    /**
     * Version of third party partner solution application.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSolutionVersion() {
        return this.solutionVersion;
    }

    /**
     * Version of third party partner solution application.
     *
     * @param solutionVersion New value for the property.
     */
    public void setSolutionVersion(java.lang.String solutionVersion) {
        this.solutionVersion = solutionVersion;
    }

    /**
     * Latest timestamp when health status is received.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSyncTime() {
        return this.syncTime;
    }

    /**
     * Latest timestamp when health status is received.
     *
     * @param syncTime New value for the property.
     */
    public void setSyncTime(java.lang.String syncTime) {
        this.syncTime = syncTime;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.serviceInstanceHealthStatus;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("connect_timestamp",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.connectTimestamp, this._getType().getField("connect_timestamp")));
        structValue.setField("is_stale",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isStale, this._getType().getField("is_stale")));
        structValue.setField("is_sva_mux_incompatible",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isSvaMuxIncompatible, this._getType().getField("is_sva_mux_incompatible")));
        structValue.setField("mux_connected_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.muxConnectedStatus, this._getType().getField("mux_connected_status")));
        structValue.setField("mux_incompatible_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.muxIncompatibleVersion, this._getType().getField("mux_incompatible_version")));
        structValue.setField("solution_status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.solutionStatus, this._getType().getField("solution_status")));
        structValue.setField("solution_version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.solutionVersion, this._getType().getField("solution_version")));
        structValue.setField("sync_time",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.syncTime, this._getType().getField("sync_time")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.serviceInstanceHealthStatus;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.serviceInstanceHealthStatus.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ServiceInstanceHealthStatus _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceInstanceHealthStatus(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ServiceInstanceHealthStatus _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ServiceInstanceHealthStatus(structValue);
    }

    /**
     * Builder class for {@link ServiceInstanceHealthStatus}.
     */
    public static final class Builder {
        private java.lang.String connectTimestamp;
        private java.lang.Boolean isStale;
        private java.lang.Boolean isSvaMuxIncompatible;
        private java.lang.String muxConnectedStatus;
        private java.lang.String muxIncompatibleVersion;
        private java.lang.String solutionStatus;
        private java.lang.String solutionVersion;
        private java.lang.String syncTime;

        /**
         * Constructor with parameters for the required properties of
         * {@link ServiceInstanceHealthStatus}.
         */
        public Builder() {
        }

        /**
         * Latest timestamp when mux was connected to SVA.
         *
         * @param connectTimestamp New value for the property.
         */
        public Builder setConnectTimestamp(java.lang.String connectTimestamp) {
            this.connectTimestamp = connectTimestamp;
            return this;
        }

        /**
         * The parameter is set if the last received health status is older than the
         * predefined interval.
         *
         * This property may be present in responses from the server, but if it is present
         * in a request to server it will be ignored.
         *
         * @param isStale New value for the property.
         */
        public Builder setIsStale(java.lang.Boolean isStale) {
            this.isStale = isStale;
            return this;
        }

        /**
         * Protocol version might be different in both Mux and SVA.
         *
         * @param isSvaMuxIncompatible New value for the property.
         */
        public Builder setIsSvaMuxIncompatible(java.lang.Boolean isSvaMuxIncompatible) {
            this.isSvaMuxIncompatible = isSvaMuxIncompatible;
            return this;
        }

        /**
         * Status of multiplexer which forwards the events from guest virtual machines to
         * the partner appliance.
         *
         * @param muxConnectedStatus New value for the property.
         */
        public Builder setMuxConnectedStatus(java.lang.String muxConnectedStatus) {
            this.muxConnectedStatus = muxConnectedStatus;
            return this;
        }

        /**
         * Mux version when Mux and SVA are incompatible
         *
         * @param muxIncompatibleVersion New value for the property.
         */
        public Builder setMuxIncompatibleVersion(java.lang.String muxIncompatibleVersion) {
            this.muxIncompatibleVersion = muxIncompatibleVersion;
            return this;
        }

        /**
         * Status of third party partner solution application.
         *
         * @param solutionStatus New value for the property.
         */
        public Builder setSolutionStatus(java.lang.String solutionStatus) {
            this.solutionStatus = solutionStatus;
            return this;
        }

        /**
         * Version of third party partner solution application.
         *
         * @param solutionVersion New value for the property.
         */
        public Builder setSolutionVersion(java.lang.String solutionVersion) {
            this.solutionVersion = solutionVersion;
            return this;
        }

        /**
         * Latest timestamp when health status is received.
         *
         * @param syncTime New value for the property.
         */
        public Builder setSyncTime(java.lang.String syncTime) {
            this.syncTime = syncTime;
            return this;
        }

        public ServiceInstanceHealthStatus build() {
            ServiceInstanceHealthStatus result = new ServiceInstanceHealthStatus();
            result.setConnectTimestamp(this.connectTimestamp);
            result.setIsStale(this.isStale);
            result.setIsSvaMuxIncompatible(this.isSvaMuxIncompatible);
            result.setMuxConnectedStatus(this.muxConnectedStatus);
            result.setMuxIncompatibleVersion(this.muxIncompatibleVersion);
            result.setSolutionStatus(this.solutionStatus);
            result.setSolutionVersion(this.solutionVersion);
            result.setSyncTime(this.syncTime);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("connect_timestamp", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("connect_timestamp",
                                                                                "connectTimestamp",
                                                                                "getConnectTimestamp",
                                                                                "setConnectTimestamp");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_stale", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_stale",
                                                                                "isStale",
                                                                                "getIsStale",
                                                                                "setIsStale");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_sva_mux_incompatible", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_sva_mux_incompatible",
                                                                                "isSvaMuxIncompatible",
                                                                                "getIsSvaMuxIncompatible",
                                                                                "setIsSvaMuxIncompatible");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mux_connected_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mux_connected_status",
                                                                                "muxConnectedStatus",
                                                                                "getMuxConnectedStatus",
                                                                                "setMuxConnectedStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("mux_incompatible_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("mux_incompatible_version",
                                                                                "muxIncompatibleVersion",
                                                                                "getMuxIncompatibleVersion",
                                                                                "setMuxIncompatibleVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("solution_status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("solution_status",
                                                                                "solutionStatus",
                                                                                "getSolutionStatus",
                                                                                "setSolutionStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("solution_version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("solution_version",
                                                                                "solutionVersion",
                                                                                "getSolutionVersion",
                                                                                "setSolutionVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sync_time", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sync_time",
                                                                                "syncTime",
                                                                                "getSyncTime",
                                                                                "setSyncTime");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.service_instance_health_status",
                                                            fields,
                                                            com.vmware.nsx.model.ServiceInstanceHealthStatus.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

