/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * This object contains SNMP v2c community identifier, shared secret and access
 * properties.
 */
public final class Snmpv2cCommunity implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String ACCESS_ONLY = "READ_ONLY";

    private java.lang.String access;

    private java.lang.String communityName;

    private java.lang.String communityString;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public Snmpv2cCommunity() {
    }

    protected Snmpv2cCommunity(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv2cCommunity#ACCESS_ONLY}</li> </ul> Access permissions
     * for polling NSX nodes over SNMP v2c.
     *
     * @return The current value of the property.
     */
    public java.lang.String getAccess() {
        return this.access;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.Snmpv2cCommunity#ACCESS_ONLY}</li> </ul> Access permissions
     * for polling NSX nodes over SNMP v2c.
     *
     * @param access New value for the property.
     */
    public void setAccess(java.lang.String access) {
        this.access = access;
    }

    /**
     * Unique, non-sensitive community name to identify community.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCommunityName() {
        return this.communityName;
    }

    /**
     * Unique, non-sensitive community name to identify community.
     *
     * @param communityName New value for the property.
     */
    public void setCommunityName(java.lang.String communityName) {
        this.communityName = communityName;
    }

    /**
     * Community string. This is considered a shared secret and therefore sensitive
     * information. This field is required when adding a community. When updating a
     * community, do not include this field in the request. If this field is present in
     * an update request, it will be considered as a new value for community string.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCommunityString() {
        return this.communityString;
    }

    /**
     * Community string. This is considered a shared secret and therefore sensitive
     * information. This field is required when adding a community. When updating a
     * community, do not include this field in the request. If this field is present in
     * an update request, it will be considered as a new value for community string.
     *
     * @param communityString New value for the property.
     */
    public void setCommunityString(java.lang.String communityString) {
        this.communityString = communityString;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.snmpv2cCommunity;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("access",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.access, this._getType().getField("access")));
        structValue.setField("community_name",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.communityName, this._getType().getField("community_name")));
        structValue.setField("community_string",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.communityString, this._getType().getField("community_string")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.snmpv2cCommunity;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.snmpv2cCommunity.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Snmpv2cCommunity _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Snmpv2cCommunity(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Snmpv2cCommunity _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Snmpv2cCommunity(structValue);
    }

    /**
     * Builder class for {@link Snmpv2cCommunity}.
     */
    public static final class Builder {
        private java.lang.String access;
        private java.lang.String communityName;
        private java.lang.String communityString;

        /**
         * Constructor with parameters for the required properties of
         * {@link Snmpv2cCommunity}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.Snmpv2cCommunity#ACCESS_ONLY}</li> </ul> Access permissions
         * for polling NSX nodes over SNMP v2c.
         *
         * @param access New value for the property.
         */
        public Builder setAccess(java.lang.String access) {
            this.access = access;
            return this;
        }

        /**
         * Unique, non-sensitive community name to identify community.
         *
         * @param communityName New value for the property.
         */
        public Builder setCommunityName(java.lang.String communityName) {
            this.communityName = communityName;
            return this;
        }

        /**
         * Community string. This is considered a shared secret and therefore sensitive
         * information. This field is required when adding a community. When updating a
         * community, do not include this field in the request. If this field is present in
         * an update request, it will be considered as a new value for community string.
         *
         * @param communityString New value for the property.
         */
        public Builder setCommunityString(java.lang.String communityString) {
            this.communityString = communityString;
            return this;
        }

        public Snmpv2cCommunity build() {
            Snmpv2cCommunity result = new Snmpv2cCommunity();
            result.setAccess(this.access);
            result.setCommunityName(this.communityName);
            result.setCommunityString(this.communityString);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("access", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("access",
                                                                                "access",
                                                                                "getAccess",
                                                                                "setAccess");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("community_name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("community_name",
                                                                                "communityName",
                                                                                "getCommunityName",
                                                                                "setCommunityName");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("community_string", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("community_string",
                                                                                "communityString",
                                                                                "getCommunityString",
                                                                                "setCommunityString");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.snmpv2c_community",
                                                            fields,
                                                            com.vmware.nsx.model.Snmpv2cCommunity.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

