/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.node.
 * Used by client-side stubs.
 */

package com.vmware.nsx.node;

public interface Logs extends com.vmware.vapi.bindings.Service, com.vmware.nsx.node.LogsTypes {

    /**
     * For a single specified log file, lists the filename, file size, and
     * last-modified time.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logName Name of log file to read properties (required)
     * @return com.vmware.nsx.model.NodeLogProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeLogProperties get(java.lang.String logName);

    /**
     * For a single specified log file, lists the filename, file size, and
     * last-modified time.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logName Name of log file to read properties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeLogProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeLogProperties get(java.lang.String logName, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * For a single specified log file, lists the filename, file size, and
     * last-modified time.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeLogProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logName Name of log file to read properties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String logName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeLogProperties> asyncCallback);

    /**
     * For a single specified log file, lists the filename, file size, and
     * last-modified time.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeLogProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logName Name of log file to read properties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String logName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeLogProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the number of log files and lists the log files that reside on the NSX
     * virtual appliance. The list includes the filename, file size, and last-modified
     * time in milliseconds since epoch (1 January 1970) for each log file. Knowing the
     * last-modified time with millisecond accuracy since epoch is helpful when you are
     * comparing two times, such as the time of a POST request and the end time on a
     * server.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.NodeLogPropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeLogPropertiesListResult list();

    /**
     * Returns the number of log files and lists the log files that reside on the NSX
     * virtual appliance. The list includes the filename, file size, and last-modified
     * time in milliseconds since epoch (1 January 1970) for each log file. Knowing the
     * last-modified time with millisecond accuracy since epoch is helpful when you are
     * comparing two times, such as the time of a POST request and the end time on a
     * server.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeLogPropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeLogPropertiesListResult list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the number of log files and lists the log files that reside on the NSX
     * virtual appliance. The list includes the filename, file size, and last-modified
     * time in milliseconds since epoch (1 January 1970) for each log file. Knowing the
     * last-modified time with millisecond accuracy since epoch is helpful when you are
     * comparing two times, such as the time of a POST request and the end time on a
     * server.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeLogPropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeLogPropertiesListResult> asyncCallback);

    /**
     * Returns the number of log files and lists the log files that reside on the NSX
     * virtual appliance. The list includes the filename, file size, and last-modified
     * time in milliseconds since epoch (1 January 1970) for each log file. Knowing the
     * last-modified time with millisecond accuracy since epoch is helpful when you are
     * comparing two times, such as the time of a POST request and the end time on a
     * server.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeLogPropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeLogPropertiesListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
