/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.node.
 * Used by client-side stubs.
 */

package com.vmware.nsx.node;

public interface Users extends com.vmware.vapi.bindings.Service, com.vmware.nsx.node.UsersTypes {

    /**
     * Activates the account for this user. When an account is successfully activated,
     * the \"status\" field in the response is \"ACTIVE\". This API is not supported
     * for userid 0 and userid 10000.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param userid User id of the user (required)
     * @param nodeUserPasswordProperty (required)
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties activate(java.lang.String userid, com.vmware.nsx.model.NodeUserPasswordProperty nodeUserPasswordProperty);

    /**
     * Activates the account for this user. When an account is successfully activated,
     * the \"status\" field in the response is \"ACTIVE\". This API is not supported
     * for userid 0 and userid 10000.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param userid User id of the user (required)
     * @param nodeUserPasswordProperty (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties activate(java.lang.String userid, com.vmware.nsx.model.NodeUserPasswordProperty nodeUserPasswordProperty, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Activates the account for this user. When an account is successfully activated,
     * the \"status\" field in the response is \"ACTIVE\". This API is not supported
     * for userid 0 and userid 10000.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param nodeUserPasswordProperty (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void activate(java.lang.String userid, com.vmware.nsx.model.NodeUserPasswordProperty nodeUserPasswordProperty, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback);

    /**
     * Activates the account for this user. When an account is successfully activated,
     * the \"status\" field in the response is \"ACTIVE\". This API is not supported
     * for userid 0 and userid 10000.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param nodeUserPasswordProperty (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void activate(java.lang.String userid, com.vmware.nsx.model.NodeUserPasswordProperty nodeUserPasswordProperty, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create new user account to log in to the NSX web-based user interface or access
     * API. <code>username</code> is required field in case of creating new user,
     * further following usernames - <code>root, admin, audit</code> are reserved and
     * can not be used to create new user account unless for local audit user. In case
     * of local audit account when username not specified in request by default account
     * will be created with <code>audit</code> username, although administrators are
     * allowed to use any other non-duplicate usernames during creation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeUserProperties (required)
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties createaudituser(com.vmware.nsx.model.NodeUserProperties nodeUserProperties);

    /**
     * Create new user account to log in to the NSX web-based user interface or access
     * API. <code>username</code> is required field in case of creating new user,
     * further following usernames - <code>root, admin, audit</code> are reserved and
     * can not be used to create new user account unless for local audit user. In case
     * of local audit account when username not specified in request by default account
     * will be created with <code>audit</code> username, although administrators are
     * allowed to use any other non-duplicate usernames during creation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeUserProperties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties createaudituser(com.vmware.nsx.model.NodeUserProperties nodeUserProperties, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create new user account to log in to the NSX web-based user interface or access
     * API. <code>username</code> is required field in case of creating new user,
     * further following usernames - <code>root, admin, audit</code> are reserved and
     * can not be used to create new user account unless for local audit user. In case
     * of local audit account when username not specified in request by default account
     * will be created with <code>audit</code> username, although administrators are
     * allowed to use any other non-duplicate usernames during creation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeUserProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void createaudituser(com.vmware.nsx.model.NodeUserProperties nodeUserProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback);

    /**
     * Create new user account to log in to the NSX web-based user interface or access
     * API. <code>username</code> is required field in case of creating new user,
     * further following usernames - <code>root, admin, audit</code> are reserved and
     * can not be used to create new user account unless for local audit user. In case
     * of local audit account when username not specified in request by default account
     * will be created with <code>audit</code> username, although administrators are
     * allowed to use any other non-duplicate usernames during creation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeUserProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void createaudituser(com.vmware.nsx.model.NodeUserProperties nodeUserProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create new user account to log in to the NSX web-based user interface or access
     * API. <code>username</code> is required field in case of creating new user,
     * further following usernames - <code>root, admin, audit</code> are reserved and
     * can not be used to create new user account unless for local audit user. In case
     * of local audit account when username not specified in request by default account
     * will be created with <code>audit</code> username, although administrators are
     * allowed to use any other non-duplicate usernames during creation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeUserProperties (required)
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties createuser(com.vmware.nsx.model.NodeUserProperties nodeUserProperties);

    /**
     * Create new user account to log in to the NSX web-based user interface or access
     * API. <code>username</code> is required field in case of creating new user,
     * further following usernames - <code>root, admin, audit</code> are reserved and
     * can not be used to create new user account unless for local audit user. In case
     * of local audit account when username not specified in request by default account
     * will be created with <code>audit</code> username, although administrators are
     * allowed to use any other non-duplicate usernames during creation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeUserProperties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties createuser(com.vmware.nsx.model.NodeUserProperties nodeUserProperties, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create new user account to log in to the NSX web-based user interface or access
     * API. <code>username</code> is required field in case of creating new user,
     * further following usernames - <code>root, admin, audit</code> are reserved and
     * can not be used to create new user account unless for local audit user. In case
     * of local audit account when username not specified in request by default account
     * will be created with <code>audit</code> username, although administrators are
     * allowed to use any other non-duplicate usernames during creation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeUserProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void createuser(com.vmware.nsx.model.NodeUserProperties nodeUserProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback);

    /**
     * Create new user account to log in to the NSX web-based user interface or access
     * API. <code>username</code> is required field in case of creating new user,
     * further following usernames - <code>root, admin, audit</code> are reserved and
     * can not be used to create new user account unless for local audit user. In case
     * of local audit account when username not specified in request by default account
     * will be created with <code>audit</code> username, although administrators are
     * allowed to use any other non-duplicate usernames during creation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeUserProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void createuser(com.vmware.nsx.model.NodeUserProperties nodeUserProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deactivates the account for this user. Deactivating an account is permanent,
     * unlike an account that is temporarily locked because of too many password
     * failures. A deactivated account has to be explicitly activated. When an account
     * is successfully deactivated, the \"status\" field in the response is
     * \"NOT_ACTIVATED\". This API is not supported for userid 0 and userid 10000.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param userid User id of the user (required)
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties deactivate(java.lang.String userid);

    /**
     * Deactivates the account for this user. Deactivating an account is permanent,
     * unlike an account that is temporarily locked because of too many password
     * failures. A deactivated account has to be explicitly activated. When an account
     * is successfully deactivated, the \"status\" field in the response is
     * \"NOT_ACTIVATED\". This API is not supported for userid 0 and userid 10000.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param userid User id of the user (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties deactivate(java.lang.String userid, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deactivates the account for this user. Deactivating an account is permanent,
     * unlike an account that is temporarily locked because of too many password
     * failures. A deactivated account has to be explicitly activated. When an account
     * is successfully deactivated, the \"status\" field in the response is
     * \"NOT_ACTIVATED\". This API is not supported for userid 0 and userid 10000.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void deactivate(java.lang.String userid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback);

    /**
     * Deactivates the account for this user. Deactivating an account is permanent,
     * unlike an account that is temporarily locked because of too many password
     * failures. A deactivated account has to be explicitly activated. When an account
     * is successfully deactivated, the \"status\" field in the response is
     * \"NOT_ACTIVATED\". This API is not supported for userid 0 and userid 10000.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void deactivate(java.lang.String userid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete specified user who is configured to log in to the NSX appliance. Whereas
     * local users root and administrator are not allowed to be deleted, but local user
     * audit is deletable on-demand. 
     * <p><b>Caution</b>, users deleted from following
     * node types cannot be recovered, kindly plan the removal of user accounts
     * accordingly. </p><ul> <li>Autonomous Edge</li> <li>Cloud Service Manager</li>
     * <li>Edge</li> <li>Public Cloud Gateway</li> </ul>
     * <p></p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param userid User id of the user (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String userid);

    /**
     * Delete specified user who is configured to log in to the NSX appliance. Whereas
     * local users root and administrator are not allowed to be deleted, but local user
     * audit is deletable on-demand. 
     * <p><b>Caution</b>, users deleted from following
     * node types cannot be recovered, kindly plan the removal of user accounts
     * accordingly. </p><ul> <li>Autonomous Edge</li> <li>Cloud Service Manager</li>
     * <li>Edge</li> <li>Public Cloud Gateway</li> </ul>
     * <p></p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param userid User id of the user (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String userid, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete specified user who is configured to log in to the NSX appliance. Whereas
     * local users root and administrator are not allowed to be deleted, but local user
     * audit is deletable on-demand. 
     * <p><b>Caution</b>, users deleted from following
     * node types cannot be recovered, kindly plan the removal of user accounts
     * accordingly. </p><ul> <li>Autonomous Edge</li> <li>Cloud Service Manager</li>
     * <li>Edge</li> <li>Public Cloud Gateway</li> </ul>
     * <p></p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String userid, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete specified user who is configured to log in to the NSX appliance. Whereas
     * local users root and administrator are not allowed to be deleted, but local user
     * audit is deletable on-demand. 
     * <p><b>Caution</b>, users deleted from following
     * node types cannot be recovered, kindly plan the removal of user accounts
     * accordingly. </p><ul> <li>Autonomous Edge</li> <li>Cloud Service Manager</li>
     * <li>Edge</li> <li>Public Cloud Gateway</li> </ul>
     * <p></p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String userid, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a specified user who is configured to log in to the
     * NSX appliance. The valid user IDs are: 0, 10000, 10002 or other users managed by
     * administrators.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param userid User id of the user (required)
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties get(java.lang.String userid);

    /**
     * Returns information about a specified user who is configured to log in to the
     * NSX appliance. The valid user IDs are: 0, 10000, 10002 or other users managed by
     * administrators.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param userid User id of the user (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties get(java.lang.String userid, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specified user who is configured to log in to the
     * NSX appliance. The valid user IDs are: 0, 10000, 10002 or other users managed by
     * administrators.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String userid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback);

    /**
     * Returns information about a specified user who is configured to log in to the
     * NSX appliance. The valid user IDs are: 0, 10000, 10002 or other users managed by
     * administrators.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String userid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the list of users configured to log in to the NSX appliance.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.NodeUserPropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserPropertiesListResult list();

    /**
     * Returns the list of users configured to log in to the NSX appliance.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeUserPropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserPropertiesListResult list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the list of users configured to log in to the NSX appliance.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserPropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserPropertiesListResult> asyncCallback);

    /**
     * Returns the list of users configured to log in to the NSX appliance.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserPropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserPropertiesListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the list of users configured to log in to the NSX appliance.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.NodeUserPropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserPropertiesListResult list0();

    /**
     * Returns the list of users configured to log in to the NSX appliance.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeUserPropertiesListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserPropertiesListResult list0(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the list of users configured to log in to the NSX appliance.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserPropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list0(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserPropertiesListResult> asyncCallback);

    /**
     * Returns the list of users configured to log in to the NSX appliance.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserPropertiesListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list0(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserPropertiesListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Enables a user to reset their own password.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param resetNodeUserOwnPasswordProperties (required)
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void resetownpassword(com.vmware.nsx.model.ResetNodeUserOwnPasswordProperties resetNodeUserOwnPasswordProperties);

    /**
     * Enables a user to reset their own password.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param resetNodeUserOwnPasswordProperties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void resetownpassword(com.vmware.nsx.model.ResetNodeUserOwnPasswordProperties resetNodeUserOwnPasswordProperties, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Enables a user to reset their own password.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param resetNodeUserOwnPasswordProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void resetownpassword(com.vmware.nsx.model.ResetNodeUserOwnPasswordProperties resetNodeUserOwnPasswordProperties, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Enables a user to reset their own password.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param resetNodeUserOwnPasswordProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void resetownpassword(com.vmware.nsx.model.ResetNodeUserOwnPasswordProperties resetNodeUserOwnPasswordProperties, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Unlike the PUT version of this call (PUT /node/users/<userid>), this API does
     * not require that the current password for the user be provided. The account of
     * the target user must be \"ACTIVE\" for the call to succeed. This API is not
     * supported for userid 0 and userid 10000.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param userid User id of the user (required)
     * @param nodeUserPasswordProperty (required)
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void resetpassword(java.lang.String userid, com.vmware.nsx.model.NodeUserPasswordProperty nodeUserPasswordProperty);

    /**
     * Unlike the PUT version of this call (PUT /node/users/<userid>), this API does
     * not require that the current password for the user be provided. The account of
     * the target user must be \"ACTIVE\" for the call to succeed. This API is not
     * supported for userid 0 and userid 10000.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param userid User id of the user (required)
     * @param nodeUserPasswordProperty (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void resetpassword(java.lang.String userid, com.vmware.nsx.model.NodeUserPasswordProperty nodeUserPasswordProperty, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Unlike the PUT version of this call (PUT /node/users/<userid>), this API does
     * not require that the current password for the user be provided. The account of
     * the target user must be \"ACTIVE\" for the call to succeed. This API is not
     * supported for userid 0 and userid 10000.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param nodeUserPasswordProperty (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void resetpassword(java.lang.String userid, com.vmware.nsx.model.NodeUserPasswordProperty nodeUserPasswordProperty, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Unlike the PUT version of this call (PUT /node/users/<userid>), this API does
     * not require that the current password for the user be provided. The account of
     * the target user must be \"ACTIVE\" for the call to succeed. This API is not
     * supported for userid 0 and userid 10000.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param nodeUserPasswordProperty (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void resetpassword(java.lang.String userid, com.vmware.nsx.model.NodeUserPasswordProperty nodeUserPasswordProperty, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     *
     * <p>Updates attributes of an existing NSX appliance user. This method cannot be
     * used to add a new user. Modifiable attributes include the username, full name of
     * the user, and password. If you specify a password in a PUT request, it is not
     * returned in the response. Nor is it returned in a GET request.</p> 
     * <p>The
     * specified password does not meet the following (default) complexity
     * requirements: - minimum 12 characters in length - minimum 128 characters in
     * length - minimum 1 uppercase character - minimum 1 lowercase character - minimum
     * 1 numeric character - minimum 1 special character - minimum 5 unique characters
     * - default password complexity rules as enforced by the Linux PAM module</p> <i>
     * the configured password complexity may vary as per defined Authentication and
     * Password policies, which shall be available at: [GET]:
     * /api/v1/node/aaa/auth-policy </i> <br/> 
     * <p>The valid user IDs are: 0, 10000,
     * 10002 or other users managed by administrators. Note that invoking this API does
     * not update any user-related properties of existing objects in the system and
     * does not modify the username field in existing audit log entries.</p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param userid User id of the user (required)
     * @param nodeUserProperties (required)
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties update(java.lang.String userid, com.vmware.nsx.model.NodeUserProperties nodeUserProperties);

    /**
     *
     * <p>Updates attributes of an existing NSX appliance user. This method cannot be
     * used to add a new user. Modifiable attributes include the username, full name of
     * the user, and password. If you specify a password in a PUT request, it is not
     * returned in the response. Nor is it returned in a GET request.</p> 
     * <p>The
     * specified password does not meet the following (default) complexity
     * requirements: - minimum 12 characters in length - minimum 128 characters in
     * length - minimum 1 uppercase character - minimum 1 lowercase character - minimum
     * 1 numeric character - minimum 1 special character - minimum 5 unique characters
     * - default password complexity rules as enforced by the Linux PAM module</p> <i>
     * the configured password complexity may vary as per defined Authentication and
     * Password policies, which shall be available at: [GET]:
     * /api/v1/node/aaa/auth-policy </i> <br/> 
     * <p>The valid user IDs are: 0, 10000,
     * 10002 or other users managed by administrators. Note that invoking this API does
     * not update any user-related properties of existing objects in the system and
     * does not modify the username field in existing audit log entries.</p>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param userid User id of the user (required)
     * @param nodeUserProperties (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.NodeUserProperties
     * @throws com.vmware.vapi.std.errors.ConcurrentChange Conflict
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.NodeUserProperties update(java.lang.String userid, com.vmware.nsx.model.NodeUserProperties nodeUserProperties, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     *
     * <p>Updates attributes of an existing NSX appliance user. This method cannot be
     * used to add a new user. Modifiable attributes include the username, full name of
     * the user, and password. If you specify a password in a PUT request, it is not
     * returned in the response. Nor is it returned in a GET request.</p> 
     * <p>The
     * specified password does not meet the following (default) complexity
     * requirements: - minimum 12 characters in length - minimum 128 characters in
     * length - minimum 1 uppercase character - minimum 1 lowercase character - minimum
     * 1 numeric character - minimum 1 special character - minimum 5 unique characters
     * - default password complexity rules as enforced by the Linux PAM module</p> <i>
     * the configured password complexity may vary as per defined Authentication and
     * Password policies, which shall be available at: [GET]:
     * /api/v1/node/aaa/auth-policy </i> <br/> 
     * <p>The valid user IDs are: 0, 10000,
     * 10002 or other users managed by administrators. Note that invoking this API does
     * not update any user-related properties of existing objects in the system and
     * does not modify the username field in existing audit log entries.</p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param nodeUserProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String userid, com.vmware.nsx.model.NodeUserProperties nodeUserProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback);

    /**
     *
     * <p>Updates attributes of an existing NSX appliance user. This method cannot be
     * used to add a new user. Modifiable attributes include the username, full name of
     * the user, and password. If you specify a password in a PUT request, it is not
     * returned in the response. Nor is it returned in a GET request.</p> 
     * <p>The
     * specified password does not meet the following (default) complexity
     * requirements: - minimum 12 characters in length - minimum 128 characters in
     * length - minimum 1 uppercase character - minimum 1 lowercase character - minimum
     * 1 numeric character - minimum 1 special character - minimum 5 unique characters
     * - default password complexity rules as enforced by the Linux PAM module</p> <i>
     * the configured password complexity may vary as per defined Authentication and
     * Password policies, which shall be available at: [GET]:
     * /api/v1/node/aaa/auth-policy </i> <br/> 
     * <p>The valid user IDs are: 0, 10000,
     * 10002 or other users managed by administrators. Note that invoking this API does
     * not update any user-related properties of existing objects in the system and
     * does not modify the username field in existing audit log entries.</p>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.NodeUserProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.ConcurrentChange} - Conflict<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param userid User id of the user (required)
     * @param nodeUserProperties (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String userid, com.vmware.nsx.model.NodeUserProperties nodeUserProperties, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.NodeUserProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
