
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.pools;

/**
 * {@link PoolsFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.pools package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class PoolsFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private PoolsFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link PoolsFactory} factory instance
     */
    public static PoolsFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        PoolsFactory instance = new PoolsFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.pools.IpBlocks}
     */
    public com.vmware.nsx.pools.IpBlocks ipBlocksService() {
        return this.stubFactory.createStub(IpBlocks.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.pools.IpPools}
     */
    public com.vmware.nsx.pools.IpPools ipPoolsService() {
        return this.stubFactory.createStub(IpPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.pools.IpSubnets}
     */
    public com.vmware.nsx.pools.IpSubnets ipSubnetsService() {
        return this.stubFactory.createStub(IpSubnets.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.pools.MacPools}
     */
    public com.vmware.nsx.pools.MacPools macPoolsService() {
        return this.stubFactory.createStub(MacPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.pools.VniPools}
     */
    public com.vmware.nsx.pools.VniPools vniPoolsService() {
        return this.stubFactory.createStub(VniPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.pools.VtepLabelPools}
     */
    public com.vmware.nsx.pools.VtepLabelPools vtepLabelPoolsService() {
        return this.stubFactory.createStub(VtepLabelPools.class, this.stubConfig);
    }

    public com.vmware.nsx.pools.ip_pools.IpPoolsFactory ipPools() {
        return com.vmware.nsx.pools.ip_pools.IpPoolsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
