/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.pools.
 * Used by client-side stubs.
 */

package com.vmware.nsx.pools;

public interface VniPools extends com.vmware.vapi.bindings.Service, com.vmware.nsx.pools.VniPoolsTypes {

    /**
     * Creates a new VNI pool using the specified VNI pool range. The range should be
     * non-overlapping with an existing range. If the range in payload is present or
     * overlaps with an existing range, return code 400 with bad request and an error
     * message is returned mentioning that the given range overlaps with an existing
     * range.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param vniPool (required)
     * @return com.vmware.nsx.model.VniPool
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VniPool create(com.vmware.nsx.model.VniPool vniPool);

    /**
     * Creates a new VNI pool using the specified VNI pool range. The range should be
     * non-overlapping with an existing range. If the range in payload is present or
     * overlaps with an existing range, return code 400 with bad request and an error
     * message is returned mentioning that the given range overlaps with an existing
     * range.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param vniPool (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.VniPool
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VniPool create(com.vmware.nsx.model.VniPool vniPool, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new VNI pool using the specified VNI pool range. The range should be
     * non-overlapping with an existing range. If the range in payload is present or
     * overlaps with an existing range, return code 400 with bad request and an error
     * message is returned mentioning that the given range overlaps with an existing
     * range.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VniPool
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param vniPool (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.VniPool vniPool, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VniPool> asyncCallback);

    /**
     * Creates a new VNI pool using the specified VNI pool range. The range should be
     * non-overlapping with an existing range. If the range in payload is present or
     * overlaps with an existing range, return code 400 with bad request and an error
     * message is returned mentioning that the given range overlaps with an existing
     * range.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VniPool
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param vniPool (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.VniPool vniPool, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VniPool> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes the given VNI pool.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param poolId VNI pool id (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String poolId, java.lang.Boolean force);

    /**
     * Deletes the given VNI pool.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param poolId VNI pool id (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String poolId, java.lang.Boolean force, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the given VNI pool.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param poolId VNI pool id (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String poolId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the given VNI pool.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param poolId VNI pool id (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String poolId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the specified virtual network identifier (VNI) pool.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param poolId VNI pool ID (required)
     * @return com.vmware.nsx.model.VniPool
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VniPool get(java.lang.String poolId);

    /**
     * Returns information about the specified virtual network identifier (VNI) pool.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param poolId VNI pool ID (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.VniPool
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VniPool get(java.lang.String poolId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the specified virtual network identifier (VNI) pool.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VniPool
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param poolId VNI pool ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String poolId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VniPool> asyncCallback);

    /**
     * Returns information about the specified virtual network identifier (VNI) pool.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VniPool
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param poolId VNI pool ID (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String poolId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VniPool> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the default and configured virtual network identifier
     * (VNI) pools for use when building logical network segments. Each virtual network
     * has a unique ID called a VNI. Instead of creating a new VNI each time you need a
     * new logical switch, you can instead allocate a VNI from a VNI pool. VNI pools
     * are sometimes called segment ID pools. Each VNI pool has a range of usable VNIs.
     * By default, there is one pool with two ranges [5000, 65535] and [65536, 75000].
     * To create multiple smaller pools, specify a smaller range for each pool such as
     * 75001-75100 and 75101-75200. The VNI range determines the maximum number of
     * logical switches that can be created in each network segment.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.VniPoolListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VniPoolListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about the default and configured virtual network identifier
     * (VNI) pools for use when building logical network segments. Each virtual network
     * has a unique ID called a VNI. Instead of creating a new VNI each time you need a
     * new logical switch, you can instead allocate a VNI from a VNI pool. VNI pools
     * are sometimes called segment ID pools. Each VNI pool has a range of usable VNIs.
     * By default, there is one pool with two ranges [5000, 65535] and [65536, 75000].
     * To create multiple smaller pools, specify a smaller range for each pool such as
     * 75001-75100 and 75101-75200. The VNI range determines the maximum number of
     * logical switches that can be created in each network segment.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.VniPoolListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VniPoolListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the default and configured virtual network identifier
     * (VNI) pools for use when building logical network segments. Each virtual network
     * has a unique ID called a VNI. Instead of creating a new VNI each time you need a
     * new logical switch, you can instead allocate a VNI from a VNI pool. VNI pools
     * are sometimes called segment ID pools. Each VNI pool has a range of usable VNIs.
     * By default, there is one pool with two ranges [5000, 65535] and [65536, 75000].
     * To create multiple smaller pools, specify a smaller range for each pool such as
     * 75001-75100 and 75101-75200. The VNI range determines the maximum number of
     * logical switches that can be created in each network segment.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VniPoolListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VniPoolListResult> asyncCallback);

    /**
     * Returns information about the default and configured virtual network identifier
     * (VNI) pools for use when building logical network segments. Each virtual network
     * has a unique ID called a VNI. Instead of creating a new VNI each time you need a
     * new logical switch, you can instead allocate a VNI from a VNI pool. VNI pools
     * are sometimes called segment ID pools. Each VNI pool has a range of usable VNIs.
     * By default, there is one pool with two ranges [5000, 65535] and [65536, 75000].
     * To create multiple smaller pools, specify a smaller range for each pool such as
     * 75001-75100 and 75101-75200. The VNI range determines the maximum number of
     * logical switches that can be created in each network segment.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VniPoolListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VniPoolListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Updates the specified VNI pool. Modifiable parameters include description,
     * display_name and ranges. Ranges can be added, modified or deleted. Overlapping
     * ranges are not allowed. Only range end can be modified for any existing range.
     * Range shrinking or deletion is not allowed if there are any allocated VNIs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param poolId VNI pool ID (required)
     * @param vniPool (required)
     * @return com.vmware.nsx.model.VniPool
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VniPool update(java.lang.String poolId, com.vmware.nsx.model.VniPool vniPool);

    /**
     * Updates the specified VNI pool. Modifiable parameters include description,
     * display_name and ranges. Ranges can be added, modified or deleted. Overlapping
     * ranges are not allowed. Only range end can be modified for any existing range.
     * Range shrinking or deletion is not allowed if there are any allocated VNIs.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param poolId VNI pool ID (required)
     * @param vniPool (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.VniPool
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.VniPool update(java.lang.String poolId, com.vmware.nsx.model.VniPool vniPool, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Updates the specified VNI pool. Modifiable parameters include description,
     * display_name and ranges. Ranges can be added, modified or deleted. Overlapping
     * ranges are not allowed. Only range end can be modified for any existing range.
     * Range shrinking or deletion is not allowed if there are any allocated VNIs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VniPool
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param poolId VNI pool ID (required)
     * @param vniPool (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String poolId, com.vmware.nsx.model.VniPool vniPool, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VniPool> asyncCallback);

    /**
     * Updates the specified VNI pool. Modifiable parameters include description,
     * display_name and ranges. Ranges can be added, modified or deleted. Overlapping
     * ranges are not allowed. Only range end can be modified for any existing range.
     * Range shrinking or deletion is not allowed if there are any allocated VNIs.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.VniPool
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param poolId VNI pool ID (required)
     * @param vniPool (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String poolId, com.vmware.nsx.model.VniPool vniPool, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.VniPool> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
