/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.repository.
 * Used by client-side stubs.
 */

package com.vmware.nsx.repository;

public interface Bundles extends com.vmware.vapi.bindings.Service, com.vmware.nsx.repository.BundlesTypes {

    /**
     * Cancel upload of bundle. This API works only when bundle upload is in-progress
     * and will not work during post-processing of bundle. If bundle upload is
     * in-progress, then the API call returns http OK response after cancelling the
     * upload and deleting partially uploaded bundle.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param bundleId (required)
     * @param product Name of the appliance (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void cancelupload(java.lang.String bundleId, java.lang.String product);

    /**
     * Cancel upload of bundle. This API works only when bundle upload is in-progress
     * and will not work during post-processing of bundle. If bundle upload is
     * in-progress, then the API call returns http OK response after cancelling the
     * upload and deleting partially uploaded bundle.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param bundleId (required)
     * @param product Name of the appliance (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void cancelupload(java.lang.String bundleId, java.lang.String product, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Cancel upload of bundle. This API works only when bundle upload is in-progress
     * and will not work during post-processing of bundle. If bundle upload is
     * in-progress, then the API call returns http OK response after cancelling the
     * upload and deleting partially uploaded bundle.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param bundleId (required)
     * @param product Name of the appliance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void cancelupload(java.lang.String bundleId, java.lang.String product, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Cancel upload of bundle. This API works only when bundle upload is in-progress
     * and will not work during post-processing of bundle. If bundle upload is
     * in-progress, then the API call returns http OK response after cancelling the
     * upload and deleting partially uploaded bundle.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param bundleId (required)
     * @param product Name of the appliance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void cancelupload(java.lang.String bundleId, java.lang.String product, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Upload the bundle from remote bundle URL. The call returns after fetch is
     * initiated. Check status by periodically retrieving bundle upload status using
     * GET /repository/bundles/<bundle-id>/upload-status. The upload is complete when
     * the status is SUCCESS.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param remoteBundleUrl (required)
     * @param fileType Type of file (required)
     * @param product Name of the appliance (required)
     * @return com.vmware.nsx.model.BundleId
     * @throws com.vmware.vapi.std.errors.Unauthenticated Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.BundleId create(com.vmware.nsx.model.RemoteBundleUrl remoteBundleUrl, java.lang.String fileType, java.lang.String product);

    /**
     * Upload the bundle from remote bundle URL. The call returns after fetch is
     * initiated. Check status by periodically retrieving bundle upload status using
     * GET /repository/bundles/<bundle-id>/upload-status. The upload is complete when
     * the status is SUCCESS.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param remoteBundleUrl (required)
     * @param fileType Type of file (required)
     * @param product Name of the appliance (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BundleId
     * @throws com.vmware.vapi.std.errors.Unauthenticated Unauthorized
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.BundleId create(com.vmware.nsx.model.RemoteBundleUrl remoteBundleUrl, java.lang.String fileType, java.lang.String product, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Upload the bundle from remote bundle URL. The call returns after fetch is
     * initiated. Check status by periodically retrieving bundle upload status using
     * GET /repository/bundles/<bundle-id>/upload-status. The upload is complete when
     * the status is SUCCESS.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BundleId
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} - Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param remoteBundleUrl (required)
     * @param fileType Type of file (required)
     * @param product Name of the appliance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.RemoteBundleUrl remoteBundleUrl, java.lang.String fileType, java.lang.String product, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BundleId> asyncCallback);

    /**
     * Upload the bundle from remote bundle URL. The call returns after fetch is
     * initiated. Check status by periodically retrieving bundle upload status using
     * GET /repository/bundles/<bundle-id>/upload-status. The upload is complete when
     * the status is SUCCESS.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BundleId
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.Unauthenticated} - Unauthorized<br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param remoteBundleUrl (required)
     * @param fileType Type of file (required)
     * @param product Name of the appliance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.RemoteBundleUrl remoteBundleUrl, java.lang.String fileType, java.lang.String product, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BundleId> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get list of bundle-ids which are available in repository or in-progress
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param fileType Type of file (required)
     * @param product Name of the appliance (required)
     * @return com.vmware.nsx.model.BundleIds
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.BundleIds get(java.lang.String fileType, java.lang.String product);

    /**
     * Get list of bundle-ids which are available in repository or in-progress
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param fileType Type of file (required)
     * @param product Name of the appliance (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BundleIds
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.BundleIds get(java.lang.String fileType, java.lang.String product, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get list of bundle-ids which are available in repository or in-progress
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BundleIds
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param fileType Type of file (required)
     * @param product Name of the appliance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String fileType, java.lang.String product, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BundleIds> asyncCallback);

    /**
     * Get list of bundle-ids which are available in repository or in-progress
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BundleIds
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param fileType Type of file (required)
     * @param product Name of the appliance (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String fileType, java.lang.String product, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BundleIds> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
