/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.serviceinsertion.
 * Used by client-side stubs.
 */

package com.vmware.nsx.serviceinsertion;

public interface ServiceInstances extends com.vmware.vapi.bindings.Service, com.vmware.nsx.serviceinsertion.ServiceInstancesTypes {

    /**
     * Returns all Service-Instance(s) of all Services present in system. When request
     * parameter (deployed_to or service_deployment_id) is provided as a part of
     * request, it will filter out Service-Instances accordingly.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param deployedTo Deployed_to referenced by service instances present in system (optional)
     * @param serviceDeploymentId Service Deployment Id using which the instances were deployed (optional)
     * @return com.vmware.nsx.model.ServiceInstanceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ServiceInstanceListResult list(java.lang.String deployedTo, java.lang.String serviceDeploymentId);

    /**
     * Returns all Service-Instance(s) of all Services present in system. When request
     * parameter (deployed_to or service_deployment_id) is provided as a part of
     * request, it will filter out Service-Instances accordingly.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param deployedTo Deployed_to referenced by service instances present in system (optional)
     * @param serviceDeploymentId Service Deployment Id using which the instances were deployed (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ServiceInstanceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ServiceInstanceListResult list(java.lang.String deployedTo, java.lang.String serviceDeploymentId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns all Service-Instance(s) of all Services present in system. When request
     * parameter (deployed_to or service_deployment_id) is provided as a part of
     * request, it will filter out Service-Instances accordingly.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInstanceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param deployedTo Deployed_to referenced by service instances present in system (optional)
     * @param serviceDeploymentId Service Deployment Id using which the instances were deployed (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String deployedTo, java.lang.String serviceDeploymentId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInstanceListResult> asyncCallback);

    /**
     * Returns all Service-Instance(s) of all Services present in system. When request
     * parameter (deployed_to or service_deployment_id) is provided as a part of
     * request, it will filter out Service-Instances accordingly.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ServiceInstanceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param deployedTo Deployed_to referenced by service instances present in system (optional)
     * @param serviceDeploymentId Service Deployment Id using which the instances were deployed (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String deployedTo, java.lang.String serviceDeploymentId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ServiceInstanceListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
