
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.serviceinsertion.services;

/**
 * {@link ServicesFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.serviceinsertion.services package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class ServicesFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private ServicesFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link ServicesFactory} factory instance
     */
    public static ServicesFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        ServicesFactory instance = new ServicesFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.ServiceDeployments}
     */
    public com.vmware.nsx.serviceinsertion.services.ServiceDeployments serviceDeploymentsService() {
        return this.stubFactory.createStub(ServiceDeployments.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.ServiceInstances}
     */
    public com.vmware.nsx.serviceinsertion.services.ServiceInstances serviceInstancesService() {
        return this.stubFactory.createStub(ServiceInstances.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.ServiceProfiles}
     */
    public com.vmware.nsx.serviceinsertion.services.ServiceProfiles serviceProfilesService() {
        return this.stubFactory.createStub(ServiceProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.SolutionConfigs}
     */
    public com.vmware.nsx.serviceinsertion.services.SolutionConfigs solutionConfigsService() {
        return this.stubFactory.createStub(SolutionConfigs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.VendorTemplates}
     */
    public com.vmware.nsx.serviceinsertion.services.VendorTemplates vendorTemplatesService() {
        return this.stubFactory.createStub(VendorTemplates.class, this.stubConfig);
    }

    public com.vmware.nsx.serviceinsertion.services.service_deployments.ServiceDeploymentsFactory serviceDeployments() {
        return com.vmware.nsx.serviceinsertion.services.service_deployments.ServiceDeploymentsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.serviceinsertion.services.service_instances.ServiceInstancesFactory serviceInstances() {
        return com.vmware.nsx.serviceinsertion.services.service_instances.ServiceInstancesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.serviceinsertion.services.service_profiles.ServiceProfilesFactory serviceProfiles() {
        return com.vmware.nsx.serviceinsertion.services.service_profiles.ServiceProfilesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.serviceinsertion.services.solution_configs.SolutionConfigsFactory solutionConfigs() {
        return com.vmware.nsx.serviceinsertion.services.solution_configs.SolutionConfigsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
