
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.serviceinsertion.services.service_instances;

/**
 * {@link ServiceInstancesFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.serviceinsertion.services.service_instances package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class ServiceInstancesFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private ServiceInstancesFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link ServiceInstancesFactory} factory instance
     */
    public static ServiceInstancesFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        ServiceInstancesFactory instance = new ServiceInstancesFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.service_instances.GroupAssociations}
     */
    public com.vmware.nsx.serviceinsertion.services.service_instances.GroupAssociations groupAssociationsService() {
        return this.stubFactory.createStub(GroupAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.service_instances.InstanceEndpoints}
     */
    public com.vmware.nsx.serviceinsertion.services.service_instances.InstanceEndpoints instanceEndpointsService() {
        return this.stubFactory.createStub(InstanceEndpoints.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.service_instances.InstanceRuntimes}
     */
    public com.vmware.nsx.serviceinsertion.services.service_instances.InstanceRuntimes instanceRuntimesService() {
        return this.stubFactory.createStub(InstanceRuntimes.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.service_instances.State}
     */
    public com.vmware.nsx.serviceinsertion.services.service_instances.State stateService() {
        return this.stubFactory.createStub(State.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.serviceinsertion.services.service_instances.Status}
     */
    public com.vmware.nsx.serviceinsertion.services.service_instances.Status statusService() {
        return this.stubFactory.createStub(Status.class, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
