/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.serviceinsertion.services.solution_configs.
 * Used by client-side stubs.
 */

package com.vmware.nsx.serviceinsertion.services.solution_configs;

public interface ExtendedSolutionConfig extends com.vmware.vapi.bindings.Service, com.vmware.nsx.serviceinsertion.services.solution_configs.ExtendedSolutionConfigTypes {

    /**
     * Adds a extended solution config. Extended Solution Config are service level
     * objects, used by the NXGI partner Service inside the SVM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param extendedSolutionConfig (required)
     * @return com.vmware.nsx.model.ExtendedSolutionConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ExtendedSolutionConfig create(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.nsx.model.ExtendedSolutionConfig extendedSolutionConfig);

    /**
     * Adds a extended solution config. Extended Solution Config are service level
     * objects, used by the NXGI partner Service inside the SVM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param extendedSolutionConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ExtendedSolutionConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ExtendedSolutionConfig create(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.nsx.model.ExtendedSolutionConfig extendedSolutionConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Adds a extended solution config. Extended Solution Config are service level
     * objects, used by the NXGI partner Service inside the SVM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ExtendedSolutionConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param extendedSolutionConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.nsx.model.ExtendedSolutionConfig extendedSolutionConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ExtendedSolutionConfig> asyncCallback);

    /**
     * Adds a extended solution config. Extended Solution Config are service level
     * objects, used by the NXGI partner Service inside the SVM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ExtendedSolutionConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param extendedSolutionConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.nsx.model.ExtendedSolutionConfig extendedSolutionConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ExtendedSolutionConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes extended solution config information for a given solution config id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String serviceId, java.lang.String solutionConfigId);

    /**
     * Deletes extended solution config information for a given solution config id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes extended solution config information for a given solution config id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes extended solution config information for a given solution config id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns extended solution config information for a given solution config id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @return com.vmware.nsx.model.ExtendedSolutionConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ExtendedSolutionConfig get(java.lang.String serviceId, java.lang.String solutionConfigId);

    /**
     * Returns extended solution config information for a given solution config id.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ExtendedSolutionConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ExtendedSolutionConfig get(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns extended solution config information for a given solution config id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ExtendedSolutionConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ExtendedSolutionConfig> asyncCallback);

    /**
     * Returns extended solution config information for a given solution config id.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ExtendedSolutionConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ExtendedSolutionConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Updates a extended solution config. Extended Solution Config are service level
     * objects, used by the NXGI partner Service inside the SVM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param extendedSolutionConfig (required)
     * @return com.vmware.nsx.model.ExtendedSolutionConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ExtendedSolutionConfig update(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.nsx.model.ExtendedSolutionConfig extendedSolutionConfig);

    /**
     * Updates a extended solution config. Extended Solution Config are service level
     * objects, used by the NXGI partner Service inside the SVM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param extendedSolutionConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ExtendedSolutionConfig
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ExtendedSolutionConfig update(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.nsx.model.ExtendedSolutionConfig extendedSolutionConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Updates a extended solution config. Extended Solution Config are service level
     * objects, used by the NXGI partner Service inside the SVM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ExtendedSolutionConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param extendedSolutionConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.nsx.model.ExtendedSolutionConfig extendedSolutionConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ExtendedSolutionConfig> asyncCallback);

    /**
     * Updates a extended solution config. Extended Solution Config are service level
     * objects, used by the NXGI partner Service inside the SVM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ExtendedSolutionConfig
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serviceId (required)
     * @param solutionConfigId (required)
     * @param extendedSolutionConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String serviceId, java.lang.String solutionConfigId, com.vmware.nsx.model.ExtendedSolutionConfig extendedSolutionConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ExtendedSolutionConfig> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
