/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.sites.compatibility.
 * Used by client-side stubs.
 */

package com.vmware.nsx.sites.compatibility;

public interface Remote extends com.vmware.vapi.bindings.Service, com.vmware.nsx.sites.compatibility.RemoteTypes {

    /**
     * Returns the version of this site and list of compatible versions for both local
     * and remote site, also a boolean indicating whether the two are compatible, this
     * value is true if one of the site version is in the compatibility list of the
     * other site
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param remoteSiteCredential (required)
     * @return com.vmware.nsx.model.RemoteSiteCompatibilityInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.RemoteSiteCompatibilityInfo get(com.vmware.nsx.model.RemoteSiteCredential remoteSiteCredential);

    /**
     * Returns the version of this site and list of compatible versions for both local
     * and remote site, also a boolean indicating whether the two are compatible, this
     * value is true if one of the site version is in the compatibility list of the
     * other site
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param remoteSiteCredential (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.RemoteSiteCompatibilityInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.RemoteSiteCompatibilityInfo get(com.vmware.nsx.model.RemoteSiteCredential remoteSiteCredential, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the version of this site and list of compatible versions for both local
     * and remote site, also a boolean indicating whether the two are compatible, this
     * value is true if one of the site version is in the compatibility list of the
     * other site
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.RemoteSiteCompatibilityInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param remoteSiteCredential (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(com.vmware.nsx.model.RemoteSiteCredential remoteSiteCredential, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.RemoteSiteCompatibilityInfo> asyncCallback);

    /**
     * Returns the version of this site and list of compatible versions for both local
     * and remote site, also a boolean indicating whether the two are compatible, this
     * value is true if one of the site version is in the compatibility list of the
     * other site
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.RemoteSiteCompatibilityInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param remoteSiteCredential (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(com.vmware.nsx.model.RemoteSiteCredential remoteSiteCredential, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.RemoteSiteCompatibilityInfo> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
