
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.transport_nodes;

/**
 * {@link TransportNodesFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.transport_nodes package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class TransportNodesFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private TransportNodesFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link TransportNodesFactory} factory instance
     */
    public static TransportNodesFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        TransportNodesFactory instance = new TransportNodesFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.transport_nodes.Capabilities}
     */
    public com.vmware.nsx.transport_nodes.Capabilities capabilitiesService() {
        return this.stubFactory.createStub(Capabilities.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.transport_nodes.Modules}
     */
    public com.vmware.nsx.transport_nodes.Modules modulesService() {
        return this.stubFactory.createStub(Modules.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.transport_nodes.PnicBondStatus}
     */
    public com.vmware.nsx.transport_nodes.PnicBondStatus pnicBondStatusService() {
        return this.stubFactory.createStub(PnicBondStatus.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.transport_nodes.RemoteTransportNodeStatus}
     */
    public com.vmware.nsx.transport_nodes.RemoteTransportNodeStatus remoteTransportNodeStatusService() {
        return this.stubFactory.createStub(RemoteTransportNodeStatus.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.transport_nodes.State}
     */
    public com.vmware.nsx.transport_nodes.State stateService() {
        return this.stubFactory.createStub(State.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.transport_nodes.Status}
     */
    public com.vmware.nsx.transport_nodes.Status statusService() {
        return this.stubFactory.createStub(Status.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.transport_nodes.Tunnels}
     */
    public com.vmware.nsx.transport_nodes.Tunnels tunnelsService() {
        return this.stubFactory.createStub(Tunnels.class, this.stubConfig);
    }

    public com.vmware.nsx.transport_nodes.inter_site.InterSiteFactory interSite() {
        return com.vmware.nsx.transport_nodes.inter_site.InterSiteFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.transport_nodes.network.NetworkFactory network() {
        return com.vmware.nsx.transport_nodes.network.NetworkFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.transport_nodes.statistics.StatisticsFactory statistics() {
        return com.vmware.nsx.transport_nodes.statistics.StatisticsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
