/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.transport_nodes.inter_site.bgp.neighbors.
 * Used by client-side stubs.
 */

package com.vmware.nsx.transport_nodes.inter_site.bgp.neighbors;

public interface AdvertisedRoutes extends com.vmware.vapi.bindings.Service, com.vmware.nsx.transport_nodes.inter_site.bgp.neighbors.AdvertisedRoutesTypes {

    /**
     * Returns routes advertised by BGP neighbor from the given edge transport node. It
     * always returns realtime response.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param edgeNodeId (required)
     * @param neighborId (required)
     * @return com.vmware.nsx.model.BgpNeighborRouteDetails
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.BgpNeighborRouteDetails get(java.lang.String edgeNodeId, java.lang.String neighborId);

    /**
     * Returns routes advertised by BGP neighbor from the given edge transport node. It
     * always returns realtime response.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param edgeNodeId (required)
     * @param neighborId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.BgpNeighborRouteDetails
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.BgpNeighborRouteDetails get(java.lang.String edgeNodeId, java.lang.String neighborId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns routes advertised by BGP neighbor from the given edge transport node. It
     * always returns realtime response.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighborRouteDetails
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeNodeId (required)
     * @param neighborId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String edgeNodeId, java.lang.String neighborId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighborRouteDetails> asyncCallback);

    /**
     * Returns routes advertised by BGP neighbor from the given edge transport node. It
     * always returns realtime response.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.BgpNeighborRouteDetails
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeNodeId (required)
     * @param neighborId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String edgeNodeId, java.lang.String neighborId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.BgpNeighborRouteDetails> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
