/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.upgrade.
 * Used by client-side stubs.
 */

package com.vmware.nsx.upgrade;

public interface UpgradeUnitGroups extends com.vmware.vapi.bindings.Service, com.vmware.nsx.upgrade.UpgradeUnitGroupsTypes {

    /**
     * Add upgrade units to specified upgrade unit group. The upgrade units will be
     * added at the end of the upgrade unit list.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param groupId (required)
     * @param upgradeUnitList (required)
     * @return com.vmware.nsx.model.UpgradeUnitList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitList addupgradeunits(java.lang.String groupId, com.vmware.nsx.model.UpgradeUnitList upgradeUnitList);

    /**
     * Add upgrade units to specified upgrade unit group. The upgrade units will be
     * added at the end of the upgrade unit list.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param groupId (required)
     * @param upgradeUnitList (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeUnitList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitList addupgradeunits(java.lang.String groupId, com.vmware.nsx.model.UpgradeUnitList upgradeUnitList, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Add upgrade units to specified upgrade unit group. The upgrade units will be
     * added at the end of the upgrade unit list.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param upgradeUnitList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void addupgradeunits(java.lang.String groupId, com.vmware.nsx.model.UpgradeUnitList upgradeUnitList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitList> asyncCallback);

    /**
     * Add upgrade units to specified upgrade unit group. The upgrade units will be
     * added at the end of the upgrade unit list.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param upgradeUnitList (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void addupgradeunits(java.lang.String groupId, com.vmware.nsx.model.UpgradeUnitList upgradeUnitList, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create a group of upgrade units.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param upgradeUnitGroup (required)
     * @return com.vmware.nsx.model.UpgradeUnitGroup
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroup create(com.vmware.nsx.model.UpgradeUnitGroup upgradeUnitGroup);

    /**
     * Create a group of upgrade units.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param upgradeUnitGroup (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeUnitGroup
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroup create(com.vmware.nsx.model.UpgradeUnitGroup upgradeUnitGroup, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a group of upgrade units.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroup
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeUnitGroup (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.UpgradeUnitGroup upgradeUnitGroup, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroup> asyncCallback);

    /**
     * Create a group of upgrade units.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroup
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param upgradeUnitGroup (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.UpgradeUnitGroup upgradeUnitGroup, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroup> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete the specified group. NOTE - A group can be deleted only if it is empty.
     * If user tries to delete a group containing one or more upgrade units, the
     * operation will fail and an error will be returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param groupId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String groupId);

    /**
     * Delete the specified group. NOTE - A group can be deleted only if it is empty.
     * If user tries to delete a group containing one or more upgrade units, the
     * operation will fail and an error will be returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param groupId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String groupId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete the specified group. NOTE - A group can be deleted only if it is empty.
     * If user tries to delete a group containing one or more upgrade units, the
     * operation will fail and an error will be returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String groupId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete the specified group. NOTE - A group can be deleted only if it is empty.
     * If user tries to delete a group containing one or more upgrade units, the
     * operation will fail and an error will be returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String groupId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a specific upgrade unit group in the upgrade plan. If
     * request parameter summary is set to true, then only count of upgrade units will
     * be returned, upgrade units list will be empty.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param groupId (required)
     * @param summary Flag indicating whether to return the summary (optional, default to false)
     * @return com.vmware.nsx.model.UpgradeUnitGroup
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroup get(java.lang.String groupId, java.lang.Boolean summary);

    /**
     * Returns information about a specific upgrade unit group in the upgrade plan. If
     * request parameter summary is set to true, then only count of upgrade units will
     * be returned, upgrade units list will be empty.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param groupId (required)
     * @param summary Flag indicating whether to return the summary (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeUnitGroup
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroup get(java.lang.String groupId, java.lang.Boolean summary, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specific upgrade unit group in the upgrade plan. If
     * request parameter summary is set to true, then only count of upgrade units will
     * be returned, upgrade units list will be empty.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroup
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param summary Flag indicating whether to return the summary (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String groupId, java.lang.Boolean summary, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroup> asyncCallback);

    /**
     * Returns information about a specific upgrade unit group in the upgrade plan. If
     * request parameter summary is set to true, then only count of upgrade units will
     * be returned, upgrade units list will be empty.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroup
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param summary Flag indicating whether to return the summary (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String groupId, java.lang.Boolean summary, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroup> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Return information of all upgrade unit groups in the upgrade plan. If request
     * parameter summary is set to true, then only count of upgrade units will be
     * returned, upgrade units list will be empty. If request parameter component type
     * is specified, then all upgrade unit groups for that component will be returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Component type based on which upgrade unit groups to be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param summary Flag indicating whether to return summary (optional, default to false)
     * @param sync Synchronize before returning upgrade unit groups (optional, default to false)
     * @return com.vmware.nsx.model.UpgradeUnitGroupListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroupListResult list(java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.Boolean summary, java.lang.Boolean sync);

    /**
     * Return information of all upgrade unit groups in the upgrade plan. If request
     * parameter summary is set to true, then only count of upgrade units will be
     * returned, upgrade units list will be empty. If request parameter component type
     * is specified, then all upgrade unit groups for that component will be returned.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Component type based on which upgrade unit groups to be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param summary Flag indicating whether to return summary (optional, default to false)
     * @param sync Synchronize before returning upgrade unit groups (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeUnitGroupListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroupListResult list(java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.Boolean summary, java.lang.Boolean sync, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return information of all upgrade unit groups in the upgrade plan. If request
     * parameter summary is set to true, then only count of upgrade units will be
     * returned, upgrade units list will be empty. If request parameter component type
     * is specified, then all upgrade unit groups for that component will be returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroupListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param componentType Component type based on which upgrade unit groups to be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param summary Flag indicating whether to return summary (optional, default to false)
     * @param sync Synchronize before returning upgrade unit groups (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.Boolean summary, java.lang.Boolean sync, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroupListResult> asyncCallback);

    /**
     * Return information of all upgrade unit groups in the upgrade plan. If request
     * parameter summary is set to true, then only count of upgrade units will be
     * returned, upgrade units list will be empty. If request parameter component type
     * is specified, then all upgrade unit groups for that component will be returned.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroupListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param componentType Component type based on which upgrade unit groups to be filtered (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param summary Flag indicating whether to return summary (optional, default to false)
     * @param sync Synchronize before returning upgrade unit groups (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String componentType, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.Boolean summary, java.lang.Boolean sync, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroupListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Reorder an upgrade unit group by placing it before/after the specified upgrade
     * unit group.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param groupId (required)
     * @param reorderRequest (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void reorder(java.lang.String groupId, com.vmware.nsx.model.ReorderRequest reorderRequest);

    /**
     * Reorder an upgrade unit group by placing it before/after the specified upgrade
     * unit group.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param groupId (required)
     * @param reorderRequest (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void reorder(java.lang.String groupId, com.vmware.nsx.model.ReorderRequest reorderRequest, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Reorder an upgrade unit group by placing it before/after the specified upgrade
     * unit group.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param reorderRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void reorder(java.lang.String groupId, com.vmware.nsx.model.ReorderRequest reorderRequest, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Reorder an upgrade unit group by placing it before/after the specified upgrade
     * unit group.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param reorderRequest (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void reorder(java.lang.String groupId, com.vmware.nsx.model.ReorderRequest reorderRequest, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Update the specified upgrade unit group. Removal of upgrade units from the group
     * using this is not allowed. An error will be returned in that case.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param groupId (required)
     * @param upgradeUnitGroup (required)
     * @return com.vmware.nsx.model.UpgradeUnitGroup
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroup update(java.lang.String groupId, com.vmware.nsx.model.UpgradeUnitGroup upgradeUnitGroup);

    /**
     * Update the specified upgrade unit group. Removal of upgrade units from the group
     * using this is not allowed. An error will be returned in that case.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param groupId (required)
     * @param upgradeUnitGroup (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeUnitGroup
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeUnitGroup update(java.lang.String groupId, com.vmware.nsx.model.UpgradeUnitGroup upgradeUnitGroup, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Update the specified upgrade unit group. Removal of upgrade units from the group
     * using this is not allowed. An error will be returned in that case.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroup
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param upgradeUnitGroup (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String groupId, com.vmware.nsx.model.UpgradeUnitGroup upgradeUnitGroup, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroup> asyncCallback);

    /**
     * Update the specified upgrade unit group. Removal of upgrade units from the group
     * using this is not allowed. An error will be returned in that case.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeUnitGroup
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param groupId (required)
     * @param upgradeUnitGroup (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String groupId, com.vmware.nsx.model.UpgradeUnitGroup upgradeUnitGroup, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeUnitGroup> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
