/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.upgrade.pre_upgrade_checks.
 * Used by client-side stubs.
 */

package com.vmware.nsx.upgrade.pre_upgrade_checks;

public interface Failures extends com.vmware.vapi.bindings.Service, com.vmware.nsx.upgrade.pre_upgrade_checks.FailuresTypes {

    /**
     * Get failures resulting from the last execution of pre-upgrade checks. If the
     * execution of checks is in progress, the response has the list of failures
     * observed so far.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param componentType Component type (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param filterText Filter text (optional)
     * @param groupId Filter on the group id (optional)
     * @param groupName Filter on the group name (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param needsAck Filter based on acknowledgement required (optional)
     * @param originType Type of origin of failure (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Status of the upgrade check (optional)
     * @param unitId Filter on the unit id (optional)
     * @param unitName Filter on the unit name (optional)
     * @return com.vmware.nsx.model.UpgradeCheckFailureListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeCheckFailureListResult list(java.lang.String componentType, java.lang.String cursor, java.lang.String filterText, java.lang.String groupId, java.lang.String groupName, java.lang.String includedFields, java.lang.Boolean needsAck, java.lang.String originType, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, java.lang.String unitId, java.lang.String unitName);

    /**
     * Get failures resulting from the last execution of pre-upgrade checks. If the
     * execution of checks is in progress, the response has the list of failures
     * observed so far.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param componentType Component type (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param filterText Filter text (optional)
     * @param groupId Filter on the group id (optional)
     * @param groupName Filter on the group name (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param needsAck Filter based on acknowledgement required (optional)
     * @param originType Type of origin of failure (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Status of the upgrade check (optional)
     * @param unitId Filter on the unit id (optional)
     * @param unitName Filter on the unit name (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.UpgradeCheckFailureListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.UpgradeCheckFailureListResult list(java.lang.String componentType, java.lang.String cursor, java.lang.String filterText, java.lang.String groupId, java.lang.String groupName, java.lang.String includedFields, java.lang.Boolean needsAck, java.lang.String originType, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, java.lang.String unitId, java.lang.String unitName, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get failures resulting from the last execution of pre-upgrade checks. If the
     * execution of checks is in progress, the response has the list of failures
     * observed so far.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeCheckFailureListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param componentType Component type (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param filterText Filter text (optional)
     * @param groupId Filter on the group id (optional)
     * @param groupName Filter on the group name (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param needsAck Filter based on acknowledgement required (optional)
     * @param originType Type of origin of failure (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Status of the upgrade check (optional)
     * @param unitId Filter on the unit id (optional)
     * @param unitName Filter on the unit name (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String componentType, java.lang.String cursor, java.lang.String filterText, java.lang.String groupId, java.lang.String groupName, java.lang.String includedFields, java.lang.Boolean needsAck, java.lang.String originType, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, java.lang.String unitId, java.lang.String unitName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeCheckFailureListResult> asyncCallback);

    /**
     * Get failures resulting from the last execution of pre-upgrade checks. If the
     * execution of checks is in progress, the response has the list of failures
     * observed so far.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.UpgradeCheckFailureListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param componentType Component type (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param filterText Filter text (optional)
     * @param groupId Filter on the group id (optional)
     * @param groupName Filter on the group name (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param needsAck Filter based on acknowledgement required (optional)
     * @param originType Type of origin of failure (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Status of the upgrade check (optional)
     * @param unitId Filter on the unit id (optional)
     * @param unitName Filter on the unit name (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String componentType, java.lang.String cursor, java.lang.String filterText, java.lang.String groupId, java.lang.String groupName, java.lang.String includedFields, java.lang.Boolean needsAck, java.lang.String originType, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, java.lang.String unitId, java.lang.String unitName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.UpgradeCheckFailureListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
