
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.vpn.ipsec;

/**
 * {@link IpsecFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.vpn.ipsec package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class IpsecFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private IpsecFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link IpsecFactory} factory instance
     */
    public static IpsecFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        IpsecFactory instance = new IpsecFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.vpn.ipsec.DpdProfiles}
     */
    public com.vmware.nsx.vpn.ipsec.DpdProfiles dpdProfilesService() {
        return this.stubFactory.createStub(DpdProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.vpn.ipsec.IkeProfiles}
     */
    public com.vmware.nsx.vpn.ipsec.IkeProfiles ikeProfilesService() {
        return this.stubFactory.createStub(IkeProfiles.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.vpn.ipsec.LocalEndpoints}
     */
    public com.vmware.nsx.vpn.ipsec.LocalEndpoints localEndpointsService() {
        return this.stubFactory.createStub(LocalEndpoints.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.vpn.ipsec.PeerEndpoints}
     */
    public com.vmware.nsx.vpn.ipsec.PeerEndpoints peerEndpointsService() {
        return this.stubFactory.createStub(PeerEndpoints.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.vpn.ipsec.Services}
     */
    public com.vmware.nsx.vpn.ipsec.Services servicesService() {
        return this.stubFactory.createStub(Services.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.vpn.ipsec.Sessions}
     */
    public com.vmware.nsx.vpn.ipsec.Sessions sessionsService() {
        return this.stubFactory.createStub(Sessions.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.vpn.ipsec.TunnelProfiles}
     */
    public com.vmware.nsx.vpn.ipsec.TunnelProfiles tunnelProfilesService() {
        return this.stubFactory.createStub(TunnelProfiles.class, this.stubConfig);
    }

    public com.vmware.nsx.vpn.ipsec.sessions.SessionsFactory sessions() {
        return com.vmware.nsx.vpn.ipsec.sessions.SessionsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
