/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.vpn.ipsec.sessions.
 * Used by client-side stubs.
 */

package com.vmware.nsx.vpn.ipsec.sessions;

public interface State extends com.vmware.vapi.bindings.Service, com.vmware.nsx.vpn.ipsec.sessions.StateTypes {

    /**
     * Return realized state information of a ipsec vpn session. Any configuration
     * update that affects the ipsec vpn session can use this API to get its realized
     * state by passing a request_id returned by the configuration change operation.
     * e.g. Update configuration of ipsec vpn session, service, endpoints, profiles,
     * etc. It will return a service disabled error, if the ipsec vpn service
     * associated with the session is disabled. <br/> <br/> Please use below Policy
     * APIs. <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entity?realized_path=/policy/api/v1/infra/tier-0s/<tier-0-id>/ipsec-vpn-services/<service-id>/sessions/<session-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entity?realized_path=/policy/api/v1/infra/tier-1s/<tier-1-id>/ipsec-vpn-services/<service-id>/sessions/<session-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ipsecVpnSessionId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @return com.vmware.nsx.model.IPSecVPNSessionState
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNSessionState get(java.lang.String ipsecVpnSessionId, java.lang.Long barrierId, java.lang.String requestId);

    /**
     * Return realized state information of a ipsec vpn session. Any configuration
     * update that affects the ipsec vpn session can use this API to get its realized
     * state by passing a request_id returned by the configuration change operation.
     * e.g. Update configuration of ipsec vpn session, service, endpoints, profiles,
     * etc. It will return a service disabled error, if the ipsec vpn service
     * associated with the session is disabled. <br/> <br/> Please use below Policy
     * APIs. <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entity?realized_path=/policy/api/v1/infra/tier-0s/<tier-0-id>/ipsec-vpn-services/<service-id>/sessions/<session-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entity?realized_path=/policy/api/v1/infra/tier-1s/<tier-1-id>/ipsec-vpn-services/<service-id>/sessions/<session-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ipsecVpnSessionId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.IPSecVPNSessionState
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.IPSecVPNSessionState get(java.lang.String ipsecVpnSessionId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return realized state information of a ipsec vpn session. Any configuration
     * update that affects the ipsec vpn session can use this API to get its realized
     * state by passing a request_id returned by the configuration change operation.
     * e.g. Update configuration of ipsec vpn session, service, endpoints, profiles,
     * etc. It will return a service disabled error, if the ipsec vpn service
     * associated with the session is disabled. <br/> <br/> Please use below Policy
     * APIs. <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entity?realized_path=/policy/api/v1/infra/tier-0s/<tier-0-id>/ipsec-vpn-services/<service-id>/sessions/<session-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entity?realized_path=/policy/api/v1/infra/tier-1s/<tier-1-id>/ipsec-vpn-services/<service-id>/sessions/<session-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNSessionState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipsecVpnSessionId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String ipsecVpnSessionId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNSessionState> asyncCallback);

    /**
     * Return realized state information of a ipsec vpn session. Any configuration
     * update that affects the ipsec vpn session can use this API to get its realized
     * state by passing a request_id returned by the configuration change operation.
     * e.g. Update configuration of ipsec vpn session, service, endpoints, profiles,
     * etc. It will return a service disabled error, if the ipsec vpn service
     * associated with the session is disabled. <br/> <br/> Please use below Policy
     * APIs. <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entity?realized_path=/policy/api/v1/infra/tier-0s/<tier-0-id>/ipsec-vpn-services/<service-id>/sessions/<session-id>
     * <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entity?realized_path=/policy/api/v1/infra/tier-1s/<tier-1-id>/ipsec-vpn-services/<service-id>/sessions/<session-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.IPSecVPNSessionState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ipsecVpnSessionId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String ipsecVpnSessionId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.IPSecVPNSessionState> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
