/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.alb.controller_nodes.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.alb.controller_nodes;

public interface Cluster extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.alb.controller_nodes.ClusterTypes {

    /**
     * Returns information about Advanced Load Balancer controller cluster status
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @return com.vmware.nsx_policy.model.ALBControllerClusterInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerClusterInfo get(java.lang.String clusteringId);

    /**
     * Returns information about Advanced Load Balancer controller cluster status
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ALBControllerClusterInfo
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerClusterInfo get(java.lang.String clusteringId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about Advanced Load Balancer controller cluster status
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerClusterInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String clusteringId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerClusterInfo> asyncCallback);

    /**
     * Returns information about Advanced Load Balancer controller cluster status
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerClusterInfo
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String clusteringId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerClusterInfo> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Re-trigger clustering for Advanced Load Balancer Nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @return com.vmware.nsx_policy.model.ALBControllerClusterTrigger
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerClusterTrigger update(java.lang.String clusteringId);

    /**
     * Re-trigger clustering for Advanced Load Balancer Nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ALBControllerClusterTrigger
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ALBControllerClusterTrigger update(java.lang.String clusteringId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Re-trigger clustering for Advanced Load Balancer Nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerClusterTrigger
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String clusteringId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerClusterTrigger> asyncCallback);

    /**
     * Re-trigger clustering for Advanced Load Balancer Nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ALBControllerClusterTrigger
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusteringId Unique Id for NSX Advanced Load Balancer Controller Cluster used in VCF managed
     * NSX. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String clusteringId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ALBControllerClusterTrigger> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
