/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra;

public interface Crls extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.CrlsTypes {

    /**
     * Deletes an existing CRL.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param crlId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String crlId);

    /**
     * Deletes an existing CRL.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param crlId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String crlId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes an existing CRL.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String crlId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes an existing CRL.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String crlId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the specified CRL. For additional information, include
     * the ?details=true modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param crlId (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @return com.vmware.nsx_policy.model.TlsCrl
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TlsCrl get(java.lang.String crlId, java.lang.Boolean details);

    /**
     * Returns information about the specified CRL. For additional information, include
     * the ?details=true modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param crlId (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.TlsCrl
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TlsCrl get(java.lang.String crlId, java.lang.Boolean details, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the specified CRL. For additional information, include
     * the ?details=true modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TlsCrl
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String crlId, java.lang.Boolean details, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TlsCrl> asyncCallback);

    /**
     * Returns information about the specified CRL. For additional information, include
     * the ?details=true modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TlsCrl
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String crlId, java.lang.Boolean details, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TlsCrl> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Adds a new certificate revocation list (CRLs). The CRL is used to verify the
     * client certificate status against the revocation lists published by the CA. For
     * this reason, the administrator needs to add the CRL in certificate repository as
     * well. A CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
     * (crl_type=OneCRL). If crl_type is not specified, it is auto-detected based on
     * the presence of fields pem_encoded or one_crl. An X.509 CRL can contain a single
     * CRL or multiple CRLs depending on the PEM data. - Single CRL: a single CRL is
     * created with the given id. - Composite CRL: multiple CRLs are generated. Each of
     * the CRL is created with an id generated based on the given id. First CRL is
     * created with crl-id, second with crl-id-1, third with crl-id-2, etc.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @return com.vmware.nsx_policy.model.TlsCrlListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TlsCrlListResult importcrl(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl);

    /**
     * Adds a new certificate revocation list (CRLs). The CRL is used to verify the
     * client certificate status against the revocation lists published by the CA. For
     * this reason, the administrator needs to add the CRL in certificate repository as
     * well. A CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
     * (crl_type=OneCRL). If crl_type is not specified, it is auto-detected based on
     * the presence of fields pem_encoded or one_crl. An X.509 CRL can contain a single
     * CRL or multiple CRLs depending on the PEM data. - Single CRL: a single CRL is
     * created with the given id. - Composite CRL: multiple CRLs are generated. Each of
     * the CRL is created with an id generated based on the given id. First CRL is
     * created with crl-id, second with crl-id-1, third with crl-id-2, etc.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.TlsCrlListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TlsCrlListResult importcrl(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Adds a new certificate revocation list (CRLs). The CRL is used to verify the
     * client certificate status against the revocation lists published by the CA. For
     * this reason, the administrator needs to add the CRL in certificate repository as
     * well. A CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
     * (crl_type=OneCRL). If crl_type is not specified, it is auto-detected based on
     * the presence of fields pem_encoded or one_crl. An X.509 CRL can contain a single
     * CRL or multiple CRLs depending on the PEM data. - Single CRL: a single CRL is
     * created with the given id. - Composite CRL: multiple CRLs are generated. Each of
     * the CRL is created with an id generated based on the given id. First CRL is
     * created with crl-id, second with crl-id-1, third with crl-id-2, etc.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TlsCrlListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void importcrl(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TlsCrlListResult> asyncCallback);

    /**
     * Adds a new certificate revocation list (CRLs). The CRL is used to verify the
     * client certificate status against the revocation lists published by the CA. For
     * this reason, the administrator needs to add the CRL in certificate repository as
     * well. A CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
     * (crl_type=OneCRL). If crl_type is not specified, it is auto-detected based on
     * the presence of fields pem_encoded or one_crl. An X.509 CRL can contain a single
     * CRL or multiple CRLs depending on the PEM data. - Single CRL: a single CRL is
     * created with the given id. - Composite CRL: multiple CRLs are generated. Each of
     * the CRL is created with an id generated based on the given id. First CRL is
     * created with crl-id, second with crl-id-1, third with crl-id-2, etc.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TlsCrlListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void importcrl(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TlsCrlListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all CRLs. For additional information, include the
     * ?details=true modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @return com.vmware.nsx_policy.model.TlsCrlListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TlsCrlListResult list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type);

    /**
     * Returns information about all CRLs. For additional information, include the
     * ?details=true modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.TlsCrlListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TlsCrlListResult list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all CRLs. For additional information, include the
     * ?details=true modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TlsCrlListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TlsCrlListResult> asyncCallback);

    /**
     * Returns information about all CRLs. For additional information, include the
     * ?details=true modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TlsCrlListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TlsCrlListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create or patch a Certificate Revocation List for the given id. The CRL is used
     * to verify the client certificate status against the revocation lists published
     * by the CA. For this reason, the administrator needs to add the CRL in
     * certificate repository as well. The CRL must contain PEM data for a single CRL.
     * A CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
     * (crl_type=OneCRL). If crl_type is not specified, it is auto-detected based on
     * the presence of fields pem_encoded or one_crl.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl);

    /**
     * Create or patch a Certificate Revocation List for the given id. The CRL is used
     * to verify the client certificate status against the revocation lists published
     * by the CA. For this reason, the administrator needs to add the CRL in
     * certificate repository as well. The CRL must contain PEM data for a single CRL.
     * A CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
     * (crl_type=OneCRL). If crl_type is not specified, it is auto-detected based on
     * the presence of fields pem_encoded or one_crl.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create or patch a Certificate Revocation List for the given id. The CRL is used
     * to verify the client certificate status against the revocation lists published
     * by the CA. For this reason, the administrator needs to add the CRL in
     * certificate repository as well. The CRL must contain PEM data for a single CRL.
     * A CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
     * (crl_type=OneCRL). If crl_type is not specified, it is auto-detected based on
     * the presence of fields pem_encoded or one_crl.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Create or patch a Certificate Revocation List for the given id. The CRL is used
     * to verify the client certificate status against the revocation lists published
     * by the CA. For this reason, the administrator needs to add the CRL in
     * certificate repository as well. The CRL must contain PEM data for a single CRL.
     * A CRL can be in the PEM X.509 format (crl_type=X509) or JSON OneCRL
     * (crl_type=OneCRL). If crl_type is not specified, it is auto-detected based on
     * the presence of fields pem_encoded or one_crl.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create or replace a Certificate Revocation List for the given id. The CRL is
     * used to verify the client certificate status against the revocation lists
     * published by the CA. For this reason, the administrator needs to add the CRL in
     * certificate repository as well. The CRL must contain PEM data for a single CRL.
     * Revision is required. A CRL can be in the PEM X.509 format (crl_type=X509) or
     * JSON OneCRL (crl_type=OneCRL). If crl_type is not specified, it is auto-detected
     * based on the presence of fields pem_encoded or one_crl.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @return com.vmware.nsx_policy.model.TlsCrl
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TlsCrl update(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl);

    /**
     * Create or replace a Certificate Revocation List for the given id. The CRL is
     * used to verify the client certificate status against the revocation lists
     * published by the CA. For this reason, the administrator needs to add the CRL in
     * certificate repository as well. The CRL must contain PEM data for a single CRL.
     * Revision is required. A CRL can be in the PEM X.509 format (crl_type=X509) or
     * JSON OneCRL (crl_type=OneCRL). If crl_type is not specified, it is auto-detected
     * based on the presence of fields pem_encoded or one_crl.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.TlsCrl
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.TlsCrl update(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create or replace a Certificate Revocation List for the given id. The CRL is
     * used to verify the client certificate status against the revocation lists
     * published by the CA. For this reason, the administrator needs to add the CRL in
     * certificate repository as well. The CRL must contain PEM data for a single CRL.
     * Revision is required. A CRL can be in the PEM X.509 format (crl_type=X509) or
     * JSON OneCRL (crl_type=OneCRL). If crl_type is not specified, it is auto-detected
     * based on the presence of fields pem_encoded or one_crl.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TlsCrl
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TlsCrl> asyncCallback);

    /**
     * Create or replace a Certificate Revocation List for the given id. The CRL is
     * used to verify the client certificate status against the revocation lists
     * published by the CA. For this reason, the administrator needs to add the CRL in
     * certificate repository as well. The CRL must contain PEM data for a single CRL.
     * Revision is required. A CRL can be in the PEM X.509 format (crl_type=X509) or
     * JSON OneCRL (crl_type=OneCRL). If crl_type is not specified, it is auto-detected
     * based on the presence of fields pem_encoded or one_crl.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.TlsCrl
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param crlId (required)
     * @param tlsCrl (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String crlId, com.vmware.nsx_policy.model.TlsCrl tlsCrl, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.TlsCrl> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
