/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra;

public interface IdentityFirewallStores extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.IdentityFirewallStoresTypes {

    /**
     * If the firewall identity store is removed, it will stop the identity store
     * synchronization. User will not be able to define new IDFW rules
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String identityFirewallStoreId, java.lang.String enforcementPointPath);

    /**
     * If the firewall identity store is removed, it will stop the identity store
     * synchronization. User will not be able to define new IDFW rules
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String identityFirewallStoreId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If the firewall identity store is removed, it will stop the identity store
     * synchronization. User will not be able to define new IDFW rules
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String identityFirewallStoreId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If the firewall identity store is removed, it will stop the identity store
     * synchronization. User will not be able to define new IDFW rules
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String identityFirewallStoreId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Return a firewall identity store based on the store identifier
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param identityFirewallStoreId identity firewall store ID (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @return com.vmware.nsx_policy.model.IdentityFirewallStore
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure get(java.lang.String identityFirewallStoreId, java.lang.String enforcementPointPath);

    /**
     * Return a firewall identity store based on the store identifier
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param identityFirewallStoreId identity firewall store ID (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IdentityFirewallStore
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure get(java.lang.String identityFirewallStoreId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return a firewall identity store based on the store identifier
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IdentityFirewallStore
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identityFirewallStoreId identity firewall store ID (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String identityFirewallStoreId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Return a firewall identity store based on the store identifier
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IdentityFirewallStore
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identityFirewallStoreId identity firewall store ID (required)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String identityFirewallStoreId, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List all firewall identity stores
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.IdentityFirewallStoreListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.IdentityFirewallStoreListResults list(java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * List all firewall identity stores
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IdentityFirewallStoreListResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.IdentityFirewallStoreListResults list(java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List all firewall identity stores
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IdentityFirewallStoreListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IdentityFirewallStoreListResults> asyncCallback);

    /**
     * List all firewall identity stores
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IdentityFirewallStoreListResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.IdentityFirewallStoreListResults> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If a firewall identity store with the firewall-identity-store-id is not already
     * present, create a new firewall identity store. If it already exists, update the
     * firewall identity store with specified attributes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param identityFirewallStore (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String identityFirewallStoreId, com.vmware.vapi.bindings.Structure identityFirewallStore, java.lang.String enforcementPointPath);

    /**
     * If a firewall identity store with the firewall-identity-store-id is not already
     * present, create a new firewall identity store. If it already exists, update the
     * firewall identity store with specified attributes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param identityFirewallStore (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String identityFirewallStoreId, com.vmware.vapi.bindings.Structure identityFirewallStore, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If a firewall identity store with the firewall-identity-store-id is not already
     * present, create a new firewall identity store. If it already exists, update the
     * firewall identity store with specified attributes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param identityFirewallStore (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String identityFirewallStoreId, com.vmware.vapi.bindings.Structure identityFirewallStore, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * If a firewall identity store with the firewall-identity-store-id is not already
     * present, create a new firewall identity store. If it already exists, update the
     * firewall identity store with specified attributes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param identityFirewallStore (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String identityFirewallStoreId, com.vmware.vapi.bindings.Structure identityFirewallStore, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * If a firewall identity store with the firewall-identity-store-id is not already
     * present, create a new firewall identity store. If it already exists, replace the
     * firewall identity store instance with the new object.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param identityFirewallStore (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @return com.vmware.nsx_policy.model.IdentityFirewallStore
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String identityFirewallStoreId, com.vmware.vapi.bindings.Structure identityFirewallStore, java.lang.String enforcementPointPath);

    /**
     * If a firewall identity store with the firewall-identity-store-id is not already
     * present, create a new firewall identity store. If it already exists, replace the
     * firewall identity store instance with the new object.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param identityFirewallStore (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.IdentityFirewallStore
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String identityFirewallStoreId, com.vmware.vapi.bindings.Structure identityFirewallStore, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * If a firewall identity store with the firewall-identity-store-id is not already
     * present, create a new firewall identity store. If it already exists, replace the
     * firewall identity store instance with the new object.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IdentityFirewallStore
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param identityFirewallStore (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String identityFirewallStoreId, com.vmware.vapi.bindings.Structure identityFirewallStore, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * If a firewall identity store with the firewall-identity-store-id is not already
     * present, create a new firewall identity store. If it already exists, replace the
     * firewall identity store instance with the new object.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.IdentityFirewallStore
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identityFirewallStoreId firewall identity store ID (required)
     * @param identityFirewallStore (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_policy.model.IdentityFirewallStore}.
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String identityFirewallStoreId, com.vmware.vapi.bindings.Structure identityFirewallStore, java.lang.String enforcementPointPath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
