/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.domains.groups.members.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.domains.groups.members;

public interface ConsolidatedEffectiveIpAddresses extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.domains.groups.members.ConsolidatedEffectiveIpAddressesTypes {

    /**
     * Returns the consolidated effective IP address members of the specified Group.
     * This is applicable in the case of a federated/NSX+ environment. The response
     * includes a site-wise list of static and dynamically translated effective IP
     * address members. If the group evaluation on a site is empty, the response will
     * contain the site-id with empty list. If a group is a reference group on a site,
     * then its consolidated effective IP response will contain the effective IPs from
     * other sites, and the response will contain an empty list of IPs for the sites
     * where is it a reference group. This API is applicable only for Global and NSX+
     * Groups that contain (either directly or via nesting) VirtualMachine, VIF,
     * Segment, SegmentPort, or IPSet member types. Please use the cursor value in the
     * response to fetch the next page. If there is no cursor value in the response, it
     * indicates that it is the last page of results for the query.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param domainId Domain id (required)
     * @param groupId Group Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipFilter IP address, range, or subnet (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param siteId UUID of the site from which the effective IP addresses are to be fetched
     * (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_policy.model.ConsolidatedEffectiveIPAddressMemberListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ConsolidatedEffectiveIPAddressMemberListResult list(java.lang.String domainId, java.lang.String groupId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.String ipFilter, java.lang.Long pageSize, java.lang.String siteId, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns the consolidated effective IP address members of the specified Group.
     * This is applicable in the case of a federated/NSX+ environment. The response
     * includes a site-wise list of static and dynamically translated effective IP
     * address members. If the group evaluation on a site is empty, the response will
     * contain the site-id with empty list. If a group is a reference group on a site,
     * then its consolidated effective IP response will contain the effective IPs from
     * other sites, and the response will contain an empty list of IPs for the sites
     * where is it a reference group. This API is applicable only for Global and NSX+
     * Groups that contain (either directly or via nesting) VirtualMachine, VIF,
     * Segment, SegmentPort, or IPSet member types. Please use the cursor value in the
     * response to fetch the next page. If there is no cursor value in the response, it
     * indicates that it is the last page of results for the query.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param domainId Domain id (required)
     * @param groupId Group Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipFilter IP address, range, or subnet (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param siteId UUID of the site from which the effective IP addresses are to be fetched
     * (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ConsolidatedEffectiveIPAddressMemberListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ConsolidatedEffectiveIPAddressMemberListResult list(java.lang.String domainId, java.lang.String groupId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.String ipFilter, java.lang.Long pageSize, java.lang.String siteId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the consolidated effective IP address members of the specified Group.
     * This is applicable in the case of a federated/NSX+ environment. The response
     * includes a site-wise list of static and dynamically translated effective IP
     * address members. If the group evaluation on a site is empty, the response will
     * contain the site-id with empty list. If a group is a reference group on a site,
     * then its consolidated effective IP response will contain the effective IPs from
     * other sites, and the response will contain an empty list of IPs for the sites
     * where is it a reference group. This API is applicable only for Global and NSX+
     * Groups that contain (either directly or via nesting) VirtualMachine, VIF,
     * Segment, SegmentPort, or IPSet member types. Please use the cursor value in the
     * response to fetch the next page. If there is no cursor value in the response, it
     * indicates that it is the last page of results for the query.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ConsolidatedEffectiveIPAddressMemberListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain id (required)
     * @param groupId Group Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipFilter IP address, range, or subnet (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param siteId UUID of the site from which the effective IP addresses are to be fetched
     * (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String domainId, java.lang.String groupId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.String ipFilter, java.lang.Long pageSize, java.lang.String siteId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ConsolidatedEffectiveIPAddressMemberListResult> asyncCallback);

    /**
     * Returns the consolidated effective IP address members of the specified Group.
     * This is applicable in the case of a federated/NSX+ environment. The response
     * includes a site-wise list of static and dynamically translated effective IP
     * address members. If the group evaluation on a site is empty, the response will
     * contain the site-id with empty list. If a group is a reference group on a site,
     * then its consolidated effective IP response will contain the effective IPs from
     * other sites, and the response will contain an empty list of IPs for the sites
     * where is it a reference group. This API is applicable only for Global and NSX+
     * Groups that contain (either directly or via nesting) VirtualMachine, VIF,
     * Segment, SegmentPort, or IPSet member types. Please use the cursor value in the
     * response to fetch the next page. If there is no cursor value in the response, it
     * indicates that it is the last page of results for the query.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ConsolidatedEffectiveIPAddressMemberListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param domainId Domain id (required)
     * @param groupId Group Id (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param enforcementPointPath String Path of the enforcement point (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param ipFilter IP address, range, or subnet (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param siteId UUID of the site from which the effective IP addresses are to be fetched
     * (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String domainId, java.lang.String groupId, java.lang.String cursor, java.lang.String enforcementPointPath, java.lang.String includedFields, java.lang.String ipFilter, java.lang.Long pageSize, java.lang.String siteId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ConsolidatedEffectiveIPAddressMemberListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
