/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_policy.infra.realized_state.
 * Used by client-side stubs.
 */

package com.vmware.nsx_policy.infra.realized_state;

public interface Status extends com.vmware.vapi.bindings.Service, com.vmware.nsx_policy.infra.realized_state.StatusTypes {

    /**
     * Get Consolidated Status of an intent object (with or without enforcement
     * specific status details). The request is evaluated as follows: - <intent_path>:
     * the request is evaluated on all enforcement points for the given intent without
     * enforcement point specific details. - <intent_path, include_enforced_status>:
     * the request is evaluated on all enforcement points for the given intent with
     * enforcement point specific details.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param intentPath Policy Path of the intent object (required)
     * @param includeEnforcedStatus Include Enforced Status Flag (optional, default to false)
     * @param sitePath Policy Path of the site from where the realization status needs to be fetched
     * (optional)
     * @return com.vmware.nsx_policy.model.ConsolidatedRealizedStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ConsolidatedRealizedStatus get(java.lang.String intentPath, java.lang.Boolean includeEnforcedStatus, java.lang.String sitePath);

    /**
     * Get Consolidated Status of an intent object (with or without enforcement
     * specific status details). The request is evaluated as follows: - <intent_path>:
     * the request is evaluated on all enforcement points for the given intent without
     * enforcement point specific details. - <intent_path, include_enforced_status>:
     * the request is evaluated on all enforcement points for the given intent with
     * enforcement point specific details.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param intentPath Policy Path of the intent object (required)
     * @param includeEnforcedStatus Include Enforced Status Flag (optional, default to false)
     * @param sitePath Policy Path of the site from where the realization status needs to be fetched
     * (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_policy.model.ConsolidatedRealizedStatus
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_policy.model.ConsolidatedRealizedStatus get(java.lang.String intentPath, java.lang.Boolean includeEnforcedStatus, java.lang.String sitePath, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get Consolidated Status of an intent object (with or without enforcement
     * specific status details). The request is evaluated as follows: - <intent_path>:
     * the request is evaluated on all enforcement points for the given intent without
     * enforcement point specific details. - <intent_path, include_enforced_status>:
     * the request is evaluated on all enforcement points for the given intent with
     * enforcement point specific details.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ConsolidatedRealizedStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param intentPath Policy Path of the intent object (required)
     * @param includeEnforcedStatus Include Enforced Status Flag (optional, default to false)
     * @param sitePath Policy Path of the site from where the realization status needs to be fetched
     * (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String intentPath, java.lang.Boolean includeEnforcedStatus, java.lang.String sitePath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ConsolidatedRealizedStatus> asyncCallback);

    /**
     * Get Consolidated Status of an intent object (with or without enforcement
     * specific status details). The request is evaluated as follows: - <intent_path>:
     * the request is evaluated on all enforcement points for the given intent without
     * enforcement point specific details. - <intent_path, include_enforced_status>:
     * the request is evaluated on all enforcement points for the given intent with
     * enforcement point specific details.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_policy.model.ConsolidatedRealizedStatus
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param intentPath Policy Path of the intent object (required)
     * @param includeEnforcedStatus Include Enforced Status Flag (optional, default to false)
     * @param sitePath Policy Path of the site from where the realization status needs to be fetched
     * (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String intentPath, java.lang.Boolean includeEnforcedStatus, java.lang.String sitePath, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_policy.model.ConsolidatedRealizedStatus> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
